// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The field that CloudFormation will change, such as the name of a resource's
 * property, and whether the resource will be recreated.
 */
class ResourceTargetDefinition private constructor(builder: Builder) {
    /**
     * Indicates which resource attribute is triggering this update, such as a change in the
     * resource attribute's Metadata, Properties, or
     * Tags.
     */
    val attribute: aws.sdk.kotlin.services.cloudformation.model.ResourceAttribute? = builder.attribute
    /**
     * If the Attribute value is Properties, the name of the
     * property. For all other attributes, the value is null.
     */
    val name: kotlin.String? = builder.name
    /**
     * If the Attribute value is Properties, indicates whether a
     * change to this property causes the resource to be recreated. The value can be
     * Never, Always, or Conditionally. To determine the
     * conditions for a Conditionally recreation, see the update behavior for that
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property in the CloudFormation User Guide.
     */
    val requiresRecreation: aws.sdk.kotlin.services.cloudformation.model.RequiresRecreation? = builder.requiresRecreation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceTargetDefinition(")
        append("attribute=$attribute,")
        append("name=$name,")
        append("requiresRecreation=$requiresRecreation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requiresRecreation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceTargetDefinition

        if (attribute != other.attribute) return false
        if (name != other.name) return false
        if (requiresRecreation != other.requiresRecreation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates which resource attribute is triggering this update, such as a change in the
         * resource attribute's Metadata, Properties, or
         * Tags.
         */
        var attribute: aws.sdk.kotlin.services.cloudformation.model.ResourceAttribute? = null
        /**
         * If the Attribute value is Properties, the name of the
         * property. For all other attributes, the value is null.
         */
        var name: kotlin.String? = null
        /**
         * If the Attribute value is Properties, indicates whether a
         * change to this property causes the resource to be recreated. The value can be
         * Never, Always, or Conditionally. To determine the
         * conditions for a Conditionally recreation, see the update behavior for that
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property in the CloudFormation User Guide.
         */
        var requiresRecreation: aws.sdk.kotlin.services.cloudformation.model.RequiresRecreation? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition) : this() {
            this.attribute = x.attribute
            this.name = x.name
            this.requiresRecreation = x.requiresRecreation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = ResourceTargetDefinition(this)
    }
}
