// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * For a resource with Modify as the action, the ResourceChange
 * structure describes the changes CloudFormation will make to that resource.
 */
class ResourceChangeDetail private constructor(builder: Builder) {
    /**
     * The identity of the entity that triggered this change. This entity is a member of the
     * group that's specified by the ChangeSource field. For example, if you modified
     * the value of the KeyPairName parameter, the CausingEntity is the
     * name of the parameter (KeyPairName).
     * If the ChangeSource value is DirectModification, no value is
     * given for CausingEntity.
     */
    val causingEntity: kotlin.String? = builder.causingEntity
    /**
     * The group to which the CausingEntity value belongs. There are five entity
     * groups:
     *
     *
     *
     * ResourceReference entities are Ref intrinsic functions that
     * refer to resources in the template, such as { "Ref" : "MyEC2InstanceResource"
     * }.
     *
     *
     * ParameterReference entities are Ref intrinsic functions
     * that get template parameter values, such as { "Ref" : "MyPasswordParameter"
     * }.
     *
     *
     * ResourceAttribute entities are Fn::GetAtt intrinsic
     * functions that get resource attribute values, such as { "Fn::GetAtt" : &#91;
     * "MyEC2InstanceResource", "PublicDnsName" &#93; }.
     *
     *
     * DirectModification entities are changes that are made directly to the
     * template.
     *
     *
     * Automatic entities are AWS::CloudFormation::Stack resource
     * types, which are also known as nested stacks. If you made no changes to the
     * AWS::CloudFormation::Stack resource, CloudFormation sets the
     * ChangeSource to Automatic because the nested stack's
     * template might have changed. Changes to a nested stack's template aren't visible to
     * CloudFormation until you run an update on the parent stack.
     */
    val changeSource: aws.sdk.kotlin.services.cloudformation.model.ChangeSource? = builder.changeSource
    /**
     * Indicates whether CloudFormation can determine the target value, and whether the
     * target value will change before you execute a change set.
     * For Static evaluations, CloudFormation can determine that the target
     * value will change, and its value. For example, if you directly modify the
     * InstanceType property of an EC2 instance, CloudFormation knows that
     * this property value will change, and its value, so this is a Static
     * evaluation.
     * For Dynamic evaluations, can't determine the target value because it
     * depends on the result of an intrinsic function, such as a Ref or
     * Fn::GetAtt intrinsic function, when the stack is updated. For example, if
     * your template includes a reference to a resource that's conditionally recreated, the value
     * of the reference (the physical ID of the resource) might change, depending on if the
     * resource is recreated. If the resource is recreated, it will have a new physical ID, so all
     * references to that resource will also be updated.
     */
    val evaluation: aws.sdk.kotlin.services.cloudformation.model.EvaluationType? = builder.evaluation
    /**
     * A ResourceTargetDefinition structure that describes the field that CloudFormation will change and whether the resource will be recreated.
     */
    val target: aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceChangeDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceChangeDetail(")
        append("causingEntity=$causingEntity,")
        append("changeSource=$changeSource,")
        append("evaluation=$evaluation,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = causingEntity?.hashCode() ?: 0
        result = 31 * result + (changeSource?.hashCode() ?: 0)
        result = 31 * result + (evaluation?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceChangeDetail

        if (causingEntity != other.causingEntity) return false
        if (changeSource != other.changeSource) return false
        if (evaluation != other.evaluation) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceChangeDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identity of the entity that triggered this change. This entity is a member of the
         * group that's specified by the ChangeSource field. For example, if you modified
         * the value of the KeyPairName parameter, the CausingEntity is the
         * name of the parameter (KeyPairName).
         * If the ChangeSource value is DirectModification, no value is
         * given for CausingEntity.
         */
        var causingEntity: kotlin.String? = null
        /**
         * The group to which the CausingEntity value belongs. There are five entity
         * groups:
         *
         *
         *
         * ResourceReference entities are Ref intrinsic functions that
         * refer to resources in the template, such as { "Ref" : "MyEC2InstanceResource"
         * }.
         *
         *
         * ParameterReference entities are Ref intrinsic functions
         * that get template parameter values, such as { "Ref" : "MyPasswordParameter"
         * }.
         *
         *
         * ResourceAttribute entities are Fn::GetAtt intrinsic
         * functions that get resource attribute values, such as { "Fn::GetAtt" : &#91;
         * "MyEC2InstanceResource", "PublicDnsName" &#93; }.
         *
         *
         * DirectModification entities are changes that are made directly to the
         * template.
         *
         *
         * Automatic entities are AWS::CloudFormation::Stack resource
         * types, which are also known as nested stacks. If you made no changes to the
         * AWS::CloudFormation::Stack resource, CloudFormation sets the
         * ChangeSource to Automatic because the nested stack's
         * template might have changed. Changes to a nested stack's template aren't visible to
         * CloudFormation until you run an update on the parent stack.
         */
        var changeSource: aws.sdk.kotlin.services.cloudformation.model.ChangeSource? = null
        /**
         * Indicates whether CloudFormation can determine the target value, and whether the
         * target value will change before you execute a change set.
         * For Static evaluations, CloudFormation can determine that the target
         * value will change, and its value. For example, if you directly modify the
         * InstanceType property of an EC2 instance, CloudFormation knows that
         * this property value will change, and its value, so this is a Static
         * evaluation.
         * For Dynamic evaluations, can't determine the target value because it
         * depends on the result of an intrinsic function, such as a Ref or
         * Fn::GetAtt intrinsic function, when the stack is updated. For example, if
         * your template includes a reference to a resource that's conditionally recreated, the value
         * of the reference (the physical ID of the resource) might change, depending on if the
         * resource is recreated. If the resource is recreated, it will have a new physical ID, so all
         * references to that resource will also be updated.
         */
        var evaluation: aws.sdk.kotlin.services.cloudformation.model.EvaluationType? = null
        /**
         * A ResourceTargetDefinition structure that describes the field that CloudFormation will change and whether the resource will be recreated.
         */
        var target: aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceChangeDetail) : this() {
            this.causingEntity = x.causingEntity
            this.changeSource = x.changeSource
            this.evaluation = x.evaluation
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceChangeDetail = ResourceChangeDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition] inside the given [block]
         */
        fun target(block: aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition.invoke(block)
        }
    }
}
