// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The ResourceChange structure describes the resource and the action that
 * CloudFormation will perform on it if you execute this change set.
 */
class ResourceChange private constructor(builder: Builder) {
    /**
     * The action that CloudFormation takes on the resource, such as Add (adds
     * a new resource), Modify (changes a resource), Remove (deletes a
     * resource), Import (imports a resource), or Dynamic (exact action
     * for the resource can't be determined).
     */
    val action: aws.sdk.kotlin.services.cloudformation.model.ChangeAction? = builder.action
    /**
     * The change set ID of the nested change set.
     */
    val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * For the Modify action, a list of ResourceChangeDetail
     * structures that describes the changes that CloudFormation will make to the
     * resource.
     */
    val details: List<ResourceChangeDetail>? = builder.details
    /**
     * The resource's logical ID, which is defined in the stack's template.
     */
    val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * Contains information about the module from which the resource was created, if the
     * resource was created from a module included in the stack template.
     */
    val moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = builder.moduleInfo
    /**
     * The resource's physical ID (resource name). Resources that you are adding don't have
     * physical IDs because they haven't been created.
     */
    val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * For the Modify action, indicates whether CloudFormation will replace
     * the resource by creating a new one and deleting the old one. This value depends on the
     * value of the RequiresRecreation property in the
     * ResourceTargetDefinition structure. For example, if the
     * RequiresRecreation field is Always and the
     * Evaluation field is Static, Replacement is
     * True. If the RequiresRecreation field is Always
     * and the Evaluation field is Dynamic, Replacement is
     * Conditionally.
     * If you have multiple changes with different RequiresRecreation values, the
     * Replacement value depends on the change with the most impact. A
     * RequiresRecreation value of Always has the most impact,
     * followed by Conditionally, and then Never.
     */
    val replacement: aws.sdk.kotlin.services.cloudformation.model.Replacement? = builder.replacement
    /**
     * The type of CloudFormation resource, such as AWS::S3::Bucket.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * For the Modify action, indicates which resource attribute is triggering
     * this update, such as a change in the resource attribute's Metadata,
     * Properties, or Tags.
     */
    val scope: List<ResourceAttribute>? = builder.scope

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceChange(")
        append("action=$action,")
        append("changeSetId=$changeSetId,")
        append("details=$details,")
        append("logicalResourceId=$logicalResourceId,")
        append("moduleInfo=$moduleInfo,")
        append("physicalResourceId=$physicalResourceId,")
        append("replacement=$replacement,")
        append("resourceType=$resourceType,")
        append("scope=$scope)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (changeSetId?.hashCode() ?: 0)
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (moduleInfo?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (replacement?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceChange

        if (action != other.action) return false
        if (changeSetId != other.changeSetId) return false
        if (details != other.details) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (moduleInfo != other.moduleInfo) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (replacement != other.replacement) return false
        if (resourceType != other.resourceType) return false
        if (scope != other.scope) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action that CloudFormation takes on the resource, such as Add (adds
         * a new resource), Modify (changes a resource), Remove (deletes a
         * resource), Import (imports a resource), or Dynamic (exact action
         * for the resource can't be determined).
         */
        var action: aws.sdk.kotlin.services.cloudformation.model.ChangeAction? = null
        /**
         * The change set ID of the nested change set.
         */
        var changeSetId: kotlin.String? = null
        /**
         * For the Modify action, a list of ResourceChangeDetail
         * structures that describes the changes that CloudFormation will make to the
         * resource.
         */
        var details: List<ResourceChangeDetail>? = null
        /**
         * The resource's logical ID, which is defined in the stack's template.
         */
        var logicalResourceId: kotlin.String? = null
        /**
         * Contains information about the module from which the resource was created, if the
         * resource was created from a module included in the stack template.
         */
        var moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = null
        /**
         * The resource's physical ID (resource name). Resources that you are adding don't have
         * physical IDs because they haven't been created.
         */
        var physicalResourceId: kotlin.String? = null
        /**
         * For the Modify action, indicates whether CloudFormation will replace
         * the resource by creating a new one and deleting the old one. This value depends on the
         * value of the RequiresRecreation property in the
         * ResourceTargetDefinition structure. For example, if the
         * RequiresRecreation field is Always and the
         * Evaluation field is Static, Replacement is
         * True. If the RequiresRecreation field is Always
         * and the Evaluation field is Dynamic, Replacement is
         * Conditionally.
         * If you have multiple changes with different RequiresRecreation values, the
         * Replacement value depends on the change with the most impact. A
         * RequiresRecreation value of Always has the most impact,
         * followed by Conditionally, and then Never.
         */
        var replacement: aws.sdk.kotlin.services.cloudformation.model.Replacement? = null
        /**
         * The type of CloudFormation resource, such as AWS::S3::Bucket.
         */
        var resourceType: kotlin.String? = null
        /**
         * For the Modify action, indicates which resource attribute is triggering
         * this update, such as a change in the resource attribute's Metadata,
         * Properties, or Tags.
         */
        var scope: List<ResourceAttribute>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceChange) : this() {
            this.action = x.action
            this.changeSetId = x.changeSetId
            this.details = x.details
            this.logicalResourceId = x.logicalResourceId
            this.moduleInfo = x.moduleInfo
            this.physicalResourceId = x.physicalResourceId
            this.replacement = x.replacement
            this.resourceType = x.resourceType
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = ResourceChange(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ModuleInfo] inside the given [block]
         */
        fun moduleInfo(block: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.Builder.() -> kotlin.Unit) {
            this.moduleInfo = aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.invoke(block)
        }
    }
}
