// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * For extensions that are modules, a public third-party extension that must be activated
 * in your account in order for the module itself to be activated.
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html#module-enabling">Activating public
 * modules for use in your account in the CloudFormation User
 * Guide.
 */
class RequiredActivatedType private constructor(builder: Builder) {
    /**
     * The type name of the public extension.
     * If you specified a TypeNameAlias when enabling the extension in this
     * account and region, CloudFormation treats that alias as the extension's type name
     * within the account and region, not the type name of the public extension. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions in the
     * CloudFormation User Guide.
     */
    val originalTypeName: kotlin.String? = builder.originalTypeName
    /**
     * The publisher ID of the extension publisher.
     */
    val publisherId: kotlin.String? = builder.publisherId
    /**
     * A list of the major versions of the extension type that the macro supports.
     */
    val supportedMajorVersions: List<Int>? = builder.supportedMajorVersions
    /**
     * An alias assigned to the public extension, in this account and region. If you specify an
     * alias for the extension, CloudFormation treats the alias as the extension type
     * name within this account and region. You must use the alias to refer to the extension in
     * your templates, API calls, and CloudFormation console.
     */
    val typeNameAlias: kotlin.String? = builder.typeNameAlias

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequiredActivatedType(")
        append("originalTypeName=$originalTypeName,")
        append("publisherId=$publisherId,")
        append("supportedMajorVersions=$supportedMajorVersions,")
        append("typeNameAlias=$typeNameAlias)")
    }

    override fun hashCode(): kotlin.Int {
        var result = originalTypeName?.hashCode() ?: 0
        result = 31 * result + (publisherId?.hashCode() ?: 0)
        result = 31 * result + (supportedMajorVersions?.hashCode() ?: 0)
        result = 31 * result + (typeNameAlias?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequiredActivatedType

        if (originalTypeName != other.originalTypeName) return false
        if (publisherId != other.publisherId) return false
        if (supportedMajorVersions != other.supportedMajorVersions) return false
        if (typeNameAlias != other.typeNameAlias) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type name of the public extension.
         * If you specified a TypeNameAlias when enabling the extension in this
         * account and region, CloudFormation treats that alias as the extension's type name
         * within the account and region, not the type name of the public extension. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions in the
         * CloudFormation User Guide.
         */
        var originalTypeName: kotlin.String? = null
        /**
         * The publisher ID of the extension publisher.
         */
        var publisherId: kotlin.String? = null
        /**
         * A list of the major versions of the extension type that the macro supports.
         */
        var supportedMajorVersions: List<Int>? = null
        /**
         * An alias assigned to the public extension, in this account and region. If you specify an
         * alias for the extension, CloudFormation treats the alias as the extension type
         * name within this account and region. You must use the alias to refer to the extension in
         * your templates, API calls, and CloudFormation console.
         */
        var typeNameAlias: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType) : this() {
            this.originalTypeName = x.originalTypeName
            this.publisherId = x.publisherId
            this.supportedMajorVersions = x.supportedMajorVersions
            this.typeNameAlias = x.typeNameAlias
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType = RequiredActivatedType(this)
    }
}
