// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



class RegisterTypeRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that acts as an idempotency key for this registration request.
     * Specifying a client request token prevents CloudFormation from generating more
     * than one version of an extension from the same registration request, even if the request is
     * submitted multiple times.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the extension.
     * For CloudFormation to assume the specified execution role, the role must
     * contain a trust relationship with the CloudFormation service principle
     * (resources.cloudformation.amazonaws.com). For more information on adding
     * trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy in the Identity and Access Management User
     * Guide.
     * If your extension calls Amazon Web Services APIs in any of its handlers, you must create
     * an
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role
     * that includes the necessary
     * permissions to call those Amazon Web Services APIs, and provision that execution role in
     * your account. When CloudFormation needs to invoke the resource type handler,
     * CloudFormation assumes this execution role to create a temporary session token,
     * which it then passes to the resource type handler, thereby supplying your resource type
     * with the appropriate credentials.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Specifies logging configuration information for an extension.
     */
    val loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = builder.loggingConfig
    /**
     * A URL to the S3 bucket containing the extension project package that contains the
     * necessary files for the extension you want to register.
     * For information on generating a schema handler package for the extension you want to
     * register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit
     * in the CloudFormation CLI User Guide.
     *
     * The user registering the extension must be able to access the package in the S3
     * bucket. That's, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject permissions for the
     * schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
     * for Amazon S3 in the Identity and Access Management User
     * Guide.
     */
    val schemaHandlerPackage: kotlin.String? = builder.schemaHandlerPackage
    /**
     * The kind of extension.
     */
    val type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = builder.type
    /**
     * The name of the extension being registered.
     * We recommend that extension names adhere to the following patterns:
     *
     *
     * For resource types,
     * company_or_organization::service::type.
     *
     * For modules,
     * company_or_organization::service::type::MODULE.
     *
     *
     *
     *
     * The following organization namespaces are reserved and can't be used in your
     * extension names:
     *
     *
     *
     * Alexa
     *
     *
     *
     * AMZN
     *
     *
     *
     * Amazon
     *
     *
     *
     * AWS
     *
     *
     *
     * Custom
     *
     *
     *
     * Dev
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterTypeRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("executionRoleArn=$executionRoleArn,")
        append("loggingConfig=$loggingConfig,")
        append("schemaHandlerPackage=$schemaHandlerPackage,")
        append("type=$type,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (schemaHandlerPackage?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterTypeRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (loggingConfig != other.loggingConfig) return false
        if (schemaHandlerPackage != other.schemaHandlerPackage) return false
        if (type != other.type) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier that acts as an idempotency key for this registration request.
         * Specifying a client request token prevents CloudFormation from generating more
         * than one version of an extension from the same registration request, even if the request is
         * submitted multiple times.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the extension.
         * For CloudFormation to assume the specified execution role, the role must
         * contain a trust relationship with the CloudFormation service principle
         * (resources.cloudformation.amazonaws.com). For more information on adding
         * trust relationships, see <a href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy">Modifying a role trust policy in the Identity and Access Management User
         * Guide.
         * If your extension calls Amazon Web Services APIs in any of its handlers, you must create
         * an
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role
         * that includes the necessary
         * permissions to call those Amazon Web Services APIs, and provision that execution role in
         * your account. When CloudFormation needs to invoke the resource type handler,
         * CloudFormation assumes this execution role to create a temporary session token,
         * which it then passes to the resource type handler, thereby supplying your resource type
         * with the appropriate credentials.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * Specifies logging configuration information for an extension.
         */
        var loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = null
        /**
         * A URL to the S3 bucket containing the extension project package that contains the
         * necessary files for the extension you want to register.
         * For information on generating a schema handler package for the extension you want to
         * register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit
         * in the CloudFormation CLI User Guide.
         *
         * The user registering the extension must be able to access the package in the S3
         * bucket. That's, the user needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject permissions for the
         * schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
         * for Amazon S3 in the Identity and Access Management User
         * Guide.
         */
        var schemaHandlerPackage: kotlin.String? = null
        /**
         * The kind of extension.
         */
        var type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = null
        /**
         * The name of the extension being registered.
         * We recommend that extension names adhere to the following patterns:
         *
         *
         * For resource types,
         * company_or_organization::service::type.
         *
         * For modules,
         * company_or_organization::service::type::MODULE.
         *
         *
         *
         *
         * The following organization namespaces are reserved and can't be used in your
         * extension names:
         *
         *
         *
         * Alexa
         *
         *
         *
         * AMZN
         *
         *
         *
         * Amazon
         *
         *
         *
         * AWS
         *
         *
         *
         * Custom
         *
         *
         *
         * Dev
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.executionRoleArn = x.executionRoleArn
            this.loggingConfig = x.loggingConfig
            this.schemaHandlerPackage = x.schemaHandlerPackage
            this.type = x.type
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest = RegisterTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.LoggingConfig] inside the given [block]
         */
        fun loggingConfig(block: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.invoke(block)
        }
    }
}
