// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Information about a resource property whose actual value differs from its expected
 * value, as defined in the stack template and any values specified as template parameters.
 * These will be present only for resources whose StackResourceDriftStatus is
 * MODIFIED. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
 * Unregulated Configuration Changes to Stacks and Resources.
 */
class PropertyDifference private constructor(builder: Builder) {
    /**
     * The actual property value of the resource property.
     */
    val actualValue: kotlin.String? = builder.actualValue
    /**
     * The type of property difference.
     *
     *
     *
     * ADD: A value has been added to a resource property that's an array or
     * list data type.
     *
     *
     * REMOVE: The property has been removed from the current resource
     * configuration.
     *
     *
     * NOT_EQUAL: The current property value differs from its expected value
     * (as defined in the stack template and any values specified as template
     * parameters).
     */
    val differenceType: aws.sdk.kotlin.services.cloudformation.model.DifferenceType? = builder.differenceType
    /**
     * The expected property value of the resource property, as defined in the stack template
     * and any values specified as template parameters.
     */
    val expectedValue: kotlin.String? = builder.expectedValue
    /**
     * The fully-qualified path to the resource property.
     */
    val propertyPath: kotlin.String? = builder.propertyPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.PropertyDifference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PropertyDifference(")
        append("actualValue=$actualValue,")
        append("differenceType=$differenceType,")
        append("expectedValue=$expectedValue,")
        append("propertyPath=$propertyPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualValue?.hashCode() ?: 0
        result = 31 * result + (differenceType?.hashCode() ?: 0)
        result = 31 * result + (expectedValue?.hashCode() ?: 0)
        result = 31 * result + (propertyPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PropertyDifference

        if (actualValue != other.actualValue) return false
        if (differenceType != other.differenceType) return false
        if (expectedValue != other.expectedValue) return false
        if (propertyPath != other.propertyPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.PropertyDifference = Builder(this).apply(block).build()

    class Builder {
        /**
         * The actual property value of the resource property.
         */
        var actualValue: kotlin.String? = null
        /**
         * The type of property difference.
         *
         *
         *
         * ADD: A value has been added to a resource property that's an array or
         * list data type.
         *
         *
         * REMOVE: The property has been removed from the current resource
         * configuration.
         *
         *
         * NOT_EQUAL: The current property value differs from its expected value
         * (as defined in the stack template and any values specified as template
         * parameters).
         */
        var differenceType: aws.sdk.kotlin.services.cloudformation.model.DifferenceType? = null
        /**
         * The expected property value of the resource property, as defined in the stack template
         * and any values specified as template parameters.
         */
        var expectedValue: kotlin.String? = null
        /**
         * The fully-qualified path to the resource property.
         */
        var propertyPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.PropertyDifference) : this() {
            this.actualValue = x.actualValue
            this.differenceType = x.differenceType
            this.expectedValue = x.expectedValue
            this.propertyPath = x.propertyPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.PropertyDifference = PropertyDifference(this)
    }
}
