// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The Parameter data type.
 */
class Parameter private constructor(builder: Builder) {
    /**
     * The key associated with the parameter. If you don't specify a key and value for a
     * particular parameter, CloudFormation uses the default value that's specified in your
     * template.
     */
    val parameterKey: kotlin.String? = builder.parameterKey
    /**
     * The input value associated with the parameter.
     */
    val parameterValue: kotlin.String? = builder.parameterValue
    /**
     * Read-only. The value that corresponds to a SSM parameter key. This field is
     * returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types">
     * SSM
     * parameter types in the template.
     */
    val resolvedValue: kotlin.String? = builder.resolvedValue
    /**
     * During a stack update, use the existing parameter value that the stack is using for a
     * given parameter key. If you specify true, do not specify a parameter
     * value.
     */
    val usePreviousValue: kotlin.Boolean? = builder.usePreviousValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("parameterKey=$parameterKey,")
        append("parameterValue=$parameterValue,")
        append("resolvedValue=$resolvedValue,")
        append("usePreviousValue=$usePreviousValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameterKey?.hashCode() ?: 0
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (resolvedValue?.hashCode() ?: 0)
        result = 31 * result + (usePreviousValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (parameterKey != other.parameterKey) return false
        if (parameterValue != other.parameterValue) return false
        if (resolvedValue != other.resolvedValue) return false
        if (usePreviousValue != other.usePreviousValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.Parameter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The key associated with the parameter. If you don't specify a key and value for a
         * particular parameter, CloudFormation uses the default value that's specified in your
         * template.
         */
        var parameterKey: kotlin.String? = null
        /**
         * The input value associated with the parameter.
         */
        var parameterValue: kotlin.String? = null
        /**
         * Read-only. The value that corresponds to a SSM parameter key. This field is
         * returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types">
         * SSM
         * parameter types in the template.
         */
        var resolvedValue: kotlin.String? = null
        /**
         * During a stack update, use the existing parameter value that the stack is using for a
         * given parameter key. If you specify true, do not specify a parameter
         * value.
         */
        var usePreviousValue: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.Parameter) : this() {
            this.parameterKey = x.parameterKey
            this.parameterValue = x.parameterValue
            this.resolvedValue = x.resolvedValue
            this.usePreviousValue = x.usePreviousValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.Parameter = Parameter(this)
    }
}
