// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for the ExecuteChangeSet action.
 */
class ExecuteChangeSetRequest private constructor(builder: Builder) {
    /**
     * The name or Amazon Resource Name (ARN) of the change set that you want use to update the
     * specified stack.
     */
    val changeSetName: kotlin.String? = builder.changeSetName
    /**
     * A unique identifier for this ExecuteChangeSet request. Specify this token
     * if you plan to retry requests so that CloudFormation knows that you're not attempting
     * to execute a change set to update a stack with the same name. You might retry
     * ExecuteChangeSet requests to ensure that CloudFormation successfully
     * received them.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Preserves the state of previously provisioned resources when an operation fails.
     * Default: True
     */
    val disableRollback: kotlin.Boolean? = builder.disableRollback
    /**
     * If you specified the name of a change set, specify the stack name or Amazon Resource
     * Name (ARN) that's associated with the change set you want to execute.
     */
    val stackName: kotlin.String? = builder.stackName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteChangeSetRequest(")
        append("changeSetName=$changeSetName,")
        append("clientRequestToken=$clientRequestToken,")
        append("disableRollback=$disableRollback,")
        append("stackName=$stackName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeSetName?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (disableRollback?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteChangeSetRequest

        if (changeSetName != other.changeSetName) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (disableRollback != other.disableRollback) return false
        if (stackName != other.stackName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name or Amazon Resource Name (ARN) of the change set that you want use to update the
         * specified stack.
         */
        var changeSetName: kotlin.String? = null
        /**
         * A unique identifier for this ExecuteChangeSet request. Specify this token
         * if you plan to retry requests so that CloudFormation knows that you're not attempting
         * to execute a change set to update a stack with the same name. You might retry
         * ExecuteChangeSet requests to ensure that CloudFormation successfully
         * received them.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * Preserves the state of previously provisioned resources when an operation fails.
         * Default: True
         */
        var disableRollback: kotlin.Boolean? = null
        /**
         * If you specified the name of a change set, specify the stack name or Amazon Resource
         * Name (ARN) that's associated with the change set you want to execute.
         */
        var stackName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest) : this() {
            this.changeSetName = x.changeSetName
            this.clientRequestToken = x.clientRequestToken
            this.disableRollback = x.disableRollback
            this.stackName = x.stackName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest = ExecuteChangeSetRequest(this)
    }
}
