// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeTypeResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the extension.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Whether CloudFormation automatically updates the extension in this account and
     * region when a new minor version is published by the extension
     * publisher. Major versions released by the publisher must be manually updated. For more
     * information, see <a href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating public extensions for use in your account in the CloudFormation User Guide.
     */
    val autoUpdate: kotlin.Boolean? = builder.autoUpdate
    /**
     * A JSON string that represent the current configuration data for the extension in this
     * account and region.
     * To set the configuration data for an extension, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
     */
    val configurationSchema: kotlin.String? = builder.configurationSchema
    /**
     * The ID of the default version of the extension. The default version is used when the
     * extension version isn't specified.
     * This applies only to private extensions you have registered in your account. For public
     * extensions, both those provided by Amazon and published by third parties, CloudFormation returns null. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     * To set the default version of an extension, use
     * SetTypeDefaultVersion
     * .
     */
    val defaultVersionId: kotlin.String? = builder.defaultVersionId
    /**
     * The deprecation status of the extension version.
     * Valid values include:
     *
     *
     *
     * LIVE: The extension is activated or registered and can be used in
     * CloudFormation operations, dependent on its provisioning behavior and
     * visibility scope.
     *
     *
     * DEPRECATED: The extension has been deactivated or deregistered and
     * can no longer be used in CloudFormation operations.
     *
     *
     * For public third-party extensions, CloudFormation returns
     * null.
     */
    val deprecatedStatus: aws.sdk.kotlin.services.cloudformation.model.DeprecatedStatus? = builder.deprecatedStatus
    /**
     * The description of the extension.
     */
    val description: kotlin.String? = builder.description
    /**
     * The URL of a page providing detailed documentation for this extension.
     */
    val documentationUrl: kotlin.String? = builder.documentationUrl
    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to register
     * the extension. This applies only to private extensions you have registered in your account.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     *
     * If the registered extension calls any Amazon Web Services APIs, you must create an
     *
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role
     * that includes the necessary
     * permissions to call those Amazon Web Services APIs, and provision that execution role in
     * your account. CloudFormation then assumes that execution role to provide your
     * extension with the appropriate credentials.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Whether or not the extension is activated in the account and region.
     * This only applies to public third-party extensions. For all other extensions, CloudFormation returns null.
     */
    val isActivated: kotlin.Boolean? = builder.isActivated
    /**
     * Whether the specified extension version is set as the default version.
     * This applies only to private extensions you have registered in your account, and
     * extensions published by Amazon. For public third-party extensions, whether or not they are
     * activated in your account, CloudFormation returns null.
     */
    val isDefaultVersion: kotlin.Boolean? = builder.isDefaultVersion
    /**
     * When the specified extension version was registered. This applies only to:
     *
     *
     * Private extensions you have registered in your account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     *
     * Public extensions you have activated in your account with auto-update specified.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The latest version of a public extension that is available for
     * use.
     * This only applies if you specify a public extension, and you don't specify a version.
     * For all other requests, CloudFormation returns null.
     */
    val latestPublicVersion: kotlin.String? = builder.latestPublicVersion
    /**
     * Contains logging configuration information for private extensions. This applies only to
     * private extensions you have registered in your account. For public extensions, both those
     * provided by Amazon and published by third parties, CloudFormation returns
     * null. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     */
    val loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = builder.loggingConfig
    /**
     * For public extensions that have been activated for this account and region, the Amazon
     * Resource Name (ARN) of the public extension.
     */
    val originalTypeArn: kotlin.String? = builder.originalTypeArn
    /**
     * For public extensions that have been activated for this account and region, the type
     * name of the public extension.
     * If you specified a TypeNameAlias when enabling the extension in this
     * account and region, CloudFormation treats that alias as the extension's type name
     * within the account and region, not the type name of the public extension. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions in the
     * CloudFormation User Guide.
     */
    val originalTypeName: kotlin.String? = builder.originalTypeName
    /**
     * For resource type extensions, the provisioning behavior of the resource type. CloudFormation
     * determines the provisioning type during registration, based on the types of handlers in the
     * schema handler package submitted.
     * Valid values include:
     *
     *
     *
     * FULLY_MUTABLE: The resource type includes an update handler to
     * process updates to the type during stack update operations.
     *
     *
     * IMMUTABLE: The resource type doesn't include an update handler, so
     * the type can't be updated and must instead be replaced during stack update
     * operations.
     *
     *
     * NON_PROVISIONABLE: The resource type doesn't include all the
     * following handlers, and therefore can't actually be provisioned.
     *
     *
     * create
     *
     * read
     *
     * delete
     */
    val provisioningType: aws.sdk.kotlin.services.cloudformation.model.ProvisioningType? = builder.provisioningType
    /**
     * The version number of a public third-party extension.
     * This applies only if you specify a public extension you have activated in your account,
     * or specify a public extension without specifying a version. For all other extensions,
     * CloudFormation returns null.
     */
    val publicVersionNumber: kotlin.String? = builder.publicVersionNumber
    /**
     * The publisher ID of the extension publisher.
     * This applies only to public third-party extensions. For private registered extensions,
     * and extensions provided by Amazon Web Services, CloudFormation returns
     * null.
     */
    val publisherId: kotlin.String? = builder.publisherId
    /**
     * For extensions that are modules, the public third-party extensions that must be
     * activated in your account in order for the module itself to be activated.
     */
    val requiredActivatedTypes: List<RequiredActivatedType>? = builder.requiredActivatedTypes
    /**
     * The schema that defines the extension.
     * For more information on extension schemas, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource Provider
     * Schema in the CloudFormation CLI User
     * Guide.
     */
    val schema: kotlin.String? = builder.schema
    /**
     * The URL of the source code for the extension.
     */
    val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * When the specified private extension version was registered or activated in your
     * account.
     */
    val timeCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.timeCreated
    /**
     * The kind of extension.
     */
    val type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = builder.type
    /**
     * The name of the extension.
     * If the extension is a public third-party type you have activated with a type name alias,
     * CloudFormation returns the type name alias. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType.
     */
    val typeName: kotlin.String? = builder.typeName
    /**
     * The contract test status of the registered extension version. To return the extension
     * test status of a specific extension version, you must specify
     * VersionId.
     * This applies only to registered private extension versions. CloudFormation
     * doesn't return this information for public extensions, whether or not they are activated in
     * your account.
     *
     *
     *
     * PASSED: The extension has passed all its contract tests.
     * An extension must have a test status of PASSED before it can be
     * published. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public
     * use in the CloudFormation Command Line Interface User
     * Guide.
     *
     *
     * FAILED: The extension has failed one or more contract tests.
     *
     *
     * IN_PROGRESS: Contract tests are currently being performed on the
     * extension.
     *
     *
     * NOT_TESTED: Contract tests haven't been performed on the
     * extension.
     */
    val typeTestsStatus: aws.sdk.kotlin.services.cloudformation.model.TypeTestsStatus? = builder.typeTestsStatus
    /**
     * The description of the test status. To return the extension test status of a specific
     * extension version, you must specify VersionId.
     * This applies only to registered private extension versions. CloudFormation
     * doesn't return this information for public extensions, whether or not they are activated in
     * your account.
     */
    val typeTestsStatusDescription: kotlin.String? = builder.typeTestsStatusDescription
    /**
     * The scope at which the extension is visible and usable in CloudFormation
     * operations.
     * Valid values include:
     *
     *
     *
     * PRIVATE: The extension is only visible and usable within the account
     * in which it is registered. CloudFormation marks any extensions you register as
     * PRIVATE.
     *
     *
     * PUBLIC: The extension is publicly visible and usable within any
     * Amazon account.
     */
    val visibility: aws.sdk.kotlin.services.cloudformation.model.Visibility? = builder.visibility

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTypeResponse(")
        append("arn=$arn,")
        append("autoUpdate=$autoUpdate,")
        append("configurationSchema=$configurationSchema,")
        append("defaultVersionId=$defaultVersionId,")
        append("deprecatedStatus=$deprecatedStatus,")
        append("description=$description,")
        append("documentationUrl=$documentationUrl,")
        append("executionRoleArn=$executionRoleArn,")
        append("isActivated=$isActivated,")
        append("isDefaultVersion=$isDefaultVersion,")
        append("lastUpdated=$lastUpdated,")
        append("latestPublicVersion=$latestPublicVersion,")
        append("loggingConfig=$loggingConfig,")
        append("originalTypeArn=$originalTypeArn,")
        append("originalTypeName=$originalTypeName,")
        append("provisioningType=$provisioningType,")
        append("publicVersionNumber=$publicVersionNumber,")
        append("publisherId=$publisherId,")
        append("requiredActivatedTypes=$requiredActivatedTypes,")
        append("schema=$schema,")
        append("sourceUrl=$sourceUrl,")
        append("timeCreated=$timeCreated,")
        append("type=$type,")
        append("typeName=$typeName,")
        append("typeTestsStatus=$typeTestsStatus,")
        append("typeTestsStatusDescription=$typeTestsStatusDescription,")
        append("visibility=$visibility)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (autoUpdate?.hashCode() ?: 0)
        result = 31 * result + (configurationSchema?.hashCode() ?: 0)
        result = 31 * result + (defaultVersionId?.hashCode() ?: 0)
        result = 31 * result + (deprecatedStatus?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationUrl?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (isActivated?.hashCode() ?: 0)
        result = 31 * result + (isDefaultVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (latestPublicVersion?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (originalTypeArn?.hashCode() ?: 0)
        result = 31 * result + (originalTypeName?.hashCode() ?: 0)
        result = 31 * result + (provisioningType?.hashCode() ?: 0)
        result = 31 * result + (publicVersionNumber?.hashCode() ?: 0)
        result = 31 * result + (publisherId?.hashCode() ?: 0)
        result = 31 * result + (requiredActivatedTypes?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (timeCreated?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (typeTestsStatus?.hashCode() ?: 0)
        result = 31 * result + (typeTestsStatusDescription?.hashCode() ?: 0)
        result = 31 * result + (visibility?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTypeResponse

        if (arn != other.arn) return false
        if (autoUpdate != other.autoUpdate) return false
        if (configurationSchema != other.configurationSchema) return false
        if (defaultVersionId != other.defaultVersionId) return false
        if (deprecatedStatus != other.deprecatedStatus) return false
        if (description != other.description) return false
        if (documentationUrl != other.documentationUrl) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (isActivated != other.isActivated) return false
        if (isDefaultVersion != other.isDefaultVersion) return false
        if (lastUpdated != other.lastUpdated) return false
        if (latestPublicVersion != other.latestPublicVersion) return false
        if (loggingConfig != other.loggingConfig) return false
        if (originalTypeArn != other.originalTypeArn) return false
        if (originalTypeName != other.originalTypeName) return false
        if (provisioningType != other.provisioningType) return false
        if (publicVersionNumber != other.publicVersionNumber) return false
        if (publisherId != other.publisherId) return false
        if (requiredActivatedTypes != other.requiredActivatedTypes) return false
        if (schema != other.schema) return false
        if (sourceUrl != other.sourceUrl) return false
        if (timeCreated != other.timeCreated) return false
        if (type != other.type) return false
        if (typeName != other.typeName) return false
        if (typeTestsStatus != other.typeTestsStatus) return false
        if (typeTestsStatusDescription != other.typeTestsStatusDescription) return false
        if (visibility != other.visibility) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the extension.
         */
        var arn: kotlin.String? = null
        /**
         * Whether CloudFormation automatically updates the extension in this account and
         * region when a new minor version is published by the extension
         * publisher. Major versions released by the publisher must be manually updated. For more
         * information, see <a href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating public extensions for use in your account in the CloudFormation User Guide.
         */
        var autoUpdate: kotlin.Boolean? = null
        /**
         * A JSON string that represent the current configuration data for the extension in this
         * account and region.
         * To set the configuration data for an extension, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
         */
        var configurationSchema: kotlin.String? = null
        /**
         * The ID of the default version of the extension. The default version is used when the
         * extension version isn't specified.
         * This applies only to private extensions you have registered in your account. For public
         * extensions, both those provided by Amazon and published by third parties, CloudFormation returns null. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
         * To set the default version of an extension, use
         * SetTypeDefaultVersion
         * .
         */
        var defaultVersionId: kotlin.String? = null
        /**
         * The deprecation status of the extension version.
         * Valid values include:
         *
         *
         *
         * LIVE: The extension is activated or registered and can be used in
         * CloudFormation operations, dependent on its provisioning behavior and
         * visibility scope.
         *
         *
         * DEPRECATED: The extension has been deactivated or deregistered and
         * can no longer be used in CloudFormation operations.
         *
         *
         * For public third-party extensions, CloudFormation returns
         * null.
         */
        var deprecatedStatus: aws.sdk.kotlin.services.cloudformation.model.DeprecatedStatus? = null
        /**
         * The description of the extension.
         */
        var description: kotlin.String? = null
        /**
         * The URL of a page providing detailed documentation for this extension.
         */
        var documentationUrl: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to register
         * the extension. This applies only to private extensions you have registered in your account.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
         *
         * If the registered extension calls any Amazon Web Services APIs, you must create an
         *
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role
         * that includes the necessary
         * permissions to call those Amazon Web Services APIs, and provision that execution role in
         * your account. CloudFormation then assumes that execution role to provide your
         * extension with the appropriate credentials.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * Whether or not the extension is activated in the account and region.
         * This only applies to public third-party extensions. For all other extensions, CloudFormation returns null.
         */
        var isActivated: kotlin.Boolean? = null
        /**
         * Whether the specified extension version is set as the default version.
         * This applies only to private extensions you have registered in your account, and
         * extensions published by Amazon. For public third-party extensions, whether or not they are
         * activated in your account, CloudFormation returns null.
         */
        var isDefaultVersion: kotlin.Boolean? = null
        /**
         * When the specified extension version was registered. This applies only to:
         *
         *
         * Private extensions you have registered in your account. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
         *
         * Public extensions you have activated in your account with auto-update specified.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of a public extension that is available for
         * use.
         * This only applies if you specify a public extension, and you don't specify a version.
         * For all other requests, CloudFormation returns null.
         */
        var latestPublicVersion: kotlin.String? = null
        /**
         * Contains logging configuration information for private extensions. This applies only to
         * private extensions you have registered in your account. For public extensions, both those
         * provided by Amazon and published by third parties, CloudFormation returns
         * null. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
         */
        var loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = null
        /**
         * For public extensions that have been activated for this account and region, the Amazon
         * Resource Name (ARN) of the public extension.
         */
        var originalTypeArn: kotlin.String? = null
        /**
         * For public extensions that have been activated for this account and region, the type
         * name of the public extension.
         * If you specified a TypeNameAlias when enabling the extension in this
         * account and region, CloudFormation treats that alias as the extension's type name
         * within the account and region, not the type name of the public extension. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions in the
         * CloudFormation User Guide.
         */
        var originalTypeName: kotlin.String? = null
        /**
         * For resource type extensions, the provisioning behavior of the resource type. CloudFormation
         * determines the provisioning type during registration, based on the types of handlers in the
         * schema handler package submitted.
         * Valid values include:
         *
         *
         *
         * FULLY_MUTABLE: The resource type includes an update handler to
         * process updates to the type during stack update operations.
         *
         *
         * IMMUTABLE: The resource type doesn't include an update handler, so
         * the type can't be updated and must instead be replaced during stack update
         * operations.
         *
         *
         * NON_PROVISIONABLE: The resource type doesn't include all the
         * following handlers, and therefore can't actually be provisioned.
         *
         *
         * create
         *
         * read
         *
         * delete
         */
        var provisioningType: aws.sdk.kotlin.services.cloudformation.model.ProvisioningType? = null
        /**
         * The version number of a public third-party extension.
         * This applies only if you specify a public extension you have activated in your account,
         * or specify a public extension without specifying a version. For all other extensions,
         * CloudFormation returns null.
         */
        var publicVersionNumber: kotlin.String? = null
        /**
         * The publisher ID of the extension publisher.
         * This applies only to public third-party extensions. For private registered extensions,
         * and extensions provided by Amazon Web Services, CloudFormation returns
         * null.
         */
        var publisherId: kotlin.String? = null
        /**
         * For extensions that are modules, the public third-party extensions that must be
         * activated in your account in order for the module itself to be activated.
         */
        var requiredActivatedTypes: List<RequiredActivatedType>? = null
        /**
         * The schema that defines the extension.
         * For more information on extension schemas, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource Provider
         * Schema in the CloudFormation CLI User
         * Guide.
         */
        var schema: kotlin.String? = null
        /**
         * The URL of the source code for the extension.
         */
        var sourceUrl: kotlin.String? = null
        /**
         * When the specified private extension version was registered or activated in your
         * account.
         */
        var timeCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The kind of extension.
         */
        var type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = null
        /**
         * The name of the extension.
         * If the extension is a public third-party type you have activated with a type name alias,
         * CloudFormation returns the type name alias. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType.
         */
        var typeName: kotlin.String? = null
        /**
         * The contract test status of the registered extension version. To return the extension
         * test status of a specific extension version, you must specify
         * VersionId.
         * This applies only to registered private extension versions. CloudFormation
         * doesn't return this information for public extensions, whether or not they are activated in
         * your account.
         *
         *
         *
         * PASSED: The extension has passed all its contract tests.
         * An extension must have a test status of PASSED before it can be
         * published. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public
         * use in the CloudFormation Command Line Interface User
         * Guide.
         *
         *
         * FAILED: The extension has failed one or more contract tests.
         *
         *
         * IN_PROGRESS: Contract tests are currently being performed on the
         * extension.
         *
         *
         * NOT_TESTED: Contract tests haven't been performed on the
         * extension.
         */
        var typeTestsStatus: aws.sdk.kotlin.services.cloudformation.model.TypeTestsStatus? = null
        /**
         * The description of the test status. To return the extension test status of a specific
         * extension version, you must specify VersionId.
         * This applies only to registered private extension versions. CloudFormation
         * doesn't return this information for public extensions, whether or not they are activated in
         * your account.
         */
        var typeTestsStatusDescription: kotlin.String? = null
        /**
         * The scope at which the extension is visible and usable in CloudFormation
         * operations.
         * Valid values include:
         *
         *
         *
         * PRIVATE: The extension is only visible and usable within the account
         * in which it is registered. CloudFormation marks any extensions you register as
         * PRIVATE.
         *
         *
         * PUBLIC: The extension is publicly visible and usable within any
         * Amazon account.
         */
        var visibility: aws.sdk.kotlin.services.cloudformation.model.Visibility? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse) : this() {
            this.arn = x.arn
            this.autoUpdate = x.autoUpdate
            this.configurationSchema = x.configurationSchema
            this.defaultVersionId = x.defaultVersionId
            this.deprecatedStatus = x.deprecatedStatus
            this.description = x.description
            this.documentationUrl = x.documentationUrl
            this.executionRoleArn = x.executionRoleArn
            this.isActivated = x.isActivated
            this.isDefaultVersion = x.isDefaultVersion
            this.lastUpdated = x.lastUpdated
            this.latestPublicVersion = x.latestPublicVersion
            this.loggingConfig = x.loggingConfig
            this.originalTypeArn = x.originalTypeArn
            this.originalTypeName = x.originalTypeName
            this.provisioningType = x.provisioningType
            this.publicVersionNumber = x.publicVersionNumber
            this.publisherId = x.publisherId
            this.requiredActivatedTypes = x.requiredActivatedTypes
            this.schema = x.schema
            this.sourceUrl = x.sourceUrl
            this.timeCreated = x.timeCreated
            this.type = x.type
            this.typeName = x.typeName
            this.typeTestsStatus = x.typeTestsStatus
            this.typeTestsStatusDescription = x.typeTestsStatusDescription
            this.visibility = x.visibility
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse = DescribeTypeResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.LoggingConfig] inside the given [block]
         */
        fun loggingConfig(block: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.invoke(block)
        }
    }
}
