// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * &#91;Service-managed permissions&#93; The Organizations accounts to which StackSets
 * deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in
 * your organization or in an OU in your organization.
 * For update operations, you can specify either Accounts or
 * OrganizationalUnitIds. For create and delete operations, specify
 * OrganizationalUnitIds.
 */
class DeploymentTargets private constructor(builder: Builder) {
    /**
     * The names of one or more Amazon Web Services accounts for which you want to deploy stack
     * set updates.
     */
    val accounts: List<String>? = builder.accounts
    /**
     * Returns the value of the AccountsUrl property.
     */
    val accountsUrl: kotlin.String? = builder.accountsUrl
    /**
     * The organization root ID or organizational unit (OU) IDs to which StackSets
     * deploys.
     */
    val organizationalUnitIds: List<String>? = builder.organizationalUnitIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentTargets(")
        append("accounts=$accounts,")
        append("accountsUrl=$accountsUrl,")
        append("organizationalUnitIds=$organizationalUnitIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (accountsUrl?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentTargets

        if (accounts != other.accounts) return false
        if (accountsUrl != other.accountsUrl) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder(this).apply(block).build()

    class Builder {
        /**
         * The names of one or more Amazon Web Services accounts for which you want to deploy stack
         * set updates.
         */
        var accounts: List<String>? = null
        /**
         * Returns the value of the AccountsUrl property.
         */
        var accountsUrl: kotlin.String? = null
        /**
         * The organization root ID or organizational unit (OU) IDs to which StackSets
         * deploys.
         */
        var organizationalUnitIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets) : this() {
            this.accounts = x.accounts
            this.accountsUrl = x.accountsUrl
            this.organizationalUnitIds = x.organizationalUnitIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = DeploymentTargets(this)
    }
}
