// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for the CreateChangeSet action.
 */
class CreateChangeSetRequest private constructor(builder: Builder) {
    /**
     * In some cases, you must explicitly acknowledge that your stack template contains certain
     * capabilities in order for CloudFormation to create the stack.
     *
     *
     *
     * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
     *
     * Some stack templates might include resources that can affect permissions in your
     * Amazon Web Services account; for example, by creating new Identity and Access Management
     * (IAM) users. For those stacks, you must explicitly acknowledge this
     * by specifying one of these capabilities.
     * The following IAM resources require you to specify either the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM
     * capability.
     *
     *
     * If you have IAM resources, you can specify either
     * capability.
     *
     * If you have IAM resources with custom names, you
     * must specify CAPABILITY_NAMED_IAM.
     *
     * If you don't specify either of these capabilities, CloudFormation
     * returns an InsufficientCapabilities error.
     *
     *
     * If your stack template contains these resources, we recommend that you review all
     * permissions associated with them and edit their permissions if necessary.
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">AWS::IAM::UserToGroupAddition
     *
     *
     *
     * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM resources in CloudFormation templates.
     *
     *
     * CAPABILITY_AUTO_EXPAND
     *
     * Some template contain macros. Macros perform custom processing on templates; this
     * can include simple actions like find-and-replace operations, all the way to extensive
     * transformations of entire templates. Because of this, users typically create a change
     * set from the processed template, so that they can review the changes resulting from
     * the macros before actually creating the stack. If your stack template contains one or
     * more macros, and you choose to create a stack directly from the processed template,
     * without first reviewing the resulting changes in a change set, you must acknowledge
     * this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless transforms, which are macros hosted by CloudFormation.
     *
     * This capacity doesn't apply to creating change sets, and specifying it when
     * creating change sets has no effect.
     * If you want to create a stack from a stack template that contains macros
     * and nested stacks, you must create or update the stack
     * directly from the template using the CreateStack or UpdateStack action, and specifying this capability.
     *
     * For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation macros to
     * perform custom processing on templates.
     */
    val capabilities: List<Capability>? = builder.capabilities
    /**
     * The name of the change set. The name must be unique among all change sets that are
     * associated with the specified stack.
     * A change set name can contain only alphanumeric, case sensitive characters, and hyphens.
     * It must start with an alphabetical character and can't exceed 128 characters.
     */
    val changeSetName: kotlin.String? = builder.changeSetName
    /**
     * The type of change set operation. To create a change set for a new stack, specify
     * CREATE. To create a change set for an existing stack, specify
     * UPDATE. To create a change set for an import operation, specify
     * IMPORT.
     * If you create a change set for a new stack, CloudFormation creates a stack with a
     * unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
     * REVIEW_IN_PROGRESS
     * state until you execute the change
     * set.
     * By default, CloudFormation specifies UPDATE. You can't use the
     * UPDATE type to create a change set for a new stack or the
     * CREATE type to create a change set for an existing stack.
     */
    val changeSetType: aws.sdk.kotlin.services.cloudformation.model.ChangeSetType? = builder.changeSetType
    /**
     * A unique identifier for this CreateChangeSet request. Specify this token if
     * you plan to retry requests so that CloudFormation knows that you're not attempting to
     * create another change set with the same name. You might retry CreateChangeSet
     * requests to ensure that CloudFormation successfully received them.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description to help you identify this change set.
     */
    val description: kotlin.String? = builder.description
    /**
     * Creates a change set for the all nested stacks specified in the template. The default
     * behavior of this action is set to False. To include nested sets in a change
     * set, specify True.
     */
    val includeNestedStacks: kotlin.Boolean? = builder.includeNestedStacks
    /**
     * The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics
     * that CloudFormation associates with the stack. To remove all associated notification
     * topics, specify an empty list.
     */
    val notificationArNs: List<String>? = builder.notificationArNs
    /**
     * A list of Parameter structures that specify input parameters for the change
     * set. For more information, see the Parameter data type.
     */
    val parameters: List<Parameter>? = builder.parameters
    /**
     * The template resource types that you have permissions to work with if you execute this
     * change set, such as AWS::EC2::Instance, AWS::EC2::*, or
     * Custom::MyCustomInstance.
     * If the list of resource types doesn't include a resource type that you're updating, the
     * stack update fails. By default, CloudFormation grants permissions to all resource
     * types. Identity and Access Management (IAM) uses this parameter for condition keys
     * in IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling access with Identity and Access Management in the CloudFormation User Guide.
     */
    val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * The resources to import into your stack.
     */
    val resourcesToImport: List<ResourceToImport>? = builder.resourcesToImport
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
     * that CloudFormation assumes when executing the change set. CloudFormation uses the
     * role's credentials to make calls on your behalf. CloudFormation uses this role for all
     * future operations on the stack. Provided that users have permission to operate on the
     * stack, CloudFormation uses this role even if the users don't have permission to pass
     * it. Ensure that the role grants least permission.
     * If you don't specify a value, CloudFormation uses the role that was previously
     * associated with the stack. If no role is available, CloudFormation uses a temporary
     * session that is generated from your user credentials.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and
     * updating operations, and for the specified monitoring period afterwards.
     */
    val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * The name or the unique ID of the stack for which you are creating a change set. CloudFormation generates the change set by comparing this stack's information with the
     * information that you submit, such as a modified template or different parameter input
     * values.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * Key-value pairs to associate with this stack. CloudFormation also propagates these
     * tags to resources in the stack. You can specify a maximum of 50 tags.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A structure that contains the body of the revised template, with a minimum length of 1
     * byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
     * comparing this template with the template of the stack that you specified.
     * Conditional: You must specify only TemplateBody or
     * TemplateURL.
     */
    val templateBody: kotlin.String? = builder.templateBody
    /**
     * The location of the file that contains the revised template. The URL must point to a
     * template (max size: 460,800 bytes) that's located in an Amazon S3 bucket or a
     * Systems Manager document. CloudFormation generates the change set by comparing this
     * template with the stack that you specified.
     * Conditional: You must specify only TemplateBody or
     * TemplateURL.
     */
    val templateUrl: kotlin.String? = builder.templateUrl
    /**
     * Whether to reuse the template that's associated with the stack to create the change
     * set.
     */
    val usePreviousTemplate: kotlin.Boolean? = builder.usePreviousTemplate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChangeSetRequest(")
        append("capabilities=$capabilities,")
        append("changeSetName=$changeSetName,")
        append("changeSetType=$changeSetType,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("includeNestedStacks=$includeNestedStacks,")
        append("notificationArNs=$notificationArNs,")
        append("parameters=$parameters,")
        append("resourceTypes=$resourceTypes,")
        append("resourcesToImport=$resourcesToImport,")
        append("roleArn=$roleArn,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("stackName=$stackName,")
        append("tags=$tags,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl,")
        append("usePreviousTemplate=$usePreviousTemplate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (changeSetName?.hashCode() ?: 0)
        result = 31 * result + (changeSetType?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (includeNestedStacks?.hashCode() ?: 0)
        result = 31 * result + (notificationArNs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (resourcesToImport?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        result = 31 * result + (usePreviousTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChangeSetRequest

        if (capabilities != other.capabilities) return false
        if (changeSetName != other.changeSetName) return false
        if (changeSetType != other.changeSetType) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (includeNestedStacks != other.includeNestedStacks) return false
        if (notificationArNs != other.notificationArNs) return false
        if (parameters != other.parameters) return false
        if (resourceTypes != other.resourceTypes) return false
        if (resourcesToImport != other.resourcesToImport) return false
        if (roleArn != other.roleArn) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (stackName != other.stackName) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false
        if (usePreviousTemplate != other.usePreviousTemplate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * In some cases, you must explicitly acknowledge that your stack template contains certain
         * capabilities in order for CloudFormation to create the stack.
         *
         *
         *
         * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
         *
         * Some stack templates might include resources that can affect permissions in your
         * Amazon Web Services account; for example, by creating new Identity and Access Management
         * (IAM) users. For those stacks, you must explicitly acknowledge this
         * by specifying one of these capabilities.
         * The following IAM resources require you to specify either the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM
         * capability.
         *
         *
         * If you have IAM resources, you can specify either
         * capability.
         *
         * If you have IAM resources with custom names, you
         * must specify CAPABILITY_NAMED_IAM.
         *
         * If you don't specify either of these capabilities, CloudFormation
         * returns an InsufficientCapabilities error.
         *
         *
         * If your stack template contains these resources, we recommend that you review all
         * permissions associated with them and edit their permissions if necessary.
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">AWS::IAM::UserToGroupAddition
         *
         *
         *
         * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM resources in CloudFormation templates.
         *
         *
         * CAPABILITY_AUTO_EXPAND
         *
         * Some template contain macros. Macros perform custom processing on templates; this
         * can include simple actions like find-and-replace operations, all the way to extensive
         * transformations of entire templates. Because of this, users typically create a change
         * set from the processed template, so that they can review the changes resulting from
         * the macros before actually creating the stack. If your stack template contains one or
         * more macros, and you choose to create a stack directly from the processed template,
         * without first reviewing the resulting changes in a change set, you must acknowledge
         * this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless transforms, which are macros hosted by CloudFormation.
         *
         * This capacity doesn't apply to creating change sets, and specifying it when
         * creating change sets has no effect.
         * If you want to create a stack from a stack template that contains macros
         * and nested stacks, you must create or update the stack
         * directly from the template using the CreateStack or UpdateStack action, and specifying this capability.
         *
         * For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation macros to
         * perform custom processing on templates.
         */
        var capabilities: List<Capability>? = null
        /**
         * The name of the change set. The name must be unique among all change sets that are
         * associated with the specified stack.
         * A change set name can contain only alphanumeric, case sensitive characters, and hyphens.
         * It must start with an alphabetical character and can't exceed 128 characters.
         */
        var changeSetName: kotlin.String? = null
        /**
         * The type of change set operation. To create a change set for a new stack, specify
         * CREATE. To create a change set for an existing stack, specify
         * UPDATE. To create a change set for an import operation, specify
         * IMPORT.
         * If you create a change set for a new stack, CloudFormation creates a stack with a
         * unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
         * REVIEW_IN_PROGRESS
         * state until you execute the change
         * set.
         * By default, CloudFormation specifies UPDATE. You can't use the
         * UPDATE type to create a change set for a new stack or the
         * CREATE type to create a change set for an existing stack.
         */
        var changeSetType: aws.sdk.kotlin.services.cloudformation.model.ChangeSetType? = null
        /**
         * A unique identifier for this CreateChangeSet request. Specify this token if
         * you plan to retry requests so that CloudFormation knows that you're not attempting to
         * create another change set with the same name. You might retry CreateChangeSet
         * requests to ensure that CloudFormation successfully received them.
         */
        var clientToken: kotlin.String? = null
        /**
         * A description to help you identify this change set.
         */
        var description: kotlin.String? = null
        /**
         * Creates a change set for the all nested stacks specified in the template. The default
         * behavior of this action is set to False. To include nested sets in a change
         * set, specify True.
         */
        var includeNestedStacks: kotlin.Boolean? = null
        /**
         * The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics
         * that CloudFormation associates with the stack. To remove all associated notification
         * topics, specify an empty list.
         */
        var notificationArNs: List<String>? = null
        /**
         * A list of Parameter structures that specify input parameters for the change
         * set. For more information, see the Parameter data type.
         */
        var parameters: List<Parameter>? = null
        /**
         * The template resource types that you have permissions to work with if you execute this
         * change set, such as AWS::EC2::Instance, AWS::EC2::*, or
         * Custom::MyCustomInstance.
         * If the list of resource types doesn't include a resource type that you're updating, the
         * stack update fails. By default, CloudFormation grants permissions to all resource
         * types. Identity and Access Management (IAM) uses this parameter for condition keys
         * in IAM policies for CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling access with Identity and Access Management in the CloudFormation User Guide.
         */
        var resourceTypes: List<String>? = null
        /**
         * The resources to import into your stack.
         */
        var resourcesToImport: List<ResourceToImport>? = null
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
         * that CloudFormation assumes when executing the change set. CloudFormation uses the
         * role's credentials to make calls on your behalf. CloudFormation uses this role for all
         * future operations on the stack. Provided that users have permission to operate on the
         * stack, CloudFormation uses this role even if the users don't have permission to pass
         * it. Ensure that the role grants least permission.
         * If you don't specify a value, CloudFormation uses the role that was previously
         * associated with the stack. If no role is available, CloudFormation uses a temporary
         * session that is generated from your user credentials.
         */
        var roleArn: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and
         * updating operations, and for the specified monitoring period afterwards.
         */
        var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * The name or the unique ID of the stack for which you are creating a change set. CloudFormation generates the change set by comparing this stack's information with the
         * information that you submit, such as a modified template or different parameter input
         * values.
         */
        var stackName: kotlin.String? = null
        /**
         * Key-value pairs to associate with this stack. CloudFormation also propagates these
         * tags to resources in the stack. You can specify a maximum of 50 tags.
         */
        var tags: List<Tag>? = null
        /**
         * A structure that contains the body of the revised template, with a minimum length of 1
         * byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by
         * comparing this template with the template of the stack that you specified.
         * Conditional: You must specify only TemplateBody or
         * TemplateURL.
         */
        var templateBody: kotlin.String? = null
        /**
         * The location of the file that contains the revised template. The URL must point to a
         * template (max size: 460,800 bytes) that's located in an Amazon S3 bucket or a
         * Systems Manager document. CloudFormation generates the change set by comparing this
         * template with the stack that you specified.
         * Conditional: You must specify only TemplateBody or
         * TemplateURL.
         */
        var templateUrl: kotlin.String? = null
        /**
         * Whether to reuse the template that's associated with the stack to create the change
         * set.
         */
        var usePreviousTemplate: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest) : this() {
            this.capabilities = x.capabilities
            this.changeSetName = x.changeSetName
            this.changeSetType = x.changeSetType
            this.clientToken = x.clientToken
            this.description = x.description
            this.includeNestedStacks = x.includeNestedStacks
            this.notificationArNs = x.notificationArNs
            this.parameters = x.parameters
            this.resourceTypes = x.resourceTypes
            this.resourcesToImport = x.resourcesToImport
            this.roleArn = x.roleArn
            this.rollbackConfiguration = x.rollbackConfiguration
            this.stackName = x.stackName
            this.tags = x.tags
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
            this.usePreviousTemplate = x.usePreviousTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest = CreateChangeSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }
    }
}
