// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The ChangeSetSummary structure describes a change set, its status, and the
 * stack with which it's associated.
 */
class ChangeSetSummary private constructor(builder: Builder) {
    /**
     * The ID of the change set.
     */
    val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * The name of the change set.
     */
    val changeSetName: kotlin.String? = builder.changeSetName
    /**
     * The start time when the change set was created, in UTC.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Descriptive information about the change set.
     */
    val description: kotlin.String? = builder.description
    /**
     * If the change set execution status is AVAILABLE, you can execute the change
     * set. If you can't execute the change set, the status indicates why. For example, a change
     * set might be in an UNAVAILABLE state because CloudFormation is still
     * creating it or in an OBSOLETE state because the stack was already
     * updated.
     */
    val executionStatus: aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus? = builder.executionStatus
    /**
     * Specifies the current setting of IncludeNestedStacks for the change
     * set.
     */
    val includeNestedStacks: kotlin.Boolean? = builder.includeNestedStacks
    /**
     * The parent change set ID.
     */
    val parentChangeSetId: kotlin.String? = builder.parentChangeSetId
    /**
     * The root change set ID.
     */
    val rootChangeSetId: kotlin.String? = builder.rootChangeSetId
    /**
     * The ID of the stack with which the change set is associated.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The name of the stack with which the change set is associated.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * The state of the change set, such as CREATE_IN_PROGRESS,
     * CREATE_COMPLETE, or FAILED.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus? = builder.status
    /**
     * A description of the change set's status. For example, if your change set is in the
     * FAILED state, CloudFormation shows the error message.
     */
    val statusReason: kotlin.String? = builder.statusReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeSetSummary(")
        append("changeSetId=$changeSetId,")
        append("changeSetName=$changeSetName,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("executionStatus=$executionStatus,")
        append("includeNestedStacks=$includeNestedStacks,")
        append("parentChangeSetId=$parentChangeSetId,")
        append("rootChangeSetId=$rootChangeSetId,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeSetId?.hashCode() ?: 0
        result = 31 * result + (changeSetName?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionStatus?.hashCode() ?: 0)
        result = 31 * result + (includeNestedStacks?.hashCode() ?: 0)
        result = 31 * result + (parentChangeSetId?.hashCode() ?: 0)
        result = 31 * result + (rootChangeSetId?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeSetSummary

        if (changeSetId != other.changeSetId) return false
        if (changeSetName != other.changeSetName) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (executionStatus != other.executionStatus) return false
        if (includeNestedStacks != other.includeNestedStacks) return false
        if (parentChangeSetId != other.parentChangeSetId) return false
        if (rootChangeSetId != other.rootChangeSetId) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the change set.
         */
        var changeSetId: kotlin.String? = null
        /**
         * The name of the change set.
         */
        var changeSetName: kotlin.String? = null
        /**
         * The start time when the change set was created, in UTC.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Descriptive information about the change set.
         */
        var description: kotlin.String? = null
        /**
         * If the change set execution status is AVAILABLE, you can execute the change
         * set. If you can't execute the change set, the status indicates why. For example, a change
         * set might be in an UNAVAILABLE state because CloudFormation is still
         * creating it or in an OBSOLETE state because the stack was already
         * updated.
         */
        var executionStatus: aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus? = null
        /**
         * Specifies the current setting of IncludeNestedStacks for the change
         * set.
         */
        var includeNestedStacks: kotlin.Boolean? = null
        /**
         * The parent change set ID.
         */
        var parentChangeSetId: kotlin.String? = null
        /**
         * The root change set ID.
         */
        var rootChangeSetId: kotlin.String? = null
        /**
         * The ID of the stack with which the change set is associated.
         */
        var stackId: kotlin.String? = null
        /**
         * The name of the stack with which the change set is associated.
         */
        var stackName: kotlin.String? = null
        /**
         * The state of the change set, such as CREATE_IN_PROGRESS,
         * CREATE_COMPLETE, or FAILED.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus? = null
        /**
         * A description of the change set's status. For example, if your change set is in the
         * FAILED state, CloudFormation shows the error message.
         */
        var statusReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary) : this() {
            this.changeSetId = x.changeSetId
            this.changeSetName = x.changeSetName
            this.creationTime = x.creationTime
            this.description = x.description
            this.executionStatus = x.executionStatus
            this.includeNestedStacks = x.includeNestedStacks
            this.parentChangeSetId = x.parentChangeSetId
            this.rootChangeSetId = x.rootChangeSetId
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary = ChangeSetSummary(this)
    }
}
