// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



class ActivateTypeRequest private constructor(builder: Builder) {
    /**
     * Whether to automatically update the extension in this account and region when a new
     * minor version is published by the extension publisher. Major
     * versions released by the publisher must be manually updated.
     * The default is true.
     */
    val autoUpdate: kotlin.Boolean? = builder.autoUpdate
    /**
     * The name of the IAM execution role to use to activate the
     * extension.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Contains logging configuration information for an extension.
     */
    val loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = builder.loggingConfig
    /**
     * The major version of this extension you want to activate, if multiple major versions are
     * available. The default is the latest major version. CloudFormation uses the latest
     * available minor version of the major version selected.
     * You can specify MajorVersion or VersionBump, but not
     * both.
     */
    val majorVersion: kotlin.Long? = builder.majorVersion
    /**
     * The Amazon Resource Number (ARN) of the public extension.
     * Conditional: You must specify PublicTypeArn, or TypeName,
     * Type, and PublisherId.
     */
    val publicTypeArn: kotlin.String? = builder.publicTypeArn
    /**
     * The ID of the extension publisher.
     * Conditional: You must specify PublicTypeArn, or TypeName,
     * Type, and PublisherId.
     */
    val publisherId: kotlin.String? = builder.publisherId
    /**
     * The extension type.
     * Conditional: You must specify PublicTypeArn, or TypeName,
     * Type, and PublisherId.
     */
    val type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = builder.type
    /**
     * The name of the extension.
     * Conditional: You must specify PublicTypeArn, or TypeName,
     * Type, and PublisherId.
     */
    val typeName: kotlin.String? = builder.typeName
    /**
     * An alias to assign to the public extension, in this account and region. If you specify
     * an alias for the extension, CloudFormation treats the alias as the extension type
     * name within this account and region. You must use the alias to refer to the extension in
     * your templates, API calls, and CloudFormation console.
     * An extension alias must be unique within a given account and region. You can activate
     * the same public resource multiple times in the same account and region, using different
     * type name aliases.
     */
    val typeNameAlias: kotlin.String? = builder.typeNameAlias
    /**
     * Manually updates a previously-activated type to a new major or minor version, if
     * available. You can also use this parameter to update the value of
     * AutoUpdate.
     *
     *
     *
     * MAJOR: CloudFormation updates the extension to the newest
     * major version, if one is available.
     *
     *
     * MINOR: CloudFormation updates the extension to the newest
     * minor version, if one is available.
     */
    val versionBump: aws.sdk.kotlin.services.cloudformation.model.VersionBump? = builder.versionBump

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivateTypeRequest(")
        append("autoUpdate=$autoUpdate,")
        append("executionRoleArn=$executionRoleArn,")
        append("loggingConfig=$loggingConfig,")
        append("majorVersion=$majorVersion,")
        append("publicTypeArn=$publicTypeArn,")
        append("publisherId=$publisherId,")
        append("type=$type,")
        append("typeName=$typeName,")
        append("typeNameAlias=$typeNameAlias,")
        append("versionBump=$versionBump)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpdate?.hashCode() ?: 0
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (loggingConfig?.hashCode() ?: 0)
        result = 31 * result + (majorVersion?.hashCode() ?: 0)
        result = 31 * result + (publicTypeArn?.hashCode() ?: 0)
        result = 31 * result + (publisherId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (typeNameAlias?.hashCode() ?: 0)
        result = 31 * result + (versionBump?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivateTypeRequest

        if (autoUpdate != other.autoUpdate) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (loggingConfig != other.loggingConfig) return false
        if (majorVersion != other.majorVersion) return false
        if (publicTypeArn != other.publicTypeArn) return false
        if (publisherId != other.publisherId) return false
        if (type != other.type) return false
        if (typeName != other.typeName) return false
        if (typeNameAlias != other.typeNameAlias) return false
        if (versionBump != other.versionBump) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether to automatically update the extension in this account and region when a new
         * minor version is published by the extension publisher. Major
         * versions released by the publisher must be manually updated.
         * The default is true.
         */
        var autoUpdate: kotlin.Boolean? = null
        /**
         * The name of the IAM execution role to use to activate the
         * extension.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * Contains logging configuration information for an extension.
         */
        var loggingConfig: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig? = null
        /**
         * The major version of this extension you want to activate, if multiple major versions are
         * available. The default is the latest major version. CloudFormation uses the latest
         * available minor version of the major version selected.
         * You can specify MajorVersion or VersionBump, but not
         * both.
         */
        var majorVersion: kotlin.Long? = null
        /**
         * The Amazon Resource Number (ARN) of the public extension.
         * Conditional: You must specify PublicTypeArn, or TypeName,
         * Type, and PublisherId.
         */
        var publicTypeArn: kotlin.String? = null
        /**
         * The ID of the extension publisher.
         * Conditional: You must specify PublicTypeArn, or TypeName,
         * Type, and PublisherId.
         */
        var publisherId: kotlin.String? = null
        /**
         * The extension type.
         * Conditional: You must specify PublicTypeArn, or TypeName,
         * Type, and PublisherId.
         */
        var type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = null
        /**
         * The name of the extension.
         * Conditional: You must specify PublicTypeArn, or TypeName,
         * Type, and PublisherId.
         */
        var typeName: kotlin.String? = null
        /**
         * An alias to assign to the public extension, in this account and region. If you specify
         * an alias for the extension, CloudFormation treats the alias as the extension type
         * name within this account and region. You must use the alias to refer to the extension in
         * your templates, API calls, and CloudFormation console.
         * An extension alias must be unique within a given account and region. You can activate
         * the same public resource multiple times in the same account and region, using different
         * type name aliases.
         */
        var typeNameAlias: kotlin.String? = null
        /**
         * Manually updates a previously-activated type to a new major or minor version, if
         * available. You can also use this parameter to update the value of
         * AutoUpdate.
         *
         *
         *
         * MAJOR: CloudFormation updates the extension to the newest
         * major version, if one is available.
         *
         *
         * MINOR: CloudFormation updates the extension to the newest
         * minor version, if one is available.
         */
        var versionBump: aws.sdk.kotlin.services.cloudformation.model.VersionBump? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest) : this() {
            this.autoUpdate = x.autoUpdate
            this.executionRoleArn = x.executionRoleArn
            this.loggingConfig = x.loggingConfig
            this.majorVersion = x.majorVersion
            this.publicTypeArn = x.publicTypeArn
            this.publisherId = x.publisherId
            this.type = x.type
            this.typeName = x.typeName
            this.typeNameAlias = x.typeNameAlias
            this.versionBump = x.versionBump
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest = ActivateTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.LoggingConfig] inside the given [block]
         */
        fun loggingConfig(block: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.loggingConfig = aws.sdk.kotlin.services.cloudformation.model.LoggingConfig.invoke(block)
        }
    }
}
