// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Structure that contains the results of the account gate function which CloudFormation invokes, if present, before proceeding with a stack set operation in an account and
 * Region.
 * For each account and Region, CloudFormation lets you specify a Lambda
 * function that encapsulates any requirements that must be met before CloudFormation
 * can proceed with a stack set operation in that account and Region. CloudFormation
 * invokes the function each time a stack set operation is requested for that account and
 * Region; if the function returns FAILED, CloudFormation cancels the
 * operation in that account and Region, and sets the stack set operation result status for
 * that account and Region to FAILED.
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html">Configuring a
 * target account gate.
 */
class AccountGateResult private constructor(builder: Builder) {
    /**
     * The status of the account gate function.
     *
     *
     *
     * SUCCEEDED: The account gate function has determined that the account
     * and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and
     * Region.
     *
     *
     * FAILED: The account gate function has determined that the account and
     * Region doesn't meet the requirements for a stack set operation to occur. CloudFormation cancels the stack set operation in that account and Region, and sets
     * the stack set operation result status for that account and Region to
     * FAILED.
     *
     *
     * SKIPPED: CloudFormation has skipped calling the account gate
     * function for this account and Region, for one of the following reasons:
     *
     *
     * An account gate function hasn't been specified for the account and Region.
     * CloudFormation proceeds with the stack set operation in this account
     * and Region.
     *
     * The AWSCloudFormationStackSetExecutionRole of the stack set
     * administration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and
     * Region.
     *
     * Either no action is necessary, or no action is possible, on the stack.
     * CloudFormation skips the stack set operation in this account and
     * Region.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.AccountGateStatus? = builder.status
    /**
     * The reason for the account gate status assigned to this account and Region for the stack
     * set operation.
     */
    val statusReason: kotlin.String? = builder.statusReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.AccountGateResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountGateResult(")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountGateResult

        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.AccountGateResult = Builder(this).apply(block).build()

    class Builder {
        /**
         * The status of the account gate function.
         *
         *
         *
         * SUCCEEDED: The account gate function has determined that the account
         * and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and
         * Region.
         *
         *
         * FAILED: The account gate function has determined that the account and
         * Region doesn't meet the requirements for a stack set operation to occur. CloudFormation cancels the stack set operation in that account and Region, and sets
         * the stack set operation result status for that account and Region to
         * FAILED.
         *
         *
         * SKIPPED: CloudFormation has skipped calling the account gate
         * function for this account and Region, for one of the following reasons:
         *
         *
         * An account gate function hasn't been specified for the account and Region.
         * CloudFormation proceeds with the stack set operation in this account
         * and Region.
         *
         * The AWSCloudFormationStackSetExecutionRole of the stack set
         * administration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and
         * Region.
         *
         * Either no action is necessary, or no action is possible, on the stack.
         * CloudFormation skips the stack set operation in this account and
         * Region.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.AccountGateStatus? = null
        /**
         * The reason for the account gate status assigned to this account and Region for the stack
         * set operation.
         */
        var statusReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.AccountGateResult) : this() {
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.AccountGateResult = AccountGateResult(this)
    }
}
