// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudformation.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloudformation.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * <fullname>CloudFormation</fullname>
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure
 * deployments predictably and repeatedly. You can use CloudFormation to leverage
 * Amazon Web Services products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store,
 * Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly
 * reliable, highly scalable, cost-effective applications without creating or configuring the
 * underlying Amazon Web Services infrastructure.
 * With CloudFormation, you declare all your resources and dependencies in a template
 * file. The template defines a collection of resources as a single unit called a stack.
 * CloudFormation creates and deletes all member resources of the stack together and
 * manages all dependencies between the resources for you.
 * For more information about CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">CloudFormation product page.
 * CloudFormation makes use of other Amazon Web Services products. If you need
 * additional technical information about a specific Amazon Web Services product, you can find
 * the product's technical documentation at <a href="https://docs.aws.amazon.com/">
 * docs.aws.amazon.com
 * .
 */
interface CloudFormationClient : SdkClient {

    override val serviceName: String
        get() = "CloudFormation"
    /**
     * CloudFormationClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CloudFormationClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudFormationClient(config)
        }

        operator fun invoke(config: Config): CloudFormationClient = DefaultCloudFormationClient(config)

        /**
         * Construct a [CloudFormationClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudFormationClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCloudFormationClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Activates a public third-party extension, making it available for use in stack
     * templates. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using
     * public extensions in the CloudFormation User Guide.
     * Once you have activated a public third-party extension in your account and region, use
     * <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration to specify configuration properties for the extension. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
     */
    suspend fun activateType(input: ActivateTypeRequest): ActivateTypeResponse

    /**
     * Activates a public third-party extension, making it available for use in stack
     * templates. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using
     * public extensions in the CloudFormation User Guide.
     * Once you have activated a public third-party extension in your account and region, use
     * <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration to specify configuration properties for the extension. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
     */
    suspend fun activateType(block: ActivateTypeRequest.Builder.() -> Unit) = activateType(ActivateTypeRequest.Builder().apply(block).build())

    /**
     * Returns configuration data for the specified CloudFormation extensions, from
     * the CloudFormation registry for the account and region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the
     * CloudFormation User Guide.
     */
    suspend fun batchDescribeTypeConfigurations(input: BatchDescribeTypeConfigurationsRequest): BatchDescribeTypeConfigurationsResponse

    /**
     * Returns configuration data for the specified CloudFormation extensions, from
     * the CloudFormation registry for the account and region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the
     * CloudFormation User Guide.
     */
    suspend fun batchDescribeTypeConfigurations(block: BatchDescribeTypeConfigurationsRequest.Builder.() -> Unit) = batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest.Builder().apply(block).build())

    /**
     * Cancels an update on the specified stack. If the call completes successfully, the stack
     * rolls back the update and reverts to the previous stack configuration.
     *
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS
     * state.
     */
    suspend fun cancelUpdateStack(input: CancelUpdateStackRequest): CancelUpdateStackResponse

    /**
     * Cancels an update on the specified stack. If the call completes successfully, the stack
     * rolls back the update and reverts to the previous stack configuration.
     *
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS
     * state.
     */
    suspend fun cancelUpdateStack(block: CancelUpdateStackRequest.Builder.() -> Unit) = cancelUpdateStack(CancelUpdateStackRequest.Builder().apply(block).build())

    /**
     * For a specified stack that's in the UPDATE_ROLLBACK_FAILED state, continues
     * rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
     * of the failure, you can manually <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> fix the error and continue the rollback. By continuing the rollback, you can
     * return your stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and
     * then try to update the stack again.
     * A stack goes into the UPDATE_ROLLBACK_FAILED state when CloudFormation can't roll back all changes after a failed stack update. For example, you
     * might have a stack that's rolling back to an old database instance that was deleted outside
     * of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing
     * the update rollback to fail.
     */
    suspend fun continueUpdateRollback(input: ContinueUpdateRollbackRequest): ContinueUpdateRollbackResponse

    /**
     * For a specified stack that's in the UPDATE_ROLLBACK_FAILED state, continues
     * rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
     * of the failure, you can manually <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> fix the error and continue the rollback. By continuing the rollback, you can
     * return your stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and
     * then try to update the stack again.
     * A stack goes into the UPDATE_ROLLBACK_FAILED state when CloudFormation can't roll back all changes after a failed stack update. For example, you
     * might have a stack that's rolling back to an old database instance that was deleted outside
     * of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing
     * the update rollback to fail.
     */
    suspend fun continueUpdateRollback(block: ContinueUpdateRollbackRequest.Builder.() -> Unit) = continueUpdateRollback(ContinueUpdateRollbackRequest.Builder().apply(block).build())

    /**
     * Creates a list of changes that will be applied to a stack so that you can review the
     * changes before executing them. You can create a change set for a stack that doesn't exist
     * or an existing stack. If you create a change set for a stack that doesn't exist, the change
     * set shows all of the resources that CloudFormation will create. If you create a change
     * set for an existing stack, CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to
     * understand which resources CloudFormation will create or change, and how it will change
     * resources in an existing stack, before you create or update a stack.
     * To create a change set for a stack that doesn't exist, for the
     * ChangeSetType parameter, specify CREATE. To create a change
     * set for an existing stack, specify UPDATE for the ChangeSetType
     * parameter. To create a change set for an import operation, specify IMPORT for
     * the ChangeSetType parameter. After the CreateChangeSet call
     * successfully completes, CloudFormation starts creating the change set. To check the
     * status of the change set or to review it, use the DescribeChangeSet
     * action.
     * When you are satisfied with the changes the change set will make, execute the change set
     * by using the ExecuteChangeSet action. CloudFormation doesn't make
     * changes until you execute the change set.
     * To create a change set for the entire stack hierarchy, set
     * IncludeNestedStacks to True.
     */
    suspend fun createChangeSet(input: CreateChangeSetRequest): CreateChangeSetResponse

    /**
     * Creates a list of changes that will be applied to a stack so that you can review the
     * changes before executing them. You can create a change set for a stack that doesn't exist
     * or an existing stack. If you create a change set for a stack that doesn't exist, the change
     * set shows all of the resources that CloudFormation will create. If you create a change
     * set for an existing stack, CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to
     * understand which resources CloudFormation will create or change, and how it will change
     * resources in an existing stack, before you create or update a stack.
     * To create a change set for a stack that doesn't exist, for the
     * ChangeSetType parameter, specify CREATE. To create a change
     * set for an existing stack, specify UPDATE for the ChangeSetType
     * parameter. To create a change set for an import operation, specify IMPORT for
     * the ChangeSetType parameter. After the CreateChangeSet call
     * successfully completes, CloudFormation starts creating the change set. To check the
     * status of the change set or to review it, use the DescribeChangeSet
     * action.
     * When you are satisfied with the changes the change set will make, execute the change set
     * by using the ExecuteChangeSet action. CloudFormation doesn't make
     * changes until you execute the change set.
     * To create a change set for the entire stack hierarchy, set
     * IncludeNestedStacks to True.
     */
    suspend fun createChangeSet(block: CreateChangeSetRequest.Builder.() -> Unit) = createChangeSet(CreateChangeSetRequest.Builder().apply(block).build())

    /**
     * Creates a stack as specified in the template. After the call completes successfully, the
     * stack creation starts. You can check the status of the stack through the DescribeStacksoperation.
     */
    suspend fun createStack(input: CreateStackRequest): CreateStackResponse

    /**
     * Creates a stack as specified in the template. After the call completes successfully, the
     * stack creation starts. You can check the status of the stack through the DescribeStacksoperation.
     */
    suspend fun createStack(block: CreateStackRequest.Builder.() -> Unit) = createStack(CreateStackRequest.Builder().apply(block).build())

    /**
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
     * You must specify at least one value for either Accounts or
     * DeploymentTargets, and you must specify at least one value for
     * Regions.
     */
    suspend fun createStackInstances(input: CreateStackInstancesRequest): CreateStackInstancesResponse

    /**
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
     * You must specify at least one value for either Accounts or
     * DeploymentTargets, and you must specify at least one value for
     * Regions.
     */
    suspend fun createStackInstances(block: CreateStackInstancesRequest.Builder.() -> Unit) = createStackInstances(CreateStackInstancesRequest.Builder().apply(block).build())

    /**
     * Creates a stack set.
     */
    suspend fun createStackSet(input: CreateStackSetRequest): CreateStackSetResponse

    /**
     * Creates a stack set.
     */
    suspend fun createStackSet(block: CreateStackSetRequest.Builder.() -> Unit) = createStackSet(CreateStackSetRequest.Builder().apply(block).build())

    /**
     * Deactivates a public extension that was previously activated in this account and
     * region.
     * Once deactivated, an extension can't be used in any CloudFormation operation.
     * This includes stack update operations where the stack template includes the extension, even
     * if no updates are being made to the extension. In addition, deactivated extensions aren't
     * automatically updated if a new version of the extension is released.
     */
    suspend fun deactivateType(input: DeactivateTypeRequest): DeactivateTypeResponse

    /**
     * Deactivates a public extension that was previously activated in this account and
     * region.
     * Once deactivated, an extension can't be used in any CloudFormation operation.
     * This includes stack update operations where the stack template includes the extension, even
     * if no updates are being made to the extension. In addition, deactivated extensions aren't
     * automatically updated if a new version of the extension is released.
     */
    suspend fun deactivateType(block: DeactivateTypeRequest.Builder.() -> Unit) = deactivateType(DeactivateTypeRequest.Builder().apply(block).build())

    /**
     * Deletes the specified change set. Deleting change sets ensures that no one executes the
     * wrong change set.
     * If the call successfully completes, CloudFormation successfully deleted the change
     * set.
     * If IncludeNestedStacks specifies True during the creation of
     * the nested change set, then DeleteChangeSet will delete all change sets that
     * belong to the stacks hierarchy and will also delete all change sets for nested stacks with
     * the status of REVIEW_IN_PROGRESS.
     */
    suspend fun deleteChangeSet(input: DeleteChangeSetRequest): DeleteChangeSetResponse

    /**
     * Deletes the specified change set. Deleting change sets ensures that no one executes the
     * wrong change set.
     * If the call successfully completes, CloudFormation successfully deleted the change
     * set.
     * If IncludeNestedStacks specifies True during the creation of
     * the nested change set, then DeleteChangeSet will delete all change sets that
     * belong to the stacks hierarchy and will also delete all change sets for nested stacks with
     * the status of REVIEW_IN_PROGRESS.
     */
    suspend fun deleteChangeSet(block: DeleteChangeSetRequest.Builder.() -> Unit) = deleteChangeSet(DeleteChangeSetRequest.Builder().apply(block).build())

    /**
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts.
     * Deleted stacks don't show up in the DescribeStacks operation if the
     * deletion has been completed successfully.
     */
    suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse

    /**
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts.
     * Deleted stacks don't show up in the DescribeStacks operation if the
     * deletion has been completed successfully.
     */
    suspend fun deleteStack(block: DeleteStackRequest.Builder.() -> Unit) = deleteStack(DeleteStackRequest.Builder().apply(block).build())

    /**
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     */
    suspend fun deleteStackInstances(input: DeleteStackInstancesRequest): DeleteStackInstancesResponse

    /**
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     */
    suspend fun deleteStackInstances(block: DeleteStackInstancesRequest.Builder.() -> Unit) = deleteStackInstances(DeleteStackInstancesRequest.Builder().apply(block).build())

    /**
     * Deletes a stack set. Before you can delete a stack set, all of its member stack
     * instances must be deleted. For more information about how to do this, see DeleteStackInstances.
     */
    suspend fun deleteStackSet(input: DeleteStackSetRequest): DeleteStackSetResponse

    /**
     * Deletes a stack set. Before you can delete a stack set, all of its member stack
     * instances must be deleted. For more information about how to do this, see DeleteStackInstances.
     */
    suspend fun deleteStackSet(block: DeleteStackSetRequest.Builder.() -> Unit) = deleteStackSet(DeleteStackSetRequest.Builder().apply(block).build())

    /**
     * Marks an extension or extension version as DEPRECATED in the CloudFormation registry, removing it from active use. Deprecated extensions or
     * extension versions cannot be used in CloudFormation operations.
     * To deregister an entire extension, you must individually deregister all active versions
     * of that extension. If an extension has only a single active version, deregistering that
     * version results in the extension itself being deregistered and marked as deprecated in the
     * registry.
     * You can't deregister the default version of an extension if there are other active
     * version of that extension. If you do deregister the default version of an extension, the
     * extension type itself is deregistered as well and marked as deprecated.
     * To view the deprecation status of an extension or extension version, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType.
     */
    suspend fun deregisterType(input: DeregisterTypeRequest): DeregisterTypeResponse

    /**
     * Marks an extension or extension version as DEPRECATED in the CloudFormation registry, removing it from active use. Deprecated extensions or
     * extension versions cannot be used in CloudFormation operations.
     * To deregister an entire extension, you must individually deregister all active versions
     * of that extension. If an extension has only a single active version, deregistering that
     * version results in the extension itself being deregistered and marked as deprecated in the
     * registry.
     * You can't deregister the default version of an extension if there are other active
     * version of that extension. If you do deregister the default version of an extension, the
     * extension type itself is deregistered as well and marked as deprecated.
     * To view the deprecation status of an extension or extension version, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType.
     */
    suspend fun deregisterType(block: DeregisterTypeRequest.Builder.() -> Unit) = deregisterType(DeregisterTypeRequest.Builder().apply(block).build())

    /**
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks
     * that you can create in your account. For more information about account limits, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation Quotas in the
     * CloudFormation User Guide.
     */
    suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse

    /**
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks
     * that you can create in your account. For more information about account limits, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation Quotas in the
     * CloudFormation User Guide.
     */
    suspend fun describeAccountLimits(block: DescribeAccountLimitsRequest.Builder.() -> Unit) = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

    /**
     * Returns the inputs for the change set and a list of changes that CloudFormation will
     * make if you execute the change set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html">Updating Stacks Using Change Sets in the CloudFormation User Guide.
     */
    suspend fun describeChangeSet(input: DescribeChangeSetRequest): DescribeChangeSetResponse

    /**
     * Returns the inputs for the change set and a list of changes that CloudFormation will
     * make if you execute the change set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html">Updating Stacks Using Change Sets in the CloudFormation User Guide.
     */
    suspend fun describeChangeSet(block: DescribeChangeSetRequest.Builder.() -> Unit) = describeChangeSet(DescribeChangeSetRequest.Builder().apply(block).build())

    /**
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
     */
    suspend fun describeChangeSetHooks(input: DescribeChangeSetHooksRequest): DescribeChangeSetHooksResponse

    /**
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
     */
    suspend fun describeChangeSetHooks(block: DescribeChangeSetHooksRequest.Builder.() -> Unit) = describeChangeSetHooks(DescribeChangeSetHooksRequest.Builder().apply(block).build())

    /**
     * Returns information about a CloudFormation extension publisher.
     * If you don't supply a PublisherId, and you have registered as an extension
     * publisher, DescribePublisher returns information about your own publisher
     * account.
     * For more information on registering as a publisher, see:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use in the CloudFormation CLI User Guide
     */
    suspend fun describePublisher(input: DescribePublisherRequest): DescribePublisherResponse

    /**
     * Returns information about a CloudFormation extension publisher.
     * If you don't supply a PublisherId, and you have registered as an extension
     * publisher, DescribePublisher returns information about your own publisher
     * account.
     * For more information on registering as a publisher, see:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use in the CloudFormation CLI User Guide
     */
    suspend fun describePublisher(block: DescribePublisherRequest.Builder.() -> Unit) = describePublisher(DescribePublisherRequest.Builder().apply(block).build())

    /**
     * Returns information about a stack drift detection operation. A stack drift detection
     * operation detects whether a stack's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. A stack is considered to have
     * drifted if one or more of its resources have drifted. For more information on stack and
     * resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackDrift to initiate a stack drift detection operation.
     * DetectStackDrift returns a StackDriftDetectionId you can use
     * to monitor the progress of the operation using
     * DescribeStackDriftDetectionStatus. Once the drift detection operation has
     * completed, use DescribeStackResourceDrifts to return drift information
     * about the stack and its resources.
     */
    suspend fun describeStackDriftDetectionStatus(input: DescribeStackDriftDetectionStatusRequest): DescribeStackDriftDetectionStatusResponse

    /**
     * Returns information about a stack drift detection operation. A stack drift detection
     * operation detects whether a stack's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. A stack is considered to have
     * drifted if one or more of its resources have drifted. For more information on stack and
     * resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackDrift to initiate a stack drift detection operation.
     * DetectStackDrift returns a StackDriftDetectionId you can use
     * to monitor the progress of the operation using
     * DescribeStackDriftDetectionStatus. Once the drift detection operation has
     * completed, use DescribeStackResourceDrifts to return drift information
     * about the stack and its resources.
     */
    suspend fun describeStackDriftDetectionStatus(block: DescribeStackDriftDetectionStatusRequest.Builder.() -> Unit) = describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.Builder().apply(block).build())

    /**
     * Returns all stack related events for a specified stack in reverse chronological order.
     * For more information about a stack's event history, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks in the
     * CloudFormation User Guide.
     *
     * You can list events for stacks that have failed to create or have been deleted by
     * specifying the unique stack identifier (stack ID).
     */
    suspend fun describeStackEvents(input: DescribeStackEventsRequest): DescribeStackEventsResponse

    /**
     * Returns all stack related events for a specified stack in reverse chronological order.
     * For more information about a stack's event history, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks in the
     * CloudFormation User Guide.
     *
     * You can list events for stacks that have failed to create or have been deleted by
     * specifying the unique stack identifier (stack ID).
     */
    suspend fun describeStackEvents(block: DescribeStackEventsRequest.Builder.() -> Unit) = describeStackEvents(DescribeStackEventsRequest.Builder().apply(block).build())

    /**
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.
     * For a list of stack instances that are associated with a specific stack set, use ListStackInstances.
     */
    suspend fun describeStackInstance(input: DescribeStackInstanceRequest): DescribeStackInstanceResponse

    /**
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.
     * For a list of stack instances that are associated with a specific stack set, use ListStackInstances.
     */
    suspend fun describeStackInstance(block: DescribeStackInstanceRequest.Builder.() -> Unit) = describeStackInstance(DescribeStackInstanceRequest.Builder().apply(block).build())

    /**
     * Returns a description of the specified resource in the specified stack.
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days
     * after the stack has been deleted.
     */
    suspend fun describeStackResource(input: DescribeStackResourceRequest): DescribeStackResourceResponse

    /**
     * Returns a description of the specified resource in the specified stack.
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days
     * after the stack has been deleted.
     */
    suspend fun describeStackResource(block: DescribeStackResourceRequest.Builder.() -> Unit) = describeStackResource(DescribeStackResourceRequest.Builder().apply(block).build())

    /**
     * Returns drift information for the resources that have been checked for drift in the
     * specified stack. This includes actual and expected configuration values for resources where
     * CloudFormation detects configuration drift.
     * For a given stack, there will be one StackResourceDrift for each stack
     * resource that has been checked for drift. Resources that haven't yet been checked for drift
     * aren't included. Resources that don't currently support drift detection aren't checked, and
     * so not included. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     * Use DetectStackResourceDrift to detect drift on individual resources,
     * or DetectStackDrift to detect drift on all supported resources for a
     * given stack.
     */
    suspend fun describeStackResourceDrifts(input: DescribeStackResourceDriftsRequest): DescribeStackResourceDriftsResponse

    /**
     * Returns drift information for the resources that have been checked for drift in the
     * specified stack. This includes actual and expected configuration values for resources where
     * CloudFormation detects configuration drift.
     * For a given stack, there will be one StackResourceDrift for each stack
     * resource that has been checked for drift. Resources that haven't yet been checked for drift
     * aren't included. Resources that don't currently support drift detection aren't checked, and
     * so not included. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     * Use DetectStackResourceDrift to detect drift on individual resources,
     * or DetectStackDrift to detect drift on all supported resources for a
     * given stack.
     */
    suspend fun describeStackResourceDrifts(block: DescribeStackResourceDriftsRequest.Builder.() -> Unit) = describeStackResourceDrifts(DescribeStackResourceDriftsRequest.Builder().apply(block).build())

    /**
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If
     * StackName is specified, all the associated resources that are part of the
     * stack are returned. If PhysicalResourceId is specified, the associated
     * resources of the stack that the resource belongs to are returned.
     *
     * Only the first 100 resources will be returned. If your stack has more resources than
     * this, you should use ListStackResources instead.
     *
     * For deleted stacks, DescribeStackResources returns resource information for
     * up to 90 days after the stack has been deleted.
     * You must specify either StackName or PhysicalResourceId, but
     * not both. In addition, you can specify LogicalResourceId to filter the
     * returned result. For more information about resources, the LogicalResourceId
     * and PhysicalResourceId, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User
     * Guide.
     *
     * A ValidationError is returned if you specify both StackName
     * and PhysicalResourceId in the same request.
     */
    suspend fun describeStackResources(input: DescribeStackResourcesRequest): DescribeStackResourcesResponse

    /**
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If
     * StackName is specified, all the associated resources that are part of the
     * stack are returned. If PhysicalResourceId is specified, the associated
     * resources of the stack that the resource belongs to are returned.
     *
     * Only the first 100 resources will be returned. If your stack has more resources than
     * this, you should use ListStackResources instead.
     *
     * For deleted stacks, DescribeStackResources returns resource information for
     * up to 90 days after the stack has been deleted.
     * You must specify either StackName or PhysicalResourceId, but
     * not both. In addition, you can specify LogicalResourceId to filter the
     * returned result. For more information about resources, the LogicalResourceId
     * and PhysicalResourceId, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User
     * Guide.
     *
     * A ValidationError is returned if you specify both StackName
     * and PhysicalResourceId in the same request.
     */
    suspend fun describeStackResources(block: DescribeStackResourcesRequest.Builder.() -> Unit) = describeStackResources(DescribeStackResourcesRequest.Builder().apply(block).build())

    /**
     * Returns the description of the specified stack set.
     */
    suspend fun describeStackSet(input: DescribeStackSetRequest): DescribeStackSetResponse

    /**
     * Returns the description of the specified stack set.
     */
    suspend fun describeStackSet(block: DescribeStackSetRequest.Builder.() -> Unit) = describeStackSet(DescribeStackSetRequest.Builder().apply(block).build())

    /**
     * Returns the description of the specified stack set operation.
     */
    suspend fun describeStackSetOperation(input: DescribeStackSetOperationRequest): DescribeStackSetOperationResponse

    /**
     * Returns the description of the specified stack set operation.
     */
    suspend fun describeStackSetOperation(block: DescribeStackSetOperationRequest.Builder.() -> Unit) = describeStackSetOperation(DescribeStackSetOperationRequest.Builder().apply(block).build())

    /**
     * Returns the description for the specified stack; if no stack name was specified, then it
     * returns the description for all the stacks created.
     *
     * If the stack doesn't exist, an ValidationError is returned.
     */
    suspend fun describeStacks(input: DescribeStacksRequest): DescribeStacksResponse

    /**
     * Returns the description for the specified stack; if no stack name was specified, then it
     * returns the description for all the stacks created.
     *
     * If the stack doesn't exist, an ValidationError is returned.
     */
    suspend fun describeStacks(block: DescribeStacksRequest.Builder.() -> Unit) = describeStacks(DescribeStacksRequest.Builder().apply(block).build())

    /**
     * Returns detailed information about an extension that has been registered.
     * If you specify a VersionId, DescribeType returns information
     * about that specific extension version. Otherwise, it returns information about the default
     * extension version.
     */
    suspend fun describeType(input: DescribeTypeRequest): DescribeTypeResponse

    /**
     * Returns detailed information about an extension that has been registered.
     * If you specify a VersionId, DescribeType returns information
     * about that specific extension version. Otherwise, it returns information about the default
     * extension version.
     */
    suspend fun describeType(block: DescribeTypeRequest.Builder.() -> Unit) = describeType(DescribeTypeRequest.Builder().apply(block).build())

    /**
     * Returns information about an extension's registration, including its current status and
     * type and version identifiers.
     * When you initiate a registration request using
     * RegisterType
     * , you can then use
     * DescribeTypeRegistration
     * to
     * monitor the progress of that registration request.
     * Once the registration request has completed, use
     * DescribeType
     * to return detailed information about an extension.
     */
    suspend fun describeTypeRegistration(input: DescribeTypeRegistrationRequest): DescribeTypeRegistrationResponse

    /**
     * Returns information about an extension's registration, including its current status and
     * type and version identifiers.
     * When you initiate a registration request using
     * RegisterType
     * , you can then use
     * DescribeTypeRegistration
     * to
     * monitor the progress of that registration request.
     * Once the registration request has completed, use
     * DescribeType
     * to return detailed information about an extension.
     */
    suspend fun describeTypeRegistration(block: DescribeTypeRegistrationRequest.Builder.() -> Unit) = describeTypeRegistration(DescribeTypeRegistrationRequest.Builder().apply(block).build())

    /**
     * Detects whether a stack's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with
     * its expected template configuration. Only resource properties explicitly defined in the
     * stack template are checked for drift. A stack is considered to have drifted if one or more
     * of its resources differ from their expected template configurations. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackDrift to detect drift on all supported resources for a given
     * stack, or DetectStackResourceDrift to detect drift on individual
     * resources.
     * For a list of stack resources that currently support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     *
     * DetectStackDrift can take up to several minutes, depending on the number of
     * resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection
     * operation has completed, use DescribeStackResourceDrifts to return drift
     * information about the stack and its resources.
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks
     * belonging to that stack. Perform DetectStackDrift directly on the nested stack
     * itself.
     */
    suspend fun detectStackDrift(input: DetectStackDriftRequest): DetectStackDriftResponse

    /**
     * Detects whether a stack's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with
     * its expected template configuration. Only resource properties explicitly defined in the
     * stack template are checked for drift. A stack is considered to have drifted if one or more
     * of its resources differ from their expected template configurations. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackDrift to detect drift on all supported resources for a given
     * stack, or DetectStackResourceDrift to detect drift on individual
     * resources.
     * For a list of stack resources that currently support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     *
     * DetectStackDrift can take up to several minutes, depending on the number of
     * resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection
     * operation has completed, use DescribeStackResourceDrifts to return drift
     * information about the stack and its resources.
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks
     * belonging to that stack. Perform DetectStackDrift directly on the nested stack
     * itself.
     */
    suspend fun detectStackDrift(block: DetectStackDriftRequest.Builder.() -> Unit) = detectStackDrift(DetectStackDriftRequest.Builder().apply(block).build())

    /**
     * Returns information about whether a resource's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. This information includes actual
     * and expected property values for resources in which CloudFormation detects drift. Only resource
     * properties explicitly defined in the stack template are checked for drift. For more
     * information about stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackResourceDrift to detect drift on individual resources, or
     * DetectStackDrift to detect drift on all resources in a given stack
     * that support drift detection.
     * Resources that don't currently support drift detection can't be checked. For a list of
     * resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     */
    suspend fun detectStackResourceDrift(input: DetectStackResourceDriftRequest): DetectStackResourceDriftResponse

    /**
     * Returns information about whether a resource's actual configuration differs, or has
     * drifted, from it's expected configuration, as defined in the stack
     * template and any values specified as template parameters. This information includes actual
     * and expected property values for resources in which CloudFormation detects drift. Only resource
     * properties explicitly defined in the stack template are checked for drift. For more
     * information about stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources.
     * Use DetectStackResourceDrift to detect drift on individual resources, or
     * DetectStackDrift to detect drift on all resources in a given stack
     * that support drift detection.
     * Resources that don't currently support drift detection can't be checked. For a list of
     * resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection.
     */
    suspend fun detectStackResourceDrift(block: DetectStackResourceDriftRequest.Builder.() -> Unit) = detectStackResourceDrift(DetectStackResourceDriftRequest.Builder().apply(block).build())

    /**
     * Detect drift on a stack set. When CloudFormation performs drift detection on a
     * stack set, it performs drift detection on the stack associated with each stack instance in
     * the stack set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation performs drift detection on a stack set.
     *
     * DetectStackSetDrift returns the OperationId of the stack set
     * drift detection operation. Use this operation id with
     * DescribeStackSetOperation
     * to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the
     * number of stack instances included in the stack set, in addition to the number of resources
     * included in each stack.
     * Once the operation has completed, use the following actions to return drift
     * information:
     *
     *
     * Use
     * DescribeStackSet
     * to return detailed information
     * about the stack set, including detailed information about the last
     * completed drift operation performed on the stack set.
     * (Information about drift operations that are in progress isn't included.)
     *
     * Use
     * ListStackInstances
     * to return a list of stack
     * instances belonging to the stack set, including the drift status and last drift time
     * checked of each instance.
     *
     * Use
     * DescribeStackInstance
     * to return detailed
     * information about a specific stack instance, including its drift status and last
     * drift time checked.
     *
     *
     * For more information on performing a drift detection operation on a stack set, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting unmanaged
     * changes in stack sets.
     * You can only run a single drift detection operation on a given stack set at one
     * time.
     * To stop a drift detection stack set operation, use
     * StopStackSetOperation
     * .
     */
    suspend fun detectStackSetDrift(input: DetectStackSetDriftRequest): DetectStackSetDriftResponse

    /**
     * Detect drift on a stack set. When CloudFormation performs drift detection on a
     * stack set, it performs drift detection on the stack associated with each stack instance in
     * the stack set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation performs drift detection on a stack set.
     *
     * DetectStackSetDrift returns the OperationId of the stack set
     * drift detection operation. Use this operation id with
     * DescribeStackSetOperation
     * to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the
     * number of stack instances included in the stack set, in addition to the number of resources
     * included in each stack.
     * Once the operation has completed, use the following actions to return drift
     * information:
     *
     *
     * Use
     * DescribeStackSet
     * to return detailed information
     * about the stack set, including detailed information about the last
     * completed drift operation performed on the stack set.
     * (Information about drift operations that are in progress isn't included.)
     *
     * Use
     * ListStackInstances
     * to return a list of stack
     * instances belonging to the stack set, including the drift status and last drift time
     * checked of each instance.
     *
     * Use
     * DescribeStackInstance
     * to return detailed
     * information about a specific stack instance, including its drift status and last
     * drift time checked.
     *
     *
     * For more information on performing a drift detection operation on a stack set, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting unmanaged
     * changes in stack sets.
     * You can only run a single drift detection operation on a given stack set at one
     * time.
     * To stop a drift detection stack set operation, use
     * StopStackSetOperation
     * .
     */
    suspend fun detectStackSetDrift(block: DetectStackSetDriftRequest.Builder.() -> Unit) = detectStackSetDrift(DetectStackSetDriftRequest.Builder().apply(block).build())

    /**
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the
     * resources required to run the template.
     */
    suspend fun estimateTemplateCost(input: EstimateTemplateCostRequest): EstimateTemplateCostResponse

    /**
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the
     * resources required to run the template.
     */
    suspend fun estimateTemplateCost(block: EstimateTemplateCostRequest.Builder.() -> Unit) = estimateTemplateCost(EstimateTemplateCostRequest.Builder().apply(block).build())

    /**
     * Updates a stack using the input information that was provided when the specified change
     * set was created. After the call successfully completes, CloudFormation starts updating
     * the stack. Use the DescribeStacks action to view the status of the
     * update.
     * When you execute a change set, CloudFormation deletes all other change sets
     * associated with the stack because they aren't valid for the updated stack.
     * If a stack policy is associated with the stack, CloudFormation enforces the policy
     * during the update. You can't specify a temporary stack policy that overrides the current
     * policy.
     * To create a change set for the entire stack hierarchy, IncludeNestedStacks
     * must have been set to True.
     */
    suspend fun executeChangeSet(input: ExecuteChangeSetRequest): ExecuteChangeSetResponse

    /**
     * Updates a stack using the input information that was provided when the specified change
     * set was created. After the call successfully completes, CloudFormation starts updating
     * the stack. Use the DescribeStacks action to view the status of the
     * update.
     * When you execute a change set, CloudFormation deletes all other change sets
     * associated with the stack because they aren't valid for the updated stack.
     * If a stack policy is associated with the stack, CloudFormation enforces the policy
     * during the update. You can't specify a temporary stack policy that overrides the current
     * policy.
     * To create a change set for the entire stack hierarchy, IncludeNestedStacks
     * must have been set to True.
     */
    suspend fun executeChangeSet(block: ExecuteChangeSetRequest.Builder.() -> Unit) = executeChangeSet(ExecuteChangeSetRequest.Builder().apply(block).build())

    /**
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null
     * value is returned.
     */
    suspend fun getStackPolicy(input: GetStackPolicyRequest): GetStackPolicyResponse

    /**
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null
     * value is returned.
     */
    suspend fun getStackPolicy(block: GetStackPolicyRequest.Builder.() -> Unit) = getStackPolicy(GetStackPolicyRequest.Builder().apply(block).build())

    /**
     * Returns the template body for a specified stack. You can get the template for running or
     * deleted stacks.
     * For deleted stacks, GetTemplate returns the template for up to 90 days
     * after the stack has been deleted.
     *
     * If the template doesn't exist, a ValidationError is returned.
     */
    suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse

    /**
     * Returns the template body for a specified stack. You can get the template for running or
     * deleted stacks.
     * For deleted stacks, GetTemplate returns the template for up to 90 days
     * after the stack has been deleted.
     *
     * If the template doesn't exist, a ValidationError is returned.
     */
    suspend fun getTemplate(block: GetTemplateRequest.Builder.() -> Unit) = getTemplate(GetTemplateRequest.Builder().apply(block).build())

    /**
     * Returns information about a new or existing template. The
     * GetTemplateSummary action is useful for viewing parameter information, such
     * as default parameter values and parameter types, before you create or update a stack or
     * stack set.
     * You can use the GetTemplateSummary action when you submit a template, or
     * you can get template information for a stack set, or a running or deleted stack.
     * For deleted stacks, GetTemplateSummary returns the template information for
     * up to 90 days after the stack has been deleted. If the template doesn't exist, a
     * ValidationError is returned.
     */
    suspend fun getTemplateSummary(input: GetTemplateSummaryRequest): GetTemplateSummaryResponse

    /**
     * Returns information about a new or existing template. The
     * GetTemplateSummary action is useful for viewing parameter information, such
     * as default parameter values and parameter types, before you create or update a stack or
     * stack set.
     * You can use the GetTemplateSummary action when you submit a template, or
     * you can get template information for a stack set, or a running or deleted stack.
     * For deleted stacks, GetTemplateSummary returns the template information for
     * up to 90 days after the stack has been deleted. If the template doesn't exist, a
     * ValidationError is returned.
     */
    suspend fun getTemplateSummary(block: GetTemplateSummaryRequest.Builder.() -> Unit) = getTemplateSummary(GetTemplateSummaryRequest.Builder().apply(block).build())

    /**
     * Import existing stacks into a new stack sets. Use the stack import operation to import
     * up to 10 stacks into a new stack set in the same account as the source stack or in a
     * different administrator account and Region, by specifying the stack ID of the stack you
     * intend to import.
     *
     *
     * ImportStacksToStackSet is only supported by self-managed
     * permissions.
     */
    suspend fun importStacksToStackSet(input: ImportStacksToStackSetRequest): ImportStacksToStackSetResponse

    /**
     * Import existing stacks into a new stack sets. Use the stack import operation to import
     * up to 10 stacks into a new stack set in the same account as the source stack or in a
     * different administrator account and Region, by specifying the stack ID of the stack you
     * intend to import.
     *
     *
     * ImportStacksToStackSet is only supported by self-managed
     * permissions.
     */
    suspend fun importStacksToStackSet(block: ImportStacksToStackSetRequest.Builder.() -> Unit) = importStacksToStackSet(ImportStacksToStackSetRequest.Builder().apply(block).build())

    /**
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or
     * CREATE_PENDING state.
     */
    suspend fun listChangeSets(input: ListChangeSetsRequest): ListChangeSetsResponse

    /**
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or
     * CREATE_PENDING state.
     */
    suspend fun listChangeSets(block: ListChangeSetsRequest.Builder.() -> Unit) = listChangeSets(ListChangeSetsRequest.Builder().apply(block).build())

    /**
     * Lists all exported output values in the account and Region in which you call this
     * action. Use this action to see the exported output values that you can import into other
     * stacks. To import values, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue
     * function.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation export stack output values.
     */
    suspend fun listExports(input: ListExportsRequest): ListExportsResponse

    /**
     * Lists all exported output values in the account and Region in which you call this
     * action. Use this action to see the exported output values that you can import into other
     * stacks. To import values, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue
     * function.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation export stack output values.
     */
    suspend fun listExports(block: ListExportsRequest.Builder.() -> Unit) = listExports(ListExportsRequest.Builder().apply(block).build())

    /**
     * Lists all stacks that are importing an exported output value. To modify or remove an
     * exported output value, first use this action to see which stacks are using it. To see the
     * exported output values in your account, see ListExports.
     * For more information about importing an exported output value, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue
     * function.
     */
    suspend fun listImports(input: ListImportsRequest): ListImportsResponse

    /**
     * Lists all stacks that are importing an exported output value. To modify or remove an
     * exported output value, first use this action to see which stacks are using it. To see the
     * exported output values in your account, see ListExports.
     * For more information about importing an exported output value, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue
     * function.
     */
    suspend fun listImports(block: ListImportsRequest.Builder.() -> Unit) = listImports(ListImportsRequest.Builder().apply(block).build())

    /**
     * Returns summary information about stack instances that are associated with the specified
     * stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
     */
    suspend fun listStackInstances(input: ListStackInstancesRequest): ListStackInstancesResponse

    /**
     * Returns summary information about stack instances that are associated with the specified
     * stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
     */
    suspend fun listStackInstances(block: ListStackInstancesRequest.Builder.() -> Unit) = listStackInstances(ListStackInstancesRequest.Builder().apply(block).build())

    /**
     * Returns descriptions of all resources of the specified stack.
     * For deleted stacks, ListStackResources returns resource information for up to 90 days
     * after the stack has been deleted.
     */
    suspend fun listStackResources(input: ListStackResourcesRequest): ListStackResourcesResponse

    /**
     * Returns descriptions of all resources of the specified stack.
     * For deleted stacks, ListStackResources returns resource information for up to 90 days
     * after the stack has been deleted.
     */
    suspend fun listStackResources(block: ListStackResourcesRequest.Builder.() -> Unit) = listStackResources(ListStackResourcesRequest.Builder().apply(block).build())

    /**
     * Returns summary information about the results of a stack set operation.
     */
    suspend fun listStackSetOperationResults(input: ListStackSetOperationResultsRequest): ListStackSetOperationResultsResponse

    /**
     * Returns summary information about the results of a stack set operation.
     */
    suspend fun listStackSetOperationResults(block: ListStackSetOperationResultsRequest.Builder.() -> Unit) = listStackSetOperationResults(ListStackSetOperationResultsRequest.Builder().apply(block).build())

    /**
     * Returns summary information about operations performed on a stack set.
     */
    suspend fun listStackSetOperations(input: ListStackSetOperationsRequest): ListStackSetOperationsResponse

    /**
     * Returns summary information about operations performed on a stack set.
     */
    suspend fun listStackSetOperations(block: ListStackSetOperationsRequest.Builder.() -> Unit) = listStackSetOperations(ListStackSetOperationsRequest.Builder().apply(block).build())

    /**
     * Returns summary information about stack sets that are associated with the user.
     *
     *
     * &#91;Self-managed permissions&#93; If you set the CallAs parameter to
     * SELF while signed in to your Amazon Web Services account,
     * ListStackSets returns all self-managed stack sets in your Amazon Web Services account.
     *
     * &#91;Service-managed permissions&#93; If you set the CallAs parameter to
     * SELF while signed in to the organization's management account, ListStackSets returns all stack sets in the
     * management account.
     *
     * &#91;Service-managed permissions&#93; If you set the CallAs parameter to
     * DELEGATED_ADMIN while signed in to your member account,
     * ListStackSets returns all stack sets with service-managed permissions
     * in the management account.
     */
    suspend fun listStackSets(input: ListStackSetsRequest): ListStackSetsResponse

    /**
     * Returns summary information about stack sets that are associated with the user.
     *
     *
     * &#91;Self-managed permissions&#93; If you set the CallAs parameter to
     * SELF while signed in to your Amazon Web Services account,
     * ListStackSets returns all self-managed stack sets in your Amazon Web Services account.
     *
     * &#91;Service-managed permissions&#93; If you set the CallAs parameter to
     * SELF while signed in to the organization's management account, ListStackSets returns all stack sets in the
     * management account.
     *
     * &#91;Service-managed permissions&#93; If you set the CallAs parameter to
     * DELEGATED_ADMIN while signed in to your member account,
     * ListStackSets returns all stack sets with service-managed permissions
     * in the management account.
     */
    suspend fun listStackSets(block: ListStackSetsRequest.Builder.() -> Unit) = listStackSets(ListStackSetsRequest.Builder().apply(block).build())

    /**
     * Returns the summary information for stacks whose status matches the specified
     * StackStatusFilter. Summary information for stacks that have been deleted is kept for 90
     * days after the stack is deleted. If no StackStatusFilter is specified, summary information
     * for all stacks is returned (including existing stacks and stacks that have been
     * deleted).
     */
    suspend fun listStacks(input: ListStacksRequest): ListStacksResponse

    /**
     * Returns the summary information for stacks whose status matches the specified
     * StackStatusFilter. Summary information for stacks that have been deleted is kept for 90
     * days after the stack is deleted. If no StackStatusFilter is specified, summary information
     * for all stacks is returned (including existing stacks and stacks that have been
     * deleted).
     */
    suspend fun listStacks(block: ListStacksRequest.Builder.() -> Unit) = listStacks(ListStacksRequest.Builder().apply(block).build())

    /**
     * Returns a list of registration tokens for the specified extension(s).
     */
    suspend fun listTypeRegistrations(input: ListTypeRegistrationsRequest): ListTypeRegistrationsResponse

    /**
     * Returns a list of registration tokens for the specified extension(s).
     */
    suspend fun listTypeRegistrations(block: ListTypeRegistrationsRequest.Builder.() -> Unit) = listTypeRegistrations(ListTypeRegistrationsRequest.Builder().apply(block).build())

    /**
     * Returns summary information about the versions of an extension.
     */
    suspend fun listTypeVersions(input: ListTypeVersionsRequest): ListTypeVersionsResponse

    /**
     * Returns summary information about the versions of an extension.
     */
    suspend fun listTypeVersions(block: ListTypeVersionsRequest.Builder.() -> Unit) = listTypeVersions(ListTypeVersionsRequest.Builder().apply(block).build())

    /**
     * Returns summary information about extension that have been registered with CloudFormation.
     */
    suspend fun listTypes(input: ListTypesRequest): ListTypesResponse

    /**
     * Returns summary information about extension that have been registered with CloudFormation.
     */
    suspend fun listTypes(block: ListTypesRequest.Builder.() -> Unit) = listTypes(ListTypesRequest.Builder().apply(block).build())

    /**
     * Publishes the specified extension to the CloudFormation registry as a public
     * extension in this region. Public extensions are available for use by all CloudFormation users. For more information on publishing extensions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing extensions to make them available for public use in the
     * CloudFormation CLI User Guide.
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher.
     */
    suspend fun publishType(input: PublishTypeRequest): PublishTypeResponse

    /**
     * Publishes the specified extension to the CloudFormation registry as a public
     * extension in this region. Public extensions are available for use by all CloudFormation users. For more information on publishing extensions, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing extensions to make them available for public use in the
     * CloudFormation CLI User Guide.
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">RegisterPublisher.
     */
    suspend fun publishType(block: PublishTypeRequest.Builder.() -> Unit) = publishType(PublishTypeRequest.Builder().apply(block).build())

    /**
     * Reports progress of a resource handler to CloudFormation.
     * Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI. Don't use this API in your code.
     */
    suspend fun recordHandlerProgress(input: RecordHandlerProgressRequest): RecordHandlerProgressResponse

    /**
     * Reports progress of a resource handler to CloudFormation.
     * Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI. Don't use this API in your code.
     */
    suspend fun recordHandlerProgress(block: RecordHandlerProgressRequest.Builder.() -> Unit) = recordHandlerProgress(RecordHandlerProgressRequest.Builder().apply(block).build())

    /**
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users.
     * This publisher ID applies to your account in all Amazon Web Services Regions.
     * For information on requirements for registering as a public extension publisher, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
     * extensions in the CloudFormation CLI User
     * Guide.
     */
    suspend fun registerPublisher(input: RegisterPublisherRequest): RegisterPublisherResponse

    /**
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users.
     * This publisher ID applies to your account in all Amazon Web Services Regions.
     * For information on requirements for registering as a public extension publisher, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation
     * extensions in the CloudFormation CLI User
     * Guide.
     */
    suspend fun registerPublisher(block: RegisterPublisherRequest.Builder.() -> Unit) = registerPublisher(RegisterPublisherRequest.Builder().apply(block).build())

    /**
     * Registers an extension with the CloudFormation service. Registering an
     * extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
     *
     *
     * Validating the extension schema.
     *
     * Determining which handlers, if any, have been specified for the extension.
     *
     * Making the extension available for use in your account.
     *
     *
     * For more information on how to develop extensions and ready them for registration, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers in the CloudFormation CLI User
     * Guide.
     * You can have a maximum of 50 resource extension versions registered at a time. This
     * maximum is per account and per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType to deregister specific extension versions if necessary.
     * Once you have initiated a registration request using
     * RegisterType
     * , you can use
     * DescribeTypeRegistration
     * to
     * monitor the progress of the registration request.
     * Once you have registered a private extension in your account and region, use <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration to specify configuration properties for the extension. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
     */
    suspend fun registerType(input: RegisterTypeRequest): RegisterTypeResponse

    /**
     * Registers an extension with the CloudFormation service. Registering an
     * extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
     *
     *
     * Validating the extension schema.
     *
     * Determining which handlers, if any, have been specified for the extension.
     *
     * Making the extension available for use in your account.
     *
     *
     * For more information on how to develop extensions and ready them for registration, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers in the CloudFormation CLI User
     * Guide.
     * You can have a maximum of 50 resource extension versions registered at a time. This
     * maximum is per account and per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType to deregister specific extension versions if necessary.
     * Once you have initiated a registration request using
     * RegisterType
     * , you can use
     * DescribeTypeRegistration
     * to
     * monitor the progress of the registration request.
     * Once you have registered a private extension in your account and region, use <a href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration to specify configuration properties for the extension. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the CloudFormation User Guide.
     */
    suspend fun registerType(block: RegisterTypeRequest.Builder.() -> Unit) = registerType(RegisterTypeRequest.Builder().apply(block).build())

    /**
     * When specifying RollbackStack, you preserve the state of previously
     * provisioned resources when an operation fails. You can check the status of the stack
     * through the DescribeStacks operation.
     * Rolls back the specified stack to the last known stable state from
     * CREATE_FAILED or UPDATE_FAILED stack statuses.
     * This operation will delete a stack if it doesn't contain a last known stable state. A
     * last known stable state includes any status in a *_COMPLETE. This includes the
     * following stack statuses.
     *
     *
     *
     * CREATE_COMPLETE
     *
     *
     *
     * UPDATE_COMPLETE
     *
     *
     *
     * UPDATE_ROLLBACK_COMPLETE
     *
     *
     *
     * IMPORT_COMPLETE
     *
     *
     *
     * IMPORT_ROLLBACK_COMPLETE
     */
    suspend fun rollbackStack(input: RollbackStackRequest): RollbackStackResponse

    /**
     * When specifying RollbackStack, you preserve the state of previously
     * provisioned resources when an operation fails. You can check the status of the stack
     * through the DescribeStacks operation.
     * Rolls back the specified stack to the last known stable state from
     * CREATE_FAILED or UPDATE_FAILED stack statuses.
     * This operation will delete a stack if it doesn't contain a last known stable state. A
     * last known stable state includes any status in a *_COMPLETE. This includes the
     * following stack statuses.
     *
     *
     *
     * CREATE_COMPLETE
     *
     *
     *
     * UPDATE_COMPLETE
     *
     *
     *
     * UPDATE_ROLLBACK_COMPLETE
     *
     *
     *
     * IMPORT_COMPLETE
     *
     *
     *
     * IMPORT_ROLLBACK_COMPLETE
     */
    suspend fun rollbackStack(block: RollbackStackRequest.Builder.() -> Unit) = rollbackStack(RollbackStackRequest.Builder().apply(block).build())

    /**
     * Sets a stack policy for a specified stack.
     */
    suspend fun setStackPolicy(input: SetStackPolicyRequest): SetStackPolicyResponse

    /**
     * Sets a stack policy for a specified stack.
     */
    suspend fun setStackPolicy(block: SetStackPolicyRequest.Builder.() -> Unit) = setStackPolicy(SetStackPolicyRequest.Builder().apply(block).build())

    /**
     * Specifies the configuration data for a registered CloudFormation extension, in
     * the given account and region.
     * To view the current configuration data for an extension, refer to the
     * ConfigurationSchema element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the
     * CloudFormation User Guide.
     *
     * It's strongly recommended that you use dynamic references to restrict sensitive
     * configuration definitions, such as third-party credentials. For more details on dynamic
     * references, see <a href="https://docs.aws.amazon.com/">Using dynamic references to specify
     * template values in the CloudFormation User
     * Guide.
     */
    suspend fun setTypeConfiguration(input: SetTypeConfigurationRequest): SetTypeConfigurationResponse

    /**
     * Specifies the configuration data for a registered CloudFormation extension, in
     * the given account and region.
     * To view the current configuration data for an extension, refer to the
     * ConfigurationSchema element of <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the
     * CloudFormation User Guide.
     *
     * It's strongly recommended that you use dynamic references to restrict sensitive
     * configuration definitions, such as third-party credentials. For more details on dynamic
     * references, see <a href="https://docs.aws.amazon.com/">Using dynamic references to specify
     * template values in the CloudFormation User
     * Guide.
     */
    suspend fun setTypeConfiguration(block: SetTypeConfigurationRequest.Builder.() -> Unit) = setTypeConfiguration(SetTypeConfigurationRequest.Builder().apply(block).build())

    /**
     * Specify the default version of an extension. The default version of an extension will be
     * used in CloudFormation operations.
     */
    suspend fun setTypeDefaultVersion(input: SetTypeDefaultVersionRequest): SetTypeDefaultVersionResponse

    /**
     * Specify the default version of an extension. The default version of an extension will be
     * used in CloudFormation operations.
     */
    suspend fun setTypeDefaultVersion(block: SetTypeDefaultVersionRequest.Builder.() -> Unit) = setTypeDefaultVersion(SetTypeDefaultVersionRequest.Builder().apply(block).build())

    /**
     * Sends a signal to the specified resource with a success or failure status. You can use
     * the SignalResource operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive
     * the required number of signals or the timeout period is exceeded. The SignalResource operation is
     * useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     */
    suspend fun signalResource(input: SignalResourceRequest): SignalResourceResponse

    /**
     * Sends a signal to the specified resource with a success or failure status. You can use
     * the SignalResource operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive
     * the required number of signals or the timeout period is exceeded. The SignalResource operation is
     * useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     */
    suspend fun signalResource(block: SignalResourceRequest.Builder.() -> Unit) = signalResource(SignalResourceRequest.Builder().apply(block).build())

    /**
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
     */
    suspend fun stopStackSetOperation(input: StopStackSetOperationRequest): StopStackSetOperationResponse

    /**
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
     */
    suspend fun stopStackSetOperation(block: StopStackSetOperationRequest.Builder.() -> Unit) = stopStackSetOperation(StopStackSetOperationRequest.Builder().apply(block).build())

    /**
     * Tests a registered extension to make sure it meets all necessary requirements for being
     * published in the CloudFormation registry.
     *
     *
     * For resource types, this includes passing all contracts tests defined for the
     * type.
     *
     * For modules, this includes determining if the module's model meets all necessary
     * requirements.
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing">Testing your public extension prior to publishing in the CloudFormation CLI User Guide.
     * If you don't specify a version, CloudFormation uses the default version of the
     * extension in your account and region for testing.
     * To perform testing, CloudFormation assumes the execution role specified when
     * the type was registered. For more information, see <a href="AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     * Once you've initiated testing on an extension using TestType, you can use
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType to monitor the current test status and test
     * status description for the extension.
     * An extension must have a test status of PASSED before it can be published.
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public use
     * in the CloudFormation CLI User Guide.
     */
    suspend fun testType(input: TestTypeRequest): TestTypeResponse

    /**
     * Tests a registered extension to make sure it meets all necessary requirements for being
     * published in the CloudFormation registry.
     *
     *
     * For resource types, this includes passing all contracts tests defined for the
     * type.
     *
     * For modules, this includes determining if the module's model meets all necessary
     * requirements.
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing">Testing your public extension prior to publishing in the CloudFormation CLI User Guide.
     * If you don't specify a version, CloudFormation uses the default version of the
     * extension in your account and region for testing.
     * To perform testing, CloudFormation assumes the execution role specified when
     * the type was registered. For more information, see <a href="AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType.
     * Once you've initiated testing on an extension using TestType, you can use
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType to monitor the current test status and test
     * status description for the extension.
     * An extension must have a test status of PASSED before it can be published.
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public use
     * in the CloudFormation CLI User Guide.
     */
    suspend fun testType(block: TestTypeRequest.Builder.() -> Unit) = testType(TestTypeRequest.Builder().apply(block).build())

    /**
     * Updates a stack as specified in the template. After the call completes successfully, the
     * stack update starts. You can check the status of the stack through the DescribeStacks action.
     * To get a copy of the template for an existing stack, you can use the GetTemplate action.
     * For more information about creating an update template, updating a stack, and monitoring
     * the progress of the update, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack.
     */
    suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse

    /**
     * Updates a stack as specified in the template. After the call completes successfully, the
     * stack update starts. You can check the status of the stack through the DescribeStacks action.
     * To get a copy of the template for an existing stack, you can use the GetTemplate action.
     * For more information about creating an update template, updating a stack, and monitoring
     * the progress of the update, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack.
     */
    suspend fun updateStack(block: UpdateStackRequest.Builder.() -> Unit) = updateStack(UpdateStackRequest.Builder().apply(block).build())

    /**
     * Updates the parameter values for stack instances for the specified accounts, within the
     * specified Amazon Web Services Regions. A stack instance refers to a stack in a specific
     * account and Region.
     * You can only update stack instances in Amazon Web Services Regions and accounts where
     * they already exist; to create additional stack instances, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html">CreateStackInstances.
     * During stack set updates, any parameters overridden for a stack instance aren't updated,
     * but retain their overridden value.
     * You can only update the parameter values that are specified in the
     * stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet to update the stack set template. If you add a parameter to a
     * template, before you can override the parameter value specified in the stack set you must
     * first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet to update all stack instances with the updated template and
     * parameter value specified in the stack set. Once a stack instance has been updated with the
     * new parameter, you can then override the parameter value using
     * UpdateStackInstances.
     */
    suspend fun updateStackInstances(input: UpdateStackInstancesRequest): UpdateStackInstancesResponse

    /**
     * Updates the parameter values for stack instances for the specified accounts, within the
     * specified Amazon Web Services Regions. A stack instance refers to a stack in a specific
     * account and Region.
     * You can only update stack instances in Amazon Web Services Regions and accounts where
     * they already exist; to create additional stack instances, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html">CreateStackInstances.
     * During stack set updates, any parameters overridden for a stack instance aren't updated,
     * but retain their overridden value.
     * You can only update the parameter values that are specified in the
     * stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet to update the stack set template. If you add a parameter to a
     * template, before you can override the parameter value specified in the stack set you must
     * first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet to update all stack instances with the updated template and
     * parameter value specified in the stack set. Once a stack instance has been updated with the
     * new parameter, you can then override the parameter value using
     * UpdateStackInstances.
     */
    suspend fun updateStackInstances(block: UpdateStackInstancesRequest.Builder.() -> Unit) = updateStackInstances(UpdateStackInstancesRequest.Builder().apply(block).build())

    /**
     * Updates the stack set, and associated stack instances in the specified accounts and
     * Amazon Web Services Regions.
     * Even if the stack set operation created by updating the stack set fails (completely or
     * partially, below or above a specified failure tolerance), the stack set is updated with
     * your changes. Subsequent CreateStackInstances calls on the specified
     * stack set use the updated stack set.
     */
    suspend fun updateStackSet(input: UpdateStackSetRequest): UpdateStackSetResponse

    /**
     * Updates the stack set, and associated stack instances in the specified accounts and
     * Amazon Web Services Regions.
     * Even if the stack set operation created by updating the stack set fails (completely or
     * partially, below or above a specified failure tolerance), the stack set is updated with
     * your changes. Subsequent CreateStackInstances calls on the specified
     * stack set use the updated stack set.
     */
    suspend fun updateStackSet(block: UpdateStackSetRequest.Builder.() -> Unit) = updateStackSet(UpdateStackSetRequest.Builder().apply(block).build())

    /**
     * Updates termination protection for the specified stack. If a user attempts to delete a
     * stack with termination protection enabled, the operation fails and the stack remains
     * unchanged. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted in the CloudFormation User Guide.
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks, termination protection is set on the root stack and can't be changed
     * directly on the nested stack.
     */
    suspend fun updateTerminationProtection(input: UpdateTerminationProtectionRequest): UpdateTerminationProtectionResponse

    /**
     * Updates termination protection for the specified stack. If a user attempts to delete a
     * stack with termination protection enabled, the operation fails and the stack remains
     * unchanged. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted in the CloudFormation User Guide.
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks, termination protection is set on the root stack and can't be changed
     * directly on the nested stack.
     */
    suspend fun updateTerminationProtection(block: UpdateTerminationProtectionRequest.Builder.() -> Unit) = updateTerminationProtection(UpdateTerminationProtectionRequest.Builder().apply(block).build())

    /**
     * Validates a specified template. CloudFormation first checks if the template is
     * valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If
     * both these checks fail, CloudFormation returns a template validation error.
     */
    suspend fun validateTemplate(input: ValidateTemplateRequest): ValidateTemplateResponse

    /**
     * Validates a specified template. CloudFormation first checks if the template is
     * valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If
     * both these checks fail, CloudFormation returns a template validation error.
     */
    suspend fun validateTemplate(block: ValidateTemplateRequest.Builder.() -> Unit) = validateTemplate(ValidateTemplateRequest.Builder().apply(block).build())
}
