// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.TemplateParameter
import aws.sdk.kotlin.services.cloudformation.model.ValidateTemplateResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ValidateTemplateOperationDeserializer: HttpDeserializer.NonStreaming<ValidateTemplateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ValidateTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwValidateTemplateError(context, call, payload)
        }
        val builder = ValidateTemplateResponse.Builder()

        if (payload != null) {
            deserializeValidateTemplateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwValidateTemplateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateTemplateOperationBody(builder: ValidateTemplateResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ValidateTemplate")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Capabilities com.amazonaws.cloudformation#ValidateTemplateOutput$Capabilities
            "Capabilities" -> builder.capabilities = deserializeCapabilitiesShape(curr)
            // CapabilitiesReason com.amazonaws.cloudformation#ValidateTemplateOutput$CapabilitiesReason
            "CapabilitiesReason" -> builder.capabilitiesReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#CapabilitiesReason`)" }
            // DeclaredTransforms com.amazonaws.cloudformation#ValidateTemplateOutput$DeclaredTransforms
            "DeclaredTransforms" -> builder.declaredTransforms = deserializeTransformsListShape(curr)
            // Description com.amazonaws.cloudformation#ValidateTemplateOutput$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Parameters com.amazonaws.cloudformation#ValidateTemplateOutput$Parameters
            "Parameters" -> builder.parameters = deserializeTemplateParametersShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
