// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.IdentityProvider
import aws.sdk.kotlin.services.cloudformation.model.RegistryType
import aws.sdk.kotlin.services.cloudformation.model.TypeSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeTypeSummaryDocument(reader: XmlTagReader): TypeSummary {
    val builder = TypeSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Type com.amazonaws.cloudformation#TypeSummary$Type
            "Type" -> builder.type = curr.tryData()
                .parse { RegistryType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#RegistryType`)" }
            // TypeName com.amazonaws.cloudformation#TypeSummary$TypeName
            "TypeName" -> builder.typeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeName`)" }
            // DefaultVersionId com.amazonaws.cloudformation#TypeSummary$DefaultVersionId
            "DefaultVersionId" -> builder.defaultVersionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeVersionId`)" }
            // TypeArn com.amazonaws.cloudformation#TypeSummary$TypeArn
            "TypeArn" -> builder.typeArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeArn`)" }
            // LastUpdated com.amazonaws.cloudformation#TypeSummary$LastUpdated
            "LastUpdated" -> builder.lastUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // Description com.amazonaws.cloudformation#TypeSummary$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // PublisherId com.amazonaws.cloudformation#TypeSummary$PublisherId
            "PublisherId" -> builder.publisherId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublisherId`)" }
            // OriginalTypeName com.amazonaws.cloudformation#TypeSummary$OriginalTypeName
            "OriginalTypeName" -> builder.originalTypeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeName`)" }
            // PublicVersionNumber com.amazonaws.cloudformation#TypeSummary$PublicVersionNumber
            "PublicVersionNumber" -> builder.publicVersionNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublicVersionNumber`)" }
            // LatestPublicVersion com.amazonaws.cloudformation#TypeSummary$LatestPublicVersion
            "LatestPublicVersion" -> builder.latestPublicVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublicVersionNumber`)" }
            // PublisherIdentity com.amazonaws.cloudformation#TypeSummary$PublisherIdentity
            "PublisherIdentity" -> builder.publisherIdentity = curr.tryData()
                .parse { IdentityProvider.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#IdentityProvider`)" }
            // PublisherName com.amazonaws.cloudformation#TypeSummary$PublisherName
            "PublisherName" -> builder.publisherName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublisherName`)" }
            // IsActivated com.amazonaws.cloudformation#TypeSummary$IsActivated
            "IsActivated" -> builder.isActivated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IsActivated`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
