// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus
import aws.sdk.kotlin.services.cloudformation.model.TemplateSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeTemplateSummaryDocument(reader: XmlTagReader): TemplateSummary {
    val builder = TemplateSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // GeneratedTemplateId com.amazonaws.cloudformation#TemplateSummary$GeneratedTemplateId
            "GeneratedTemplateId" -> builder.generatedTemplateId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#GeneratedTemplateId`)" }
            // GeneratedTemplateName com.amazonaws.cloudformation#TemplateSummary$GeneratedTemplateName
            "GeneratedTemplateName" -> builder.generatedTemplateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#GeneratedTemplateName`)" }
            // Status com.amazonaws.cloudformation#TemplateSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { GeneratedTemplateStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#GeneratedTemplateStatus`)" }
            // StatusReason com.amazonaws.cloudformation#TemplateSummary$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TemplateStatusReason`)" }
            // CreationTime com.amazonaws.cloudformation#TemplateSummary$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // LastUpdatedTime com.amazonaws.cloudformation#TemplateSummary$LastUpdatedTime
            "LastUpdatedTime" -> builder.lastUpdatedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#LastUpdatedTime`)" }
            // NumberOfResources com.amazonaws.cloudformation#TemplateSummary$NumberOfResources
            "NumberOfResources" -> builder.numberOfResources = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#NumberOfResources`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
