// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackSetOperationSummaryDocument(reader: XmlTagReader): StackSetOperationSummary {
    val builder = StackSetOperationSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // OperationId com.amazonaws.cloudformation#StackSetOperationSummary$OperationId
            "OperationId" -> builder.operationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            // Action com.amazonaws.cloudformation#StackSetOperationSummary$Action
            "Action" -> builder.action = curr.tryData()
                .parse { StackSetOperationAction.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetOperationAction`)" }
            // Status com.amazonaws.cloudformation#StackSetOperationSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackSetOperationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetOperationStatus`)" }
            // CreationTimestamp com.amazonaws.cloudformation#StackSetOperationSummary$CreationTimestamp
            "CreationTimestamp" -> builder.creationTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // EndTimestamp com.amazonaws.cloudformation#StackSetOperationSummary$EndTimestamp
            "EndTimestamp" -> builder.endTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // StatusReason com.amazonaws.cloudformation#StackSetOperationSummary$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetOperationStatusReason`)" }
            // StatusDetails com.amazonaws.cloudformation#StackSetOperationSummary$StatusDetails
            "StatusDetails" -> builder.statusDetails = deserializeStackSetOperationStatusDetailsDocument(curr)
            // OperationPreferences com.amazonaws.cloudformation#StackSetOperationSummary$OperationPreferences
            "OperationPreferences" -> builder.operationPreferences = deserializeStackSetOperationPreferencesDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
