// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ResourceStatus
import aws.sdk.kotlin.services.cloudformation.model.StackResourceDetail
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackResourceDetailDocument(reader: XmlTagReader): StackResourceDetail {
    val builder = StackResourceDetail.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackName com.amazonaws.cloudformation#StackResourceDetail$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // StackId com.amazonaws.cloudformation#StackResourceDetail$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // LogicalResourceId com.amazonaws.cloudformation#StackResourceDetail$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#StackResourceDetail$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // ResourceType com.amazonaws.cloudformation#StackResourceDetail$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // LastUpdatedTimestamp com.amazonaws.cloudformation#StackResourceDetail$LastUpdatedTimestamp
            "LastUpdatedTimestamp" -> builder.lastUpdatedTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ResourceStatus com.amazonaws.cloudformation#StackResourceDetail$ResourceStatus
            "ResourceStatus" -> builder.resourceStatus = curr.tryData()
                .parse { ResourceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceStatus`)" }
            // ResourceStatusReason com.amazonaws.cloudformation#StackResourceDetail$ResourceStatusReason
            "ResourceStatusReason" -> builder.resourceStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceStatusReason`)" }
            // Description com.amazonaws.cloudformation#StackResourceDetail$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Metadata com.amazonaws.cloudformation#StackResourceDetail$Metadata
            "Metadata" -> builder.metadata = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Metadata`)" }
            // DriftInformation com.amazonaws.cloudformation#StackResourceDetail$DriftInformation
            "DriftInformation" -> builder.driftInformation = deserializeStackResourceDriftInformationDocument(curr)
            // ModuleInfo com.amazonaws.cloudformation#StackResourceDetail$ModuleInfo
            "ModuleInfo" -> builder.moduleInfo = deserializeModuleInfoDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
