// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.DetailedStatus
import aws.sdk.kotlin.services.cloudformation.model.HookFailureMode
import aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint
import aws.sdk.kotlin.services.cloudformation.model.HookStatus
import aws.sdk.kotlin.services.cloudformation.model.ResourceStatus
import aws.sdk.kotlin.services.cloudformation.model.StackEvent
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackEventDocument(reader: XmlTagReader): StackEvent {
    val builder = StackEvent.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackId com.amazonaws.cloudformation#StackEvent$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // EventId com.amazonaws.cloudformation#StackEvent$EventId
            "EventId" -> builder.eventId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#EventId`)" }
            // StackName com.amazonaws.cloudformation#StackEvent$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // LogicalResourceId com.amazonaws.cloudformation#StackEvent$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#StackEvent$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // ResourceType com.amazonaws.cloudformation#StackEvent$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // Timestamp com.amazonaws.cloudformation#StackEvent$Timestamp
            "Timestamp" -> builder.timestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ResourceStatus com.amazonaws.cloudformation#StackEvent$ResourceStatus
            "ResourceStatus" -> builder.resourceStatus = curr.tryData()
                .parse { ResourceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceStatus`)" }
            // ResourceStatusReason com.amazonaws.cloudformation#StackEvent$ResourceStatusReason
            "ResourceStatusReason" -> builder.resourceStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceStatusReason`)" }
            // ResourceProperties com.amazonaws.cloudformation#StackEvent$ResourceProperties
            "ResourceProperties" -> builder.resourceProperties = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceProperties`)" }
            // ClientRequestToken com.amazonaws.cloudformation#StackEvent$ClientRequestToken
            "ClientRequestToken" -> builder.clientRequestToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            // HookType com.amazonaws.cloudformation#StackEvent$HookType
            "HookType" -> builder.hookType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookType`)" }
            // HookStatus com.amazonaws.cloudformation#StackEvent$HookStatus
            "HookStatus" -> builder.hookStatus = curr.tryData()
                .parse { HookStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookStatus`)" }
            // HookStatusReason com.amazonaws.cloudformation#StackEvent$HookStatusReason
            "HookStatusReason" -> builder.hookStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookStatusReason`)" }
            // HookInvocationPoint com.amazonaws.cloudformation#StackEvent$HookInvocationPoint
            "HookInvocationPoint" -> builder.hookInvocationPoint = curr.tryData()
                .parse { HookInvocationPoint.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookInvocationPoint`)" }
            // HookInvocationId com.amazonaws.cloudformation#StackEvent$HookInvocationId
            "HookInvocationId" -> builder.hookInvocationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookInvocationId`)" }
            // HookFailureMode com.amazonaws.cloudformation#StackEvent$HookFailureMode
            "HookFailureMode" -> builder.hookFailureMode = curr.tryData()
                .parse { HookFailureMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookFailureMode`)" }
            // DetailedStatus com.amazonaws.cloudformation#StackEvent$DetailedStatus
            "DetailedStatus" -> builder.detailedStatus = curr.tryData()
                .parse { DetailedStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#DetailedStatus`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
