// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ResourceSignalStatus
import aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SignalResourceOperationSerializer: HttpSerializer.NonStreaming<SignalResourceRequest> {
    override fun serialize(context: ExecutionContext, input: SignalResourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeSignalResourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeSignalResourceOperationBody(context: ExecutionContext, input: SignalResourceRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val LOGICALRESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LogicalResourceId"))
    val STACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("Status"))
    val UNIQUEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("UniqueId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("SignalResourceInput"))
        trait(QueryLiteral("Action", "SignalResource"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(LOGICALRESOURCEID_DESCRIPTOR)
        field(STACKNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UNIQUEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.logicalResourceId?.let { field(LOGICALRESOURCEID_DESCRIPTOR, it) }
        input.stackName?.let { field(STACKNAME_DESCRIPTOR, it) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        input.uniqueId?.let { field(UNIQUEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
