// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus
import aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary
import aws.sdk.kotlin.services.cloudformation.model.ScanType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeResourceScanSummaryDocument(reader: XmlTagReader): ResourceScanSummary {
    val builder = ResourceScanSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ResourceScanId com.amazonaws.cloudformation#ResourceScanSummary$ResourceScanId
            "ResourceScanId" -> builder.resourceScanId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceScanId`)" }
            // Status com.amazonaws.cloudformation#ResourceScanSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ResourceScanStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceScanStatus`)" }
            // StatusReason com.amazonaws.cloudformation#ResourceScanSummary$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceScanStatusReason`)" }
            // StartTime com.amazonaws.cloudformation#ResourceScanSummary$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // EndTime com.amazonaws.cloudformation#ResourceScanSummary$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // PercentageCompleted com.amazonaws.cloudformation#ResourceScanSummary$PercentageCompleted
            "PercentageCompleted" -> builder.percentageCompleted = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.cloudformation#PercentageCompleted`)" }
            // ScanType com.amazonaws.cloudformation#ResourceScanSummary$ScanType
            "ScanType" -> builder.scanType = curr.tryData()
                .parse { ScanType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ScanType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
