// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.HookResultSummary
import aws.sdk.kotlin.services.cloudformation.model.ListHookResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListHookResultsOperationDeserializer: HttpDeserializer.NonStreaming<ListHookResultsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListHookResultsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListHookResultsError(context, call, payload)
        }
        val builder = ListHookResultsResponse.Builder()

        if (payload != null) {
            deserializeListHookResultsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListHookResultsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "HookResultNotFound" -> HookResultNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListHookResultsOperationBody(builder: ListHookResultsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListHookResults")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // HookResults com.amazonaws.cloudformation#ListHookResultsOutput$HookResults
            "HookResults" -> builder.hookResults = deserializeHookResultSummariesShape(curr)
            // NextToken com.amazonaws.cloudformation#ListHookResultsOutput$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#NextToken`)" }
            // TargetId com.amazonaws.cloudformation#ListHookResultsOutput$TargetId
            "TargetId" -> builder.targetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookResultId`)" }
            // TargetType com.amazonaws.cloudformation#ListHookResultsOutput$TargetType
            "TargetType" -> builder.targetType = curr.tryData()
                .parse { ListHookResultsTargetType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ListHookResultsTargetType`)" }
            else -> {}
        }
        curr.drop()
    }
}
