// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.HookFailureMode
import aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint
import aws.sdk.kotlin.services.cloudformation.model.HookResultSummary
import aws.sdk.kotlin.services.cloudformation.model.HookStatus
import aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeHookResultSummaryDocument(reader: XmlTagReader): HookResultSummary {
    val builder = HookResultSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // HookResultId com.amazonaws.cloudformation#HookResultSummary$HookResultId
            "HookResultId" -> builder.hookResultId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookInvocationId`)" }
            // InvocationPoint com.amazonaws.cloudformation#HookResultSummary$InvocationPoint
            "InvocationPoint" -> builder.invocationPoint = curr.tryData()
                .parse { HookInvocationPoint.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookInvocationPoint`)" }
            // FailureMode com.amazonaws.cloudformation#HookResultSummary$FailureMode
            "FailureMode" -> builder.failureMode = curr.tryData()
                .parse { HookFailureMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookFailureMode`)" }
            // TypeName com.amazonaws.cloudformation#HookResultSummary$TypeName
            "TypeName" -> builder.typeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookTypeName`)" }
            // TypeVersionId com.amazonaws.cloudformation#HookResultSummary$TypeVersionId
            "TypeVersionId" -> builder.typeVersionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookTypeVersionId`)" }
            // TypeConfigurationVersionId com.amazonaws.cloudformation#HookResultSummary$TypeConfigurationVersionId
            "TypeConfigurationVersionId" -> builder.typeConfigurationVersionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookTypeConfigurationVersionId`)" }
            // Status com.amazonaws.cloudformation#HookResultSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { HookStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#HookStatus`)" }
            // HookStatusReason com.amazonaws.cloudformation#HookResultSummary$HookStatusReason
            "HookStatusReason" -> builder.hookStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookStatusReason`)" }
            // InvokedAt com.amazonaws.cloudformation#HookResultSummary$InvokedAt
            "InvokedAt" -> builder.invokedAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // TargetType com.amazonaws.cloudformation#HookResultSummary$TargetType
            "TargetType" -> builder.targetType = curr.tryData()
                .parse { ListHookResultsTargetType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ListHookResultsTargetType`)" }
            // TargetId com.amazonaws.cloudformation#HookResultSummary$TargetId
            "TargetId" -> builder.targetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookResultId`)" }
            // TypeArn com.amazonaws.cloudformation#HookResultSummary$TypeArn
            "TypeArn" -> builder.typeArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookTypeArn`)" }
            // HookExecutionTarget com.amazonaws.cloudformation#HookResultSummary$HookExecutionTarget
            "HookExecutionTarget" -> builder.hookExecutionTarget = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#HookResultId`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
