// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse
import aws.sdk.kotlin.services.cloudformation.model.ParameterDeclaration
import aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary
import aws.sdk.kotlin.services.cloudformation.model.Warnings
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetTemplateSummaryOperationDeserializer: HttpDeserializer.NonStreaming<GetTemplateSummaryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTemplateSummaryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTemplateSummaryError(context, call, payload)
        }
        val builder = GetTemplateSummaryResponse.Builder()

        if (payload != null) {
            deserializeGetTemplateSummaryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTemplateSummaryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "StackSetNotFoundException" -> StackSetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTemplateSummaryOperationBody(builder: GetTemplateSummaryResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetTemplateSummary")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Capabilities com.amazonaws.cloudformation#GetTemplateSummaryOutput$Capabilities
            "Capabilities" -> builder.capabilities = deserializeCapabilitiesShape(curr)
            // CapabilitiesReason com.amazonaws.cloudformation#GetTemplateSummaryOutput$CapabilitiesReason
            "CapabilitiesReason" -> builder.capabilitiesReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#CapabilitiesReason`)" }
            // DeclaredTransforms com.amazonaws.cloudformation#GetTemplateSummaryOutput$DeclaredTransforms
            "DeclaredTransforms" -> builder.declaredTransforms = deserializeTransformsListShape(curr)
            // Description com.amazonaws.cloudformation#GetTemplateSummaryOutput$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Metadata com.amazonaws.cloudformation#GetTemplateSummaryOutput$Metadata
            "Metadata" -> builder.metadata = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Metadata`)" }
            // Parameters com.amazonaws.cloudformation#GetTemplateSummaryOutput$Parameters
            "Parameters" -> builder.parameters = deserializeParameterDeclarationsShape(curr)
            // ResourceIdentifierSummaries com.amazonaws.cloudformation#GetTemplateSummaryOutput$ResourceIdentifierSummaries
            "ResourceIdentifierSummaries" -> builder.resourceIdentifierSummaries = deserializeResourceIdentifierSummariesShape(curr)
            // ResourceTypes com.amazonaws.cloudformation#GetTemplateSummaryOutput$ResourceTypes
            "ResourceTypes" -> builder.resourceTypes = deserializeResourceTypesShape(curr)
            // Version com.amazonaws.cloudformation#GetTemplateSummaryOutput$Version
            "Version" -> builder.version = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Version`)" }
            // Warnings com.amazonaws.cloudformation#GetTemplateSummaryOutput$Warnings
            "Warnings" -> builder.warnings = deserializeWarningsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
