// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.TemplateStage
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class GetTemplateOperationDeserializer: HttpDeserializer.NonStreaming<GetTemplateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTemplateError(context, call, payload)
        }
        val builder = GetTemplateResponse.Builder()

        if (payload != null) {
            deserializeGetTemplateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTemplateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChangeSetNotFound" -> ChangeSetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTemplateOperationBody(builder: GetTemplateResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetTemplate")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // StagesAvailable com.amazonaws.cloudformation#GetTemplateOutput$StagesAvailable
            "StagesAvailable" -> builder.stagesAvailable = deserializeStageListShape(curr)
            // TemplateBody com.amazonaws.cloudformation#GetTemplateOutput$TemplateBody
            "TemplateBody" -> builder.templateBody = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TemplateBody`)" }
            else -> {}
        }
        curr.drop()
    }
}
