// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DetectStackSetDriftOperationDeserializer: HttpDeserializer.NonStreaming<DetectStackSetDriftResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectStackSetDriftResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectStackSetDriftError(context, call, payload)
        }
        val builder = DetectStackSetDriftResponse.Builder()

        if (payload != null) {
            deserializeDetectStackSetDriftOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectStackSetDriftError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationInProgressException" -> OperationInProgressExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "StackSetNotFoundException" -> StackSetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectStackSetDriftOperationBody(builder: DetectStackSetDriftResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DetectStackSetDrift")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // OperationId com.amazonaws.cloudformation#DetectStackSetDriftOutput$OperationId
            "OperationId" -> builder.operationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            else -> {}
        }
        curr.drop()
    }
}
