// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.IdentityProvider
import aws.sdk.kotlin.services.cloudformation.model.PublisherStatus
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribePublisherOperationDeserializer: HttpDeserializer.NonStreaming<DescribePublisherResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePublisherResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePublisherError(context, call, payload)
        }
        val builder = DescribePublisherResponse.Builder()

        if (payload != null) {
            deserializeDescribePublisherOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePublisherError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePublisherOperationBody(builder: DescribePublisherResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribePublisher")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // IdentityProvider com.amazonaws.cloudformation#DescribePublisherOutput$IdentityProvider
            "IdentityProvider" -> builder.identityProvider = curr.tryData()
                .parse { IdentityProvider.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#IdentityProvider`)" }
            // PublisherId com.amazonaws.cloudformation#DescribePublisherOutput$PublisherId
            "PublisherId" -> builder.publisherId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublisherId`)" }
            // PublisherProfile com.amazonaws.cloudformation#DescribePublisherOutput$PublisherProfile
            "PublisherProfile" -> builder.publisherProfile = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublisherProfile`)" }
            // PublisherStatus com.amazonaws.cloudformation#DescribePublisherOutput$PublisherStatus
            "PublisherStatus" -> builder.publisherStatus = curr.tryData()
                .parse { PublisherStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#PublisherStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
