// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus
import aws.sdk.kotlin.services.cloudformation.model.ResourceDetail
import aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration
import aws.sdk.kotlin.services.cloudformation.model.TemplateProgress
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeGeneratedTemplateOperationDeserializer: HttpDeserializer.NonStreaming<DescribeGeneratedTemplateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeGeneratedTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGeneratedTemplateError(context, call, payload)
        }
        val builder = DescribeGeneratedTemplateResponse.Builder()

        if (payload != null) {
            deserializeDescribeGeneratedTemplateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeGeneratedTemplateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GeneratedTemplateNotFound" -> GeneratedTemplateNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGeneratedTemplateOperationBody(builder: DescribeGeneratedTemplateResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeGeneratedTemplate")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CreationTime com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // GeneratedTemplateId com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$GeneratedTemplateId
            "GeneratedTemplateId" -> builder.generatedTemplateId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#GeneratedTemplateId`)" }
            // GeneratedTemplateName com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$GeneratedTemplateName
            "GeneratedTemplateName" -> builder.generatedTemplateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#GeneratedTemplateName`)" }
            // LastUpdatedTime com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$LastUpdatedTime
            "LastUpdatedTime" -> builder.lastUpdatedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#LastUpdatedTime`)" }
            // Progress com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$Progress
            "Progress" -> builder.progress = deserializeTemplateProgressDocument(curr)
            // Resources com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$Resources
            "Resources" -> builder.resources = deserializeResourceDetailsShape(curr)
            // StackId com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // Status com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$Status
            "Status" -> builder.status = curr.tryData()
                .parse { GeneratedTemplateStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#GeneratedTemplateStatus`)" }
            // StatusReason com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TemplateStatusReason`)" }
            // TemplateConfiguration com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$TemplateConfiguration
            "TemplateConfiguration" -> builder.templateConfiguration = deserializeTemplateConfigurationDocument(curr)
            // TotalWarnings com.amazonaws.cloudformation#DescribeGeneratedTemplateOutput$TotalWarnings
            "TotalWarnings" -> builder.totalWarnings = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#TotalWarnings`)" }
            else -> {}
        }
        curr.drop()
    }
}
