// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.AccountFilterType
import aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDeploymentTargetsDocument(reader: XmlTagReader): DeploymentTargets {
    val builder = DeploymentTargets.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Accounts com.amazonaws.cloudformation#DeploymentTargets$Accounts
            "Accounts" -> builder.accounts = deserializeAccountListShape(curr)
            // AccountsUrl com.amazonaws.cloudformation#DeploymentTargets$AccountsUrl
            "AccountsUrl" -> builder.accountsUrl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#AccountsUrl`)" }
            // OrganizationalUnitIds com.amazonaws.cloudformation#DeploymentTargets$OrganizationalUnitIds
            "OrganizationalUnitIds" -> builder.organizationalUnitIds = deserializeOrganizationalUnitIdListShape(curr)
            // AccountFilterType com.amazonaws.cloudformation#DeploymentTargets$AccountFilterType
            "AccountFilterType" -> builder.accountFilterType = curr.tryData()
                .parse { AccountFilterType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#AccountFilterType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
