// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateStackSetRequest private constructor(builder: Builder) {
    /**
     * &#91;Self-managed permissions&#93; The accounts in which to update associated stack instances. If you specify accounts, you must also specify the Amazon Web Services Regions in which to update StackSet instances.
     *
     * To update *all* the stack instances associated with this StackSet, don't specify the `Accounts` or `Regions` properties.
     *
     * If the StackSet update includes changes to the template (that is, if the `TemplateBody` or `TemplateURL` properties are specified), or the `Parameters` property, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Amazon Web Services Regions. If the StackSet update does not include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Amazon Web Services Regions, while leaving all other stack instances with their existing stack instance status.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * &#91;Self-managed permissions&#93; The Amazon Resource Name (ARN) of the IAM role to use to update this StackSet.
     *
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific StackSets within the same administrator account. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html) in the *CloudFormation User Guide*.
     *
     * If you specified a customized administrator role when you created the StackSet, you must specify a customized administrator role, even if it is the same customized administrator role used with this StackSet previously.
     */
    public val administrationRoleArn: kotlin.String? = builder.administrationRoleArn
    /**
     * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU). For more information, see [Enable or disable automatic deployments for StackSets in Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-manage-auto-deployment.html) in the *CloudFormation User Guide*.
     *
     * If you specify `AutoDeployment`, don't specify `DeploymentTargets` or `Regions`.
     */
    public val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for CloudFormation to update the StackSet and its associated stack instances.
     * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account, for example, by creating new IAM users. For those stacks sets, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
     *    + If you have IAM resources, you can specify either capability.
     *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
     *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
     * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
     *    + [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-accesskey.html)
     *    + [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-group.html)
     *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-instanceprofile.html)
     *    + [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-policy.html)
     *    + [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-role.html)
     *    + [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-user.html)
     *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-usertogroupaddition.html)
     * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
     * + `CAPABILITY_AUTO_EXPAND`Some templates reference macros. If your StackSet template references one or more macros, you must update the StackSet directly from the processed template, without first reviewing the resulting changes in a change set. To update the StackSet directly, you must acknowledge this capability. For more information, see [Perform custom processing on CloudFormation templates with template macros](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).StackSets with service-managed permissions do not currently support the use of macros in templates. (This includes the [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-include.html) and [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.) Even if you specify this capability for a StackSet with service-managed permissions, if you reference a macro in your template the StackSet operation will fail.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * &#91;Service-managed permissions&#93; The Organizations accounts in which to update associated stack instances.
     *
     * To update all the stack instances associated with this StackSet, do not specify `DeploymentTargets` or `Regions`.
     *
     * If the StackSet update includes changes to the template (that is, if `TemplateBody` or `TemplateURL` is specified), or the `Parameters`, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Amazon Web Services Regions. If the StackSet update doesn't include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status.
     */
    public val deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = builder.deploymentTargets
    /**
     * A brief description of updates that you are making.
     */
    public val description: kotlin.String? = builder.description
    /**
     * &#91;Self-managed permissions&#93; The name of the IAM execution role to use to update the stack set. If you do not specify an execution role, CloudFormation uses the `AWSCloudFormationStackSetExecutionRole` role for the StackSet operation.
     *
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their StackSets.
     *
     * If you specify a customized execution role, CloudFormation uses that role to update the stack. If you do not specify a customized execution role, CloudFormation performs the update using the role previously associated with the StackSet, so long as you have permissions to perform operations on the StackSet.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * Describes whether CloudFormation performs non-conflicting operations concurrently and queues conflicting operations.
     */
    public val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * The unique ID for this StackSet operation.
     *
     * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the StackSet operation only once, even if you retry the request multiple times. You might retry StackSet operation requests to ensure that CloudFormation successfully received them.
     *
     * If you don't specify an operation ID, CloudFormation generates one automatically.
     *
     * Repeating this StackSet operation with a new operation ID retries all stack instances whose status is `OUTDATED`.
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * Preferences for how CloudFormation performs this StackSet operation.
     */
    public val operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = builder.operationPreferences
    /**
     * A list of input parameters for the StackSet template.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * Describes how the IAM roles required for StackSet operations are created. You cannot modify `PermissionModel` if there are stack instances associated with your stack set.
     * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
     * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
     */
    public val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions, you must also specify accounts in which to update StackSet instances.
     *
     * To update *all* the stack instances associated with this StackSet, do not specify the `Accounts` or `Regions` properties.
     *
     * If the StackSet update includes changes to the template (that is, if the `TemplateBody` or `TemplateURL` properties are specified), or the `Parameters` property, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Regions. If the StackSet update does not include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status.
     */
    public val regions: List<String>? = builder.regions
    /**
     * The name or unique ID of the StackSet that you want to update.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The key-value pairs to associate with this StackSet and the stacks created from it. CloudFormation also propagates these tags to supported resources that are created in the stacks. You can specify a maximum number of 50 tags.
     *
     * If you specify tags for this parameter, those tags replace any list of tags that are currently associated with this StackSet. This means:
     * + If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
     * + If you specify *any* tags using this parameter, you must specify *all* the tags that you want associated with this StackSet, even tags you've specified before (for example, when creating the StackSet or during a previous update of the StackSet.). Any tags that you don't include in the updated list of tags are removed from the StackSet, and therefore from the stacks and resources as well.
     * + If you specify an empty value, CloudFormation removes all currently associated tags.
     *
     * If you specify new tags as part of an `UpdateStackSet` action, CloudFormation checks to see if you have the required IAM permission to tag resources. If you omit tags that are currently associated with the StackSet from the list of tags you specify, CloudFormation assumes that you want to remove those tags from the StackSet, and checks to see if you have permission to untag resources. If you don't have the necessary permission(s), the entire `UpdateStackSet` action fails with an `access denied` error, and the StackSet is not updated.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     *
     * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * The URL of a file that contains the template body. The URL must point to a template (maximum size: 1 MB) that is located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`. S3 static website URLs are not supported.
     *
     * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl
    /**
     * Use the existing template that's associated with the StackSet that you're updating.
     *
     * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
     */
    public val usePreviousTemplate: kotlin.Boolean? = builder.usePreviousTemplate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStackSetRequest(")
        append("accounts=$accounts,")
        append("administrationRoleArn=$administrationRoleArn,")
        append("autoDeployment=$autoDeployment,")
        append("callAs=$callAs,")
        append("capabilities=$capabilities,")
        append("deploymentTargets=$deploymentTargets,")
        append("description=$description,")
        append("executionRoleName=$executionRoleName,")
        append("managedExecution=$managedExecution,")
        append("operationId=$operationId,")
        append("operationPreferences=$operationPreferences,")
        append("parameters=$parameters,")
        append("permissionModel=$permissionModel,")
        append("regions=$regions,")
        append("stackSetName=$stackSetName,")
        append("tags=$tags,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl,")
        append("usePreviousTemplate=$usePreviousTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (administrationRoleArn?.hashCode() ?: 0)
        result = 31 * result + (autoDeployment?.hashCode() ?: 0)
        result = 31 * result + (callAs?.hashCode() ?: 0)
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (deploymentTargets?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (operationPreferences?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        result = 31 * result + (usePreviousTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStackSetRequest

        if (accounts != other.accounts) return false
        if (administrationRoleArn != other.administrationRoleArn) return false
        if (autoDeployment != other.autoDeployment) return false
        if (callAs != other.callAs) return false
        if (capabilities != other.capabilities) return false
        if (deploymentTargets != other.deploymentTargets) return false
        if (description != other.description) return false
        if (executionRoleName != other.executionRoleName) return false
        if (managedExecution != other.managedExecution) return false
        if (operationId != other.operationId) return false
        if (operationPreferences != other.operationPreferences) return false
        if (parameters != other.parameters) return false
        if (permissionModel != other.permissionModel) return false
        if (regions != other.regions) return false
        if (stackSetName != other.stackSetName) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false
        if (usePreviousTemplate != other.usePreviousTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Self-managed permissions&#93; The accounts in which to update associated stack instances. If you specify accounts, you must also specify the Amazon Web Services Regions in which to update StackSet instances.
         *
         * To update *all* the stack instances associated with this StackSet, don't specify the `Accounts` or `Regions` properties.
         *
         * If the StackSet update includes changes to the template (that is, if the `TemplateBody` or `TemplateURL` properties are specified), or the `Parameters` property, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Amazon Web Services Regions. If the StackSet update does not include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Amazon Web Services Regions, while leaving all other stack instances with their existing stack instance status.
         */
        public var accounts: List<String>? = null
        /**
         * &#91;Self-managed permissions&#93; The Amazon Resource Name (ARN) of the IAM role to use to update this StackSet.
         *
         * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific StackSets within the same administrator account. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html) in the *CloudFormation User Guide*.
         *
         * If you specified a customized administrator role when you created the StackSet, you must specify a customized administrator role, even if it is the same customized administrator role used with this StackSet previously.
         */
        public var administrationRoleArn: kotlin.String? = null
        /**
         * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU). For more information, see [Enable or disable automatic deployments for StackSets in Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-manage-auto-deployment.html) in the *CloudFormation User Guide*.
         *
         * If you specify `AutoDeployment`, don't specify `DeploymentTargets` or `Regions`.
         */
        public var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for CloudFormation to update the StackSet and its associated stack instances.
         * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account, for example, by creating new IAM users. For those stacks sets, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
         *    + If you have IAM resources, you can specify either capability.
         *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
         *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
         * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
         *    + [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-accesskey.html)
         *    + [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-group.html)
         *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-instanceprofile.html)
         *    + [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-policy.html)
         *    + [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-role.html)
         *    + [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-user.html)
         *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-usertogroupaddition.html)
         * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
         * + `CAPABILITY_AUTO_EXPAND`Some templates reference macros. If your StackSet template references one or more macros, you must update the StackSet directly from the processed template, without first reviewing the resulting changes in a change set. To update the StackSet directly, you must acknowledge this capability. For more information, see [Perform custom processing on CloudFormation templates with template macros](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).StackSets with service-managed permissions do not currently support the use of macros in templates. (This includes the [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-include.html) and [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.) Even if you specify this capability for a StackSet with service-managed permissions, if you reference a macro in your template the StackSet operation will fail.
         */
        public var capabilities: List<Capability>? = null
        /**
         * &#91;Service-managed permissions&#93; The Organizations accounts in which to update associated stack instances.
         *
         * To update all the stack instances associated with this StackSet, do not specify `DeploymentTargets` or `Regions`.
         *
         * If the StackSet update includes changes to the template (that is, if `TemplateBody` or `TemplateURL` is specified), or the `Parameters`, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Amazon Web Services Regions. If the StackSet update doesn't include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status.
         */
        public var deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = null
        /**
         * A brief description of updates that you are making.
         */
        public var description: kotlin.String? = null
        /**
         * &#91;Self-managed permissions&#93; The name of the IAM execution role to use to update the stack set. If you do not specify an execution role, CloudFormation uses the `AWSCloudFormationStackSetExecutionRole` role for the StackSet operation.
         *
         * Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their StackSets.
         *
         * If you specify a customized execution role, CloudFormation uses that role to update the stack. If you do not specify a customized execution role, CloudFormation performs the update using the role previously associated with the StackSet, so long as you have permissions to perform operations on the StackSet.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * Describes whether CloudFormation performs non-conflicting operations concurrently and queues conflicting operations.
         */
        public var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * The unique ID for this StackSet operation.
         *
         * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the StackSet operation only once, even if you retry the request multiple times. You might retry StackSet operation requests to ensure that CloudFormation successfully received them.
         *
         * If you don't specify an operation ID, CloudFormation generates one automatically.
         *
         * Repeating this StackSet operation with a new operation ID retries all stack instances whose status is `OUTDATED`.
         */
        public var operationId: kotlin.String? = null
        /**
         * Preferences for how CloudFormation performs this StackSet operation.
         */
        public var operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = null
        /**
         * A list of input parameters for the StackSet template.
         */
        public var parameters: List<Parameter>? = null
        /**
         * Describes how the IAM roles required for StackSet operations are created. You cannot modify `PermissionModel` if there are stack instances associated with your stack set.
         * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
         * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
         */
        public var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions, you must also specify accounts in which to update StackSet instances.
         *
         * To update *all* the stack instances associated with this StackSet, do not specify the `Accounts` or `Regions` properties.
         *
         * If the StackSet update includes changes to the template (that is, if the `TemplateBody` or `TemplateURL` properties are specified), or the `Parameters` property, CloudFormation marks all stack instances with a status of `OUTDATED` prior to updating the stack instances in the specified accounts and Regions. If the StackSet update does not include changes to the template or parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status.
         */
        public var regions: List<String>? = null
        /**
         * The name or unique ID of the StackSet that you want to update.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The key-value pairs to associate with this StackSet and the stacks created from it. CloudFormation also propagates these tags to supported resources that are created in the stacks. You can specify a maximum number of 50 tags.
         *
         * If you specify tags for this parameter, those tags replace any list of tags that are currently associated with this StackSet. This means:
         * + If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         * + If you specify *any* tags using this parameter, you must specify *all* the tags that you want associated with this StackSet, even tags you've specified before (for example, when creating the StackSet or during a previous update of the StackSet.). Any tags that you don't include in the updated list of tags are removed from the StackSet, and therefore from the stacks and resources as well.
         * + If you specify an empty value, CloudFormation removes all currently associated tags.
         *
         * If you specify new tags as part of an `UpdateStackSet` action, CloudFormation checks to see if you have the required IAM permission to tag resources. If you omit tags that are currently associated with the StackSet from the list of tags you specify, CloudFormation assumes that you want to remove those tags from the StackSet, and checks to see if you have permission to untag resources. If you don't have the necessary permission(s), the entire `UpdateStackSet` action fails with an `access denied` error, and the StackSet is not updated.
         */
        public var tags: List<Tag>? = null
        /**
         * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         *
         * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
         */
        public var templateBody: kotlin.String? = null
        /**
         * The URL of a file that contains the template body. The URL must point to a template (maximum size: 1 MB) that is located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`. S3 static website URLs are not supported.
         *
         * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
         */
        public var templateUrl: kotlin.String? = null
        /**
         * Use the existing template that's associated with the StackSet that you're updating.
         *
         * Conditional: You must specify only one of the following parameters: `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
         */
        public var usePreviousTemplate: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest) : this() {
            this.accounts = x.accounts
            this.administrationRoleArn = x.administrationRoleArn
            this.autoDeployment = x.autoDeployment
            this.callAs = x.callAs
            this.capabilities = x.capabilities
            this.deploymentTargets = x.deploymentTargets
            this.description = x.description
            this.executionRoleName = x.executionRoleName
            this.managedExecution = x.managedExecution
            this.operationId = x.operationId
            this.operationPreferences = x.operationPreferences
            this.parameters = x.parameters
            this.permissionModel = x.permissionModel
            this.regions = x.regions
            this.stackSetName = x.stackSetName
            this.tags = x.tags
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
            this.usePreviousTemplate = x.usePreviousTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest = UpdateStackSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        public fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets] inside the given [block]
         */
        public fun deploymentTargets(block: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.Builder.() -> kotlin.Unit) {
            this.deploymentTargets = aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        public fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences] inside the given [block]
         */
        public fun operationPreferences(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.Builder.() -> kotlin.Unit) {
            this.operationPreferences = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
