// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateStackInstancesRequest private constructor(builder: Builder) {
    /**
     * &#91;Self-managed permissions&#93; The account IDs of one or more Amazon Web Services accounts in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions.
     *
     * You can specify `Accounts` or `DeploymentTargets`, but not both.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * &#91;Service-managed permissions&#93; The Organizations accounts in which you want to update parameter values for stack instances. If your update targets OUs, the overridden parameter values only apply to the accounts that are currently in the target OUs and their child OUs. Accounts added to the target OUs and their child OUs in the future won't use the overridden values.
     *
     * You can specify `Accounts` or `DeploymentTargets`, but not both.
     */
    public val deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = builder.deploymentTargets
    /**
     * The unique identifier for this StackSet operation.
     *
     * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the StackSet operation only once, even if you retry the request multiple times. You might retry StackSet operation requests to ensure that CloudFormation successfully received them.
     *
     * If you don't specify an operation ID, the SDK generates one automatically.
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * Preferences for how CloudFormation performs this StackSet operation.
     */
    public val operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = builder.operationPreferences
    /**
     * A list of input parameters whose values you want to update for the specified stack instances.
     *
     * Any overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions. When specifying parameters and their values, be aware of how CloudFormation sets parameter values during stack instance update operations:
     * + To override the current value for a parameter, include the parameter and specify its value.
     * + To leave an overridden parameter set to its present value, include the parameter and specify `UsePreviousValue` as `true`. (You can't specify both a value and set `UsePreviousValue` to `true`.)
     * + To set an overridden parameter back to the value specified in the StackSet, specify a parameter list but don't include the parameter in the list.
     * + To leave all parameters set to their present values, don't specify this property at all.
     *
     * During StackSet updates, any parameter values overridden for a stack instance aren't updated, but retain their overridden value.
     *
     * You can only override the parameter *values* that are specified in the StackSet. To add or delete a parameter itself, use `UpdateStackSet` to update the StackSet template. If you add a parameter to a template, before you can override the parameter value specified in the StackSet you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
     */
    public val parameterOverrides: List<Parameter>? = builder.parameterOverrides
    /**
     * The names of one or more Amazon Web Services Regions in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions.
     */
    public val regions: List<String>? = builder.regions
    /**
     * The name or unique ID of the StackSet associated with the stack instances.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStackInstancesRequest(")
        append("accounts=$accounts,")
        append("callAs=$callAs,")
        append("deploymentTargets=$deploymentTargets,")
        append("operationId=$operationId,")
        append("operationPreferences=$operationPreferences,")
        append("parameterOverrides=$parameterOverrides,")
        append("regions=$regions,")
        append("stackSetName=$stackSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (callAs?.hashCode() ?: 0)
        result = 31 * result + (deploymentTargets?.hashCode() ?: 0)
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (operationPreferences?.hashCode() ?: 0)
        result = 31 * result + (parameterOverrides?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStackInstancesRequest

        if (accounts != other.accounts) return false
        if (callAs != other.callAs) return false
        if (deploymentTargets != other.deploymentTargets) return false
        if (operationId != other.operationId) return false
        if (operationPreferences != other.operationPreferences) return false
        if (parameterOverrides != other.parameterOverrides) return false
        if (regions != other.regions) return false
        if (stackSetName != other.stackSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Self-managed permissions&#93; The account IDs of one or more Amazon Web Services accounts in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions.
         *
         * You can specify `Accounts` or `DeploymentTargets`, but not both.
         */
        public var accounts: List<String>? = null
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * &#91;Service-managed permissions&#93; The Organizations accounts in which you want to update parameter values for stack instances. If your update targets OUs, the overridden parameter values only apply to the accounts that are currently in the target OUs and their child OUs. Accounts added to the target OUs and their child OUs in the future won't use the overridden values.
         *
         * You can specify `Accounts` or `DeploymentTargets`, but not both.
         */
        public var deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = null
        /**
         * The unique identifier for this StackSet operation.
         *
         * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the StackSet operation only once, even if you retry the request multiple times. You might retry StackSet operation requests to ensure that CloudFormation successfully received them.
         *
         * If you don't specify an operation ID, the SDK generates one automatically.
         */
        public var operationId: kotlin.String? = null
        /**
         * Preferences for how CloudFormation performs this StackSet operation.
         */
        public var operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = null
        /**
         * A list of input parameters whose values you want to update for the specified stack instances.
         *
         * Any overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions. When specifying parameters and their values, be aware of how CloudFormation sets parameter values during stack instance update operations:
         * + To override the current value for a parameter, include the parameter and specify its value.
         * + To leave an overridden parameter set to its present value, include the parameter and specify `UsePreviousValue` as `true`. (You can't specify both a value and set `UsePreviousValue` to `true`.)
         * + To set an overridden parameter back to the value specified in the StackSet, specify a parameter list but don't include the parameter in the list.
         * + To leave all parameters set to their present values, don't specify this property at all.
         *
         * During StackSet updates, any parameter values overridden for a stack instance aren't updated, but retain their overridden value.
         *
         * You can only override the parameter *values* that are specified in the StackSet. To add or delete a parameter itself, use `UpdateStackSet` to update the StackSet template. If you add a parameter to a template, before you can override the parameter value specified in the StackSet you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
         */
        public var parameterOverrides: List<Parameter>? = null
        /**
         * The names of one or more Amazon Web Services Regions in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Amazon Web Services Regions.
         */
        public var regions: List<String>? = null
        /**
         * The name or unique ID of the StackSet associated with the stack instances.
         */
        public var stackSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest) : this() {
            this.accounts = x.accounts
            this.callAs = x.callAs
            this.deploymentTargets = x.deploymentTargets
            this.operationId = x.operationId
            this.operationPreferences = x.operationPreferences
            this.parameterOverrides = x.parameterOverrides
            this.regions = x.regions
            this.stackSetName = x.stackSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest = UpdateStackInstancesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets] inside the given [block]
         */
        public fun deploymentTargets(block: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.Builder.() -> kotlin.Unit) {
            this.deploymentTargets = aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences] inside the given [block]
         */
        public fun operationPreferences(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.Builder.() -> kotlin.Unit) {
            this.operationPreferences = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
