// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structures that contain summary information about the specified StackSet.
 */
public class StackSetSummary private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).
     */
    public val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * A description of the StackSet that you specify when the StackSet is created or updated.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Status of the StackSet's actual configuration compared to its expected template and parameter configuration.
     * + `DRIFTED`: One or more of the stack instances belonging to the StackSet differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
     * + `NOT_CHECKED`: CloudFormation hasn't checked the StackSet for drift.
     * + `IN_SYNC`: All the stack instances belonging to the StackSet match the expected template and parameter configuration.
     * + `UNKNOWN`: This value is reserved for future use.
     */
    public val driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = builder.driftStatus
    /**
     * Most recent time when CloudFormation performed a drift detection operation on the StackSet. This value will be `NULL` for any StackSet that drift detection hasn't yet been performed on.
     */
    public val lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDriftCheckTimestamp
    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     */
    public val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * Describes how the IAM roles required for StackSet operations are created.
     * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
     * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
     */
    public val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * The ID of the StackSet.
     */
    public val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The name of the StackSet.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The status of the StackSet.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetSummary(")
        append("autoDeployment=$autoDeployment,")
        append("description=$description,")
        append("driftStatus=$driftStatus,")
        append("lastDriftCheckTimestamp=$lastDriftCheckTimestamp,")
        append("managedExecution=$managedExecution,")
        append("permissionModel=$permissionModel,")
        append("stackSetId=$stackSetId,")
        append("stackSetName=$stackSetName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoDeployment?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (lastDriftCheckTimestamp?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetSummary

        if (autoDeployment != other.autoDeployment) return false
        if (description != other.description) return false
        if (driftStatus != other.driftStatus) return false
        if (lastDriftCheckTimestamp != other.lastDriftCheckTimestamp) return false
        if (managedExecution != other.managedExecution) return false
        if (permissionModel != other.permissionModel) return false
        if (stackSetId != other.stackSetId) return false
        if (stackSetName != other.stackSetName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).
         */
        public var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * A description of the StackSet that you specify when the StackSet is created or updated.
         */
        public var description: kotlin.String? = null
        /**
         * Status of the StackSet's actual configuration compared to its expected template and parameter configuration.
         * + `DRIFTED`: One or more of the stack instances belonging to the StackSet differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
         * + `NOT_CHECKED`: CloudFormation hasn't checked the StackSet for drift.
         * + `IN_SYNC`: All the stack instances belonging to the StackSet match the expected template and parameter configuration.
         * + `UNKNOWN`: This value is reserved for future use.
         */
        public var driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = null
        /**
         * Most recent time when CloudFormation performed a drift detection operation on the StackSet. This value will be `NULL` for any StackSet that drift detection hasn't yet been performed on.
         */
        public var lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
         */
        public var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * Describes how the IAM roles required for StackSet operations are created.
         * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
         * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
         */
        public var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * The ID of the StackSet.
         */
        public var stackSetId: kotlin.String? = null
        /**
         * The name of the StackSet.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The status of the StackSet.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetSummary) : this() {
            this.autoDeployment = x.autoDeployment
            this.description = x.description
            this.driftStatus = x.driftStatus
            this.lastDriftCheckTimestamp = x.lastDriftCheckTimestamp
            this.managedExecution = x.managedExecution
            this.permissionModel = x.permissionModel
            this.stackSetId = x.stackSetId
            this.stackSetName = x.stackSetName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = StackSetSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        public fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        public fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
