// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure that contains information about a specified operation's results for a given account in a given Region.
 */
public class StackSetOperationResultSummary private constructor(builder: Builder) {
    /**
     * &#91;Self-managed permissions&#93; The name of the Amazon Web Services account for this operation result.
     */
    public val account: kotlin.String? = builder.account
    /**
     * The results of the account gate function CloudFormation invokes, if present, before proceeding with StackSet operations in an account.
     */
    public val accountGateResult: aws.sdk.kotlin.services.cloudformation.model.AccountGateResult? = builder.accountGateResult
    /**
     * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
     */
    public val organizationalUnitId: kotlin.String? = builder.organizationalUnitId
    /**
     * The name of the Amazon Web Services Region for this operation result.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The result status of the StackSet operation for the given account in the given Region.
     * + `CANCELLED`: The operation in the specified account and Region has been canceled. This is either because a user has stopped the StackSet operation, or because the failure tolerance of the StackSet operation has been exceeded.
     * + `FAILED`: The operation in the specified account and Region failed.If the StackSet operation fails in enough accounts within a Region, the failure tolerance for the StackSet operation as a whole might be exceeded.
     * + `RUNNING`: The operation in the specified account and Region is currently in progress.
     * + `PENDING`: The operation in the specified account and Region has yet to start.
     * + `SUCCEEDED`: The operation in the specified account and Region completed successfully.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultStatus? = builder.status
    /**
     * The reason for the assigned result status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetOperationResultSummary(")
        append("account=$account,")
        append("accountGateResult=$accountGateResult,")
        append("organizationalUnitId=$organizationalUnitId,")
        append("region=$region,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (accountGateResult?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetOperationResultSummary

        if (account != other.account) return false
        if (accountGateResult != other.accountGateResult) return false
        if (organizationalUnitId != other.organizationalUnitId) return false
        if (region != other.region) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Self-managed permissions&#93; The name of the Amazon Web Services account for this operation result.
         */
        public var account: kotlin.String? = null
        /**
         * The results of the account gate function CloudFormation invokes, if present, before proceeding with StackSet operations in an account.
         */
        public var accountGateResult: aws.sdk.kotlin.services.cloudformation.model.AccountGateResult? = null
        /**
         * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
         */
        public var organizationalUnitId: kotlin.String? = null
        /**
         * The name of the Amazon Web Services Region for this operation result.
         */
        public var region: kotlin.String? = null
        /**
         * The result status of the StackSet operation for the given account in the given Region.
         * + `CANCELLED`: The operation in the specified account and Region has been canceled. This is either because a user has stopped the StackSet operation, or because the failure tolerance of the StackSet operation has been exceeded.
         * + `FAILED`: The operation in the specified account and Region failed.If the StackSet operation fails in enough accounts within a Region, the failure tolerance for the StackSet operation as a whole might be exceeded.
         * + `RUNNING`: The operation in the specified account and Region is currently in progress.
         * + `PENDING`: The operation in the specified account and Region has yet to start.
         * + `SUCCEEDED`: The operation in the specified account and Region completed successfully.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultStatus? = null
        /**
         * The reason for the assigned result status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary) : this() {
            this.account = x.account
            this.accountGateResult = x.accountGateResult
            this.organizationalUnitId = x.organizationalUnitId
            this.region = x.region
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary = StackSetOperationResultSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AccountGateResult] inside the given [block]
         */
        public fun accountGateResult(block: aws.sdk.kotlin.services.cloudformation.model.AccountGateResult.Builder.() -> kotlin.Unit) {
            this.accountGateResult = aws.sdk.kotlin.services.cloudformation.model.AccountGateResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
