// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains information about a StackSet. With StackSets, you can provision stacks across Amazon Web Services accounts and Regions from a single CloudFormation template. Each stack is based on the same CloudFormation template, but you can customize individual stacks using parameters.
 */
public class StackSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to create or update the stack set.
     *
     * Use customized administrator roles to control which users or groups can manage specific StackSets within the same administrator account. For more information, see [Prerequisites for using CloudFormation StackSets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
     */
    public val administrationRoleArn: kotlin.String? = builder.administrationRoleArn
    /**
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU). Valid only if the StackSet uses service-managed permissions.
     */
    public val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * The capabilities that are allowed in the StackSet. Some StackSet templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * A description of the StackSet that you specify when the StackSet is created or updated.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the IAM execution role used to create or update the StackSet.
     *
     * Use customized execution roles to control which stack resources users and groups can include in their StackSets.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     */
    public val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
     */
    public val organizationalUnitIds: List<String>? = builder.organizationalUnitIds
    /**
     * A list of input parameters for a StackSet.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * Describes how the IAM roles required for StackSet operations are created.
     * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
     * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
     */
    public val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * Returns a list of all Amazon Web Services Regions the given StackSet has stack instances deployed in. The Amazon Web Services Regions list output is in no particular order.
     */
    public val regions: List<String>? = builder.regions
    /**
     * The Amazon Resource Name (ARN) of the StackSet.
     */
    public val stackSetArn: kotlin.String? = builder.stackSetArn
    /**
     * Detailed information about the drift status of the StackSet.
     *
     * For StackSets, contains information about the last *completed* drift operation performed on the StackSet. Information about drift operations currently in progress isn't included.
     */
    public val stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = builder.stackSetDriftDetectionDetails
    /**
     * The ID of the StackSet.
     */
    public val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The name that's associated with the StackSet.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The status of the StackSet.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = builder.status
    /**
     * A list of tags that specify information about the StackSet. A maximum number of 50 tags can be specified.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The structure that contains the body of the template that was used to create or update the StackSet.
     */
    public val templateBody: kotlin.String? = builder.templateBody

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSet(")
        append("administrationRoleArn=$administrationRoleArn,")
        append("autoDeployment=$autoDeployment,")
        append("capabilities=$capabilities,")
        append("description=$description,")
        append("executionRoleName=$executionRoleName,")
        append("managedExecution=$managedExecution,")
        append("organizationalUnitIds=$organizationalUnitIds,")
        append("parameters=$parameters,")
        append("permissionModel=$permissionModel,")
        append("regions=$regions,")
        append("stackSetArn=$stackSetArn,")
        append("stackSetDriftDetectionDetails=$stackSetDriftDetectionDetails,")
        append("stackSetId=$stackSetId,")
        append("stackSetName=$stackSetName,")
        append("status=$status,")
        append("tags=$tags,")
        append("templateBody=$templateBody")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrationRoleArn?.hashCode() ?: 0
        result = 31 * result + (autoDeployment?.hashCode() ?: 0)
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (stackSetArn?.hashCode() ?: 0)
        result = 31 * result + (stackSetDriftDetectionDetails?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSet

        if (administrationRoleArn != other.administrationRoleArn) return false
        if (autoDeployment != other.autoDeployment) return false
        if (capabilities != other.capabilities) return false
        if (description != other.description) return false
        if (executionRoleName != other.executionRoleName) return false
        if (managedExecution != other.managedExecution) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false
        if (parameters != other.parameters) return false
        if (permissionModel != other.permissionModel) return false
        if (regions != other.regions) return false
        if (stackSetArn != other.stackSetArn) return false
        if (stackSetDriftDetectionDetails != other.stackSetDriftDetectionDetails) return false
        if (stackSetId != other.stackSetId) return false
        if (stackSetName != other.stackSetName) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to create or update the stack set.
         *
         * Use customized administrator roles to control which users or groups can manage specific StackSets within the same administrator account. For more information, see [Prerequisites for using CloudFormation StackSets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
         */
        public var administrationRoleArn: kotlin.String? = null
        /**
         * Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU). Valid only if the StackSet uses service-managed permissions.
         */
        public var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * The capabilities that are allowed in the StackSet. Some StackSet templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
         */
        public var capabilities: List<Capability>? = null
        /**
         * A description of the StackSet that you specify when the StackSet is created or updated.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the IAM execution role used to create or update the StackSet.
         *
         * Use customized execution roles to control which stack resources users and groups can include in their StackSets.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
         */
        public var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
         */
        public var organizationalUnitIds: List<String>? = null
        /**
         * A list of input parameters for a StackSet.
         */
        public var parameters: List<Parameter>? = null
        /**
         * Describes how the IAM roles required for StackSet operations are created.
         * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant self-managed permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
         * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Activate trusted access for StackSets with Organizations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-activate-trusted-access.html).
         */
        public var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * Returns a list of all Amazon Web Services Regions the given StackSet has stack instances deployed in. The Amazon Web Services Regions list output is in no particular order.
         */
        public var regions: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the StackSet.
         */
        public var stackSetArn: kotlin.String? = null
        /**
         * Detailed information about the drift status of the StackSet.
         *
         * For StackSets, contains information about the last *completed* drift operation performed on the StackSet. Information about drift operations currently in progress isn't included.
         */
        public var stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = null
        /**
         * The ID of the StackSet.
         */
        public var stackSetId: kotlin.String? = null
        /**
         * The name that's associated with the StackSet.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The status of the StackSet.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = null
        /**
         * A list of tags that specify information about the StackSet. A maximum number of 50 tags can be specified.
         */
        public var tags: List<Tag>? = null
        /**
         * The structure that contains the body of the template that was used to create or update the StackSet.
         */
        public var templateBody: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSet) : this() {
            this.administrationRoleArn = x.administrationRoleArn
            this.autoDeployment = x.autoDeployment
            this.capabilities = x.capabilities
            this.description = x.description
            this.executionRoleName = x.executionRoleName
            this.managedExecution = x.managedExecution
            this.organizationalUnitIds = x.organizationalUnitIds
            this.parameters = x.parameters
            this.permissionModel = x.permissionModel
            this.regions = x.regions
            this.stackSetArn = x.stackSetArn
            this.stackSetDriftDetectionDetails = x.stackSetDriftDetectionDetails
            this.stackSetId = x.stackSetId
            this.stackSetName = x.stackSetName
            this.status = x.status
            this.tags = x.tags
            this.templateBody = x.templateBody
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSet = StackSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        public fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        public fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails] inside the given [block]
         */
        public fun stackSetDriftDetectionDetails(block: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.Builder.() -> kotlin.Unit) {
            this.stackSetDriftDetectionDetails = aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
