// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the stack and the action that CloudFormation will perform on it if you execute the stack refactor.
 */
public class StackRefactorAction private constructor(builder: Builder) {
    /**
     * The action that CloudFormation takes on the stack.
     */
    public val action: aws.sdk.kotlin.services.cloudformation.model.StackRefactorActionType? = builder.action
    /**
     * A description to help you identify the refactor.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The detection type is one of the following:
     * + Auto: CloudFormation figured out the mapping on its own.
     * + Manual: The customer provided the mapping in the `ResourceMapping` parameter.
     */
    public val detection: aws.sdk.kotlin.services.cloudformation.model.StackRefactorDetection? = builder.detection
    /**
     * The description of the detection type.
     */
    public val detectionReason: kotlin.String? = builder.detectionReason
    /**
     * The type that will be evaluated in the `StackRefactorAction`. The following are potential `Entity` types:
     * + `Stack`
     * + `Resource`
     */
    public val entity: aws.sdk.kotlin.services.cloudformation.model.StackRefactorActionEntity? = builder.entity
    /**
     * The name or unique identifier associated with the physical instance of the resource.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * A key-value pair that identifies the target resource. The key is an identifier property (for example, `BucketName` for `AWS::S3::Bucket` resources) and the value is the actual property value (for example, `MyS3Bucket`).
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier
    /**
     * The mapping for the stack resource `Source` and stack resource `Destination`.
     */
    public val resourceMapping: aws.sdk.kotlin.services.cloudformation.model.ResourceMapping? = builder.resourceMapping
    /**
     * Assigns one or more tags to specified resources.
     */
    public val tagResources: List<Tag>? = builder.tagResources
    /**
     * Removes one or more tags to specified resources.
     */
    public val untagResources: List<String>? = builder.untagResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackRefactorAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackRefactorAction(")
        append("action=$action,")
        append("description=$description,")
        append("detection=$detection,")
        append("detectionReason=$detectionReason,")
        append("entity=$entity,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("resourceMapping=$resourceMapping,")
        append("tagResources=$tagResources,")
        append("untagResources=$untagResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (detection?.hashCode() ?: 0)
        result = 31 * result + (detectionReason?.hashCode() ?: 0)
        result = 31 * result + (entity?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceMapping?.hashCode() ?: 0)
        result = 31 * result + (tagResources?.hashCode() ?: 0)
        result = 31 * result + (untagResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackRefactorAction

        if (action != other.action) return false
        if (description != other.description) return false
        if (detection != other.detection) return false
        if (detectionReason != other.detectionReason) return false
        if (entity != other.entity) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (resourceMapping != other.resourceMapping) return false
        if (tagResources != other.tagResources) return false
        if (untagResources != other.untagResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackRefactorAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action that CloudFormation takes on the stack.
         */
        public var action: aws.sdk.kotlin.services.cloudformation.model.StackRefactorActionType? = null
        /**
         * A description to help you identify the refactor.
         */
        public var description: kotlin.String? = null
        /**
         * The detection type is one of the following:
         * + Auto: CloudFormation figured out the mapping on its own.
         * + Manual: The customer provided the mapping in the `ResourceMapping` parameter.
         */
        public var detection: aws.sdk.kotlin.services.cloudformation.model.StackRefactorDetection? = null
        /**
         * The description of the detection type.
         */
        public var detectionReason: kotlin.String? = null
        /**
         * The type that will be evaluated in the `StackRefactorAction`. The following are potential `Entity` types:
         * + `Stack`
         * + `Resource`
         */
        public var entity: aws.sdk.kotlin.services.cloudformation.model.StackRefactorActionEntity? = null
        /**
         * The name or unique identifier associated with the physical instance of the resource.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * A key-value pair that identifies the target resource. The key is an identifier property (for example, `BucketName` for `AWS::S3::Bucket` resources) and the value is the actual property value (for example, `MyS3Bucket`).
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * The mapping for the stack resource `Source` and stack resource `Destination`.
         */
        public var resourceMapping: aws.sdk.kotlin.services.cloudformation.model.ResourceMapping? = null
        /**
         * Assigns one or more tags to specified resources.
         */
        public var tagResources: List<Tag>? = null
        /**
         * Removes one or more tags to specified resources.
         */
        public var untagResources: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackRefactorAction) : this() {
            this.action = x.action
            this.description = x.description
            this.detection = x.detection
            this.detectionReason = x.detectionReason
            this.entity = x.entity
            this.physicalResourceId = x.physicalResourceId
            this.resourceIdentifier = x.resourceIdentifier
            this.resourceMapping = x.resourceMapping
            this.tagResources = x.tagResources
            this.untagResources = x.untagResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackRefactorAction = StackRefactorAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ResourceMapping] inside the given [block]
         */
        public fun resourceMapping(block: aws.sdk.kotlin.services.cloudformation.model.ResourceMapping.Builder.() -> kotlin.Unit) {
            this.resourceMapping = aws.sdk.kotlin.services.cloudformation.model.ResourceMapping.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
