// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Stack data type.
 */
public class Stack private constructor(builder: Builder) {
    /**
     * The capabilities allowed in the stack.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The unique ID of the change set.
     */
    public val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * The time at which the stack was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Specifies the deletion mode for the stack. Possible values are:
     * + `STANDARD` - Use the standard behavior. Specifying this value is the same as not specifying this parameter.
     * + `FORCE_DELETE_STACK` - Delete the stack if it's stuck in a `DELETE_FAILED` state due to resource deletion failure.
     */
    public val deletionMode: aws.sdk.kotlin.services.cloudformation.model.DeletionMode? = builder.deletionMode
    /**
     * The time the stack was deleted.
     */
    public val deletionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionTime
    /**
     * A user-defined description associated with the stack.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The detailed status of the resource or stack. If `CONFIGURATION_COMPLETE` is present, the resource or resource configuration phase has completed and the stabilization of the resources is in progress. The StackSets `CONFIGURATION_COMPLETE` when all of the resources in the stack have reached that event. For more information, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
     */
    public val detailedStatus: aws.sdk.kotlin.services.cloudformation.model.DetailedStatus? = builder.detailedStatus
    /**
     * Boolean to enable or disable rollback on stack creation failures:
     * + `true`: disable rollback.
     * + `false`: enable rollback.
     */
    public val disableRollback: kotlin.Boolean? = builder.disableRollback
    /**
     * Information about whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     */
    public val driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation? = builder.driftInformation
    /**
     * Whether termination protection is enabled for the stack.
     *
     * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack. For more information, see [Protect a CloudFormation stack from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
     */
    public val enableTerminationProtection: kotlin.Boolean? = builder.enableTerminationProtection
    /**
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
     */
    public val notificationArns: List<String>? = builder.notificationArns
    /**
     * A list of output structures.
     */
    public val outputs: List<Output>? = builder.outputs
    /**
     * A list of `Parameter` structures.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * For nested stacks, the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
     *
     * For more information, see [Nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val parentId: kotlin.String? = builder.parentId
    /**
     * When set to `true`, newly created resources are deleted when the operation rolls back. This includes newly created resources marked with a deletion policy of `Retain`.
     *
     * Default: `false`
     */
    public val retainExceptOnCreate: kotlin.Boolean? = builder.retainExceptOnCreate
    /**
     * The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
     */
    public val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * For nested stacks, the stack ID of the top-level stack to which the nested stack ultimately belongs.
     *
     * For more information, see [Nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val rootId: kotlin.String? = builder.rootId
    /**
     * Unique identifier of the stack.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The name associated with the stack.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * Current status of the stack.
     */
    public val stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = builder.stackStatus
    /**
     * Success/failure message associated with the stack status.
     */
    public val stackStatusReason: kotlin.String? = builder.stackStatusReason
    /**
     * A list of `Tag`s that specify information about the stack.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The amount of time within which stack creation should complete.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.Stack = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stack(")
        append("capabilities=$capabilities,")
        append("changeSetId=$changeSetId,")
        append("creationTime=$creationTime,")
        append("deletionMode=$deletionMode,")
        append("deletionTime=$deletionTime,")
        append("description=$description,")
        append("detailedStatus=$detailedStatus,")
        append("disableRollback=$disableRollback,")
        append("driftInformation=$driftInformation,")
        append("enableTerminationProtection=$enableTerminationProtection,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("notificationArns=$notificationArns,")
        append("outputs=$outputs,")
        append("parameters=$parameters,")
        append("parentId=$parentId,")
        append("retainExceptOnCreate=$retainExceptOnCreate,")
        append("roleArn=$roleArn,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("rootId=$rootId,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("stackStatus=$stackStatus,")
        append("stackStatusReason=$stackStatusReason,")
        append("tags=$tags,")
        append("timeoutInMinutes=$timeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (changeSetId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deletionMode?.hashCode() ?: 0)
        result = 31 * result + (deletionTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (detailedStatus?.hashCode() ?: 0)
        result = 31 * result + (disableRollback?.hashCode() ?: 0)
        result = 31 * result + (driftInformation?.hashCode() ?: 0)
        result = 31 * result + (enableTerminationProtection?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (notificationArns?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (retainExceptOnCreate?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (rootId?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackStatus?.hashCode() ?: 0)
        result = 31 * result + (stackStatusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stack

        if (capabilities != other.capabilities) return false
        if (changeSetId != other.changeSetId) return false
        if (creationTime != other.creationTime) return false
        if (deletionMode != other.deletionMode) return false
        if (deletionTime != other.deletionTime) return false
        if (description != other.description) return false
        if (detailedStatus != other.detailedStatus) return false
        if (disableRollback != other.disableRollback) return false
        if (driftInformation != other.driftInformation) return false
        if (enableTerminationProtection != other.enableTerminationProtection) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (notificationArns != other.notificationArns) return false
        if (outputs != other.outputs) return false
        if (parameters != other.parameters) return false
        if (parentId != other.parentId) return false
        if (retainExceptOnCreate != other.retainExceptOnCreate) return false
        if (roleArn != other.roleArn) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (rootId != other.rootId) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (stackStatus != other.stackStatus) return false
        if (stackStatusReason != other.stackStatusReason) return false
        if (tags != other.tags) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.Stack = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capabilities allowed in the stack.
         */
        public var capabilities: List<Capability>? = null
        /**
         * The unique ID of the change set.
         */
        public var changeSetId: kotlin.String? = null
        /**
         * The time at which the stack was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the deletion mode for the stack. Possible values are:
         * + `STANDARD` - Use the standard behavior. Specifying this value is the same as not specifying this parameter.
         * + `FORCE_DELETE_STACK` - Delete the stack if it's stuck in a `DELETE_FAILED` state due to resource deletion failure.
         */
        public var deletionMode: aws.sdk.kotlin.services.cloudformation.model.DeletionMode? = null
        /**
         * The time the stack was deleted.
         */
        public var deletionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A user-defined description associated with the stack.
         */
        public var description: kotlin.String? = null
        /**
         * The detailed status of the resource or stack. If `CONFIGURATION_COMPLETE` is present, the resource or resource configuration phase has completed and the stabilization of the resources is in progress. The StackSets `CONFIGURATION_COMPLETE` when all of the resources in the stack have reached that event. For more information, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
         */
        public var detailedStatus: aws.sdk.kotlin.services.cloudformation.model.DetailedStatus? = null
        /**
         * Boolean to enable or disable rollback on stack creation failures:
         * + `true`: disable rollback.
         * + `false`: enable rollback.
         */
        public var disableRollback: kotlin.Boolean? = null
        /**
         * Information about whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
         */
        public var driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation? = null
        /**
         * Whether termination protection is enabled for the stack.
         *
         * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack. For more information, see [Protect a CloudFormation stack from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
         */
        public var enableTerminationProtection: kotlin.Boolean? = null
        /**
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         */
        public var notificationArns: List<String>? = null
        /**
         * A list of output structures.
         */
        public var outputs: List<Output>? = null
        /**
         * A list of `Parameter` structures.
         */
        public var parameters: List<Parameter>? = null
        /**
         * For nested stacks, the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
         *
         * For more information, see [Nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var parentId: kotlin.String? = null
        /**
         * When set to `true`, newly created resources are deleted when the operation rolls back. This includes newly created resources marked with a deletion policy of `Retain`.
         *
         * Default: `false`
         */
        public var retainExceptOnCreate: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
         */
        public var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * For nested stacks, the stack ID of the top-level stack to which the nested stack ultimately belongs.
         *
         * For more information, see [Nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var rootId: kotlin.String? = null
        /**
         * Unique identifier of the stack.
         */
        public var stackId: kotlin.String? = null
        /**
         * The name associated with the stack.
         */
        public var stackName: kotlin.String? = null
        /**
         * Current status of the stack.
         */
        public var stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = null
        /**
         * Success/failure message associated with the stack status.
         */
        public var stackStatusReason: kotlin.String? = null
        /**
         * A list of `Tag`s that specify information about the stack.
         */
        public var tags: List<Tag>? = null
        /**
         * The amount of time within which stack creation should complete.
         */
        public var timeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.Stack) : this() {
            this.capabilities = x.capabilities
            this.changeSetId = x.changeSetId
            this.creationTime = x.creationTime
            this.deletionMode = x.deletionMode
            this.deletionTime = x.deletionTime
            this.description = x.description
            this.detailedStatus = x.detailedStatus
            this.disableRollback = x.disableRollback
            this.driftInformation = x.driftInformation
            this.enableTerminationProtection = x.enableTerminationProtection
            this.lastUpdatedTime = x.lastUpdatedTime
            this.notificationArns = x.notificationArns
            this.outputs = x.outputs
            this.parameters = x.parameters
            this.parentId = x.parentId
            this.retainExceptOnCreate = x.retainExceptOnCreate
            this.roleArn = x.roleArn
            this.rollbackConfiguration = x.rollbackConfiguration
            this.rootId = x.rootId
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.stackStatus = x.stackStatus
            this.stackStatusReason = x.stackStatusReason
            this.tags = x.tags
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.Stack = Stack(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation] inside the given [block]
         */
        public fun driftInformation(block: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation.Builder.() -> kotlin.Unit) {
            this.driftInformation = aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        public fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
