// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The field that CloudFormation will change, such as the name of a resource's property, and whether the resource will be recreated.
 */
public class ResourceTargetDefinition private constructor(builder: Builder) {
    /**
     * The value of the property after the change is executed. Large values can be truncated.
     */
    public val afterValue: kotlin.String? = builder.afterValue
    /**
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's `Metadata`, `Properties`, or `Tags`.
     */
    public val attribute: aws.sdk.kotlin.services.cloudformation.model.ResourceAttribute? = builder.attribute
    /**
     * The type of change to be made to the property if the change is executed.
     * + `Add` The item will be added.
     * + `Remove` The item will be removed.
     * + `Modify` The item will be modified.
     */
    public val attributeChangeType: aws.sdk.kotlin.services.cloudformation.model.AttributeChangeType? = builder.attributeChangeType
    /**
     * The value of the property before the change is executed. Large values can be truncated.
     */
    public val beforeValue: kotlin.String? = builder.beforeValue
    /**
     * If the `Attribute` value is `Properties`, the name of the property. For all other attributes, the value is null.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The property path of the property.
     */
    public val path: kotlin.String? = builder.path
    /**
     * If the `Attribute` value is `Properties`, indicates whether a change to this property causes the resource to be recreated. The value can be `Never`, `Always`, or `Conditionally`. To determine the conditions for a `Conditionally` recreation, see the update behavior for that property in the [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
     */
    public val requiresRecreation: aws.sdk.kotlin.services.cloudformation.model.RequiresRecreation? = builder.requiresRecreation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceTargetDefinition(")
        append("afterValue=$afterValue,")
        append("attribute=$attribute,")
        append("attributeChangeType=$attributeChangeType,")
        append("beforeValue=$beforeValue,")
        append("name=$name,")
        append("path=$path,")
        append("requiresRecreation=$requiresRecreation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = afterValue?.hashCode() ?: 0
        result = 31 * result + (attribute?.hashCode() ?: 0)
        result = 31 * result + (attributeChangeType?.hashCode() ?: 0)
        result = 31 * result + (beforeValue?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (requiresRecreation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceTargetDefinition

        if (afterValue != other.afterValue) return false
        if (attribute != other.attribute) return false
        if (attributeChangeType != other.attributeChangeType) return false
        if (beforeValue != other.beforeValue) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (requiresRecreation != other.requiresRecreation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The value of the property after the change is executed. Large values can be truncated.
         */
        public var afterValue: kotlin.String? = null
        /**
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's `Metadata`, `Properties`, or `Tags`.
         */
        public var attribute: aws.sdk.kotlin.services.cloudformation.model.ResourceAttribute? = null
        /**
         * The type of change to be made to the property if the change is executed.
         * + `Add` The item will be added.
         * + `Remove` The item will be removed.
         * + `Modify` The item will be modified.
         */
        public var attributeChangeType: aws.sdk.kotlin.services.cloudformation.model.AttributeChangeType? = null
        /**
         * The value of the property before the change is executed. Large values can be truncated.
         */
        public var beforeValue: kotlin.String? = null
        /**
         * If the `Attribute` value is `Properties`, the name of the property. For all other attributes, the value is null.
         */
        public var name: kotlin.String? = null
        /**
         * The property path of the property.
         */
        public var path: kotlin.String? = null
        /**
         * If the `Attribute` value is `Properties`, indicates whether a change to this property causes the resource to be recreated. The value can be `Never`, `Always`, or `Conditionally`. To determine the conditions for a `Conditionally` recreation, see the update behavior for that property in the [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
         */
        public var requiresRecreation: aws.sdk.kotlin.services.cloudformation.model.RequiresRecreation? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition) : this() {
            this.afterValue = x.afterValue
            this.attribute = x.attribute
            this.attributeChangeType = x.attributeChangeType
            this.beforeValue = x.beforeValue
            this.name = x.name
            this.path = x.path
            this.requiresRecreation = x.requiresRecreation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceTargetDefinition = ResourceTargetDefinition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
