// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the resource scan. This is returned by the `ListResourceScan` API action.
 */
public class ResourceScanSummary private constructor(builder: Builder) {
    /**
     * The time that the resource scan was finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The percentage of the resource scan that has been completed.
     */
    public val percentageCompleted: kotlin.Double? = builder.percentageCompleted
    /**
     * The Amazon Resource Name (ARN) of the resource scan.
     */
    public val resourceScanId: kotlin.String? = builder.resourceScanId
    /**
     * The scan type that has been completed.
     */
    public val scanType: aws.sdk.kotlin.services.cloudformation.model.ScanType? = builder.scanType
    /**
     * The time that the resource scan was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Status of the resource scan.
     *
     * ##  IN_PROGRESS
     * The resource scan is still in progress.
     *
     * ##  COMPLETE
     * The resource scan is complete.
     *
     * ##  EXPIRED
     * The resource scan has expired.
     *
     * ##  FAILED
     * The resource scan has failed.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus? = builder.status
    /**
     * The reason for the resource scan status, providing more information if a failure happened.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceScanSummary(")
        append("endTime=$endTime,")
        append("percentageCompleted=$percentageCompleted,")
        append("resourceScanId=$resourceScanId,")
        append("scanType=$scanType,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (percentageCompleted?.hashCode() ?: 0)
        result = 31 * result + (resourceScanId?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceScanSummary

        if (endTime != other.endTime) return false
        if (!(percentageCompleted?.equals(other.percentageCompleted) ?: (other.percentageCompleted == null))) return false
        if (resourceScanId != other.resourceScanId) return false
        if (scanType != other.scanType) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time that the resource scan was finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The percentage of the resource scan that has been completed.
         */
        public var percentageCompleted: kotlin.Double? = null
        /**
         * The Amazon Resource Name (ARN) of the resource scan.
         */
        public var resourceScanId: kotlin.String? = null
        /**
         * The scan type that has been completed.
         */
        public var scanType: aws.sdk.kotlin.services.cloudformation.model.ScanType? = null
        /**
         * The time that the resource scan was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the resource scan.
         *
         * ##  IN_PROGRESS
         * The resource scan is still in progress.
         *
         * ##  COMPLETE
         * The resource scan is complete.
         *
         * ##  EXPIRED
         * The resource scan has expired.
         *
         * ##  FAILED
         * The resource scan has failed.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus? = null
        /**
         * The reason for the resource scan status, providing more information if a failure happened.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary) : this() {
            this.endTime = x.endTime
            this.percentageCompleted = x.percentageCompleted
            this.resourceScanId = x.resourceScanId
            this.scanType = x.scanType
            this.startTime = x.startTime
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary = ResourceScanSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
