// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListStackInstanceResourceDriftsRequest private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous paginated request didn't return all of the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The unique ID of the drift operation.
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * The name of the Amazon Web Services account that you want to list resource drifts for.
     */
    public val stackInstanceAccount: kotlin.String? = builder.stackInstanceAccount
    /**
     * The name of the Region where you want to list resource drifts.
     */
    public val stackInstanceRegion: kotlin.String? = builder.stackInstanceRegion
    /**
     * The resource drift status of the stack instance.
     * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
     * + `MODIFIED`: One or more resource properties differ from their expected template values.
     * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
     * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
     */
    public val stackInstanceResourceDriftStatuses: List<StackResourceDriftStatus>? = builder.stackInstanceResourceDriftStatuses
    /**
     * The name or unique ID of the StackSet that you want to list drifted resources for.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStackInstanceResourceDriftsRequest(")
        append("callAs=$callAs,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("operationId=$operationId,")
        append("stackInstanceAccount=$stackInstanceAccount,")
        append("stackInstanceRegion=$stackInstanceRegion,")
        append("stackInstanceResourceDriftStatuses=$stackInstanceResourceDriftStatuses,")
        append("stackSetName=$stackSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAs?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (stackInstanceAccount?.hashCode() ?: 0)
        result = 31 * result + (stackInstanceRegion?.hashCode() ?: 0)
        result = 31 * result + (stackInstanceResourceDriftStatuses?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStackInstanceResourceDriftsRequest

        if (callAs != other.callAs) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (operationId != other.operationId) return false
        if (stackInstanceAccount != other.stackInstanceAccount) return false
        if (stackInstanceRegion != other.stackInstanceRegion) return false
        if (stackInstanceResourceDriftStatuses != other.stackInstanceResourceDriftStatuses) return false
        if (stackSetName != other.stackSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous paginated request didn't return all of the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The unique ID of the drift operation.
         */
        public var operationId: kotlin.String? = null
        /**
         * The name of the Amazon Web Services account that you want to list resource drifts for.
         */
        public var stackInstanceAccount: kotlin.String? = null
        /**
         * The name of the Region where you want to list resource drifts.
         */
        public var stackInstanceRegion: kotlin.String? = null
        /**
         * The resource drift status of the stack instance.
         * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
         * + `MODIFIED`: One or more resource properties differ from their expected template values.
         * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
         * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
         */
        public var stackInstanceResourceDriftStatuses: List<StackResourceDriftStatus>? = null
        /**
         * The name or unique ID of the StackSet that you want to list drifted resources for.
         */
        public var stackSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsRequest) : this() {
            this.callAs = x.callAs
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.operationId = x.operationId
            this.stackInstanceAccount = x.stackInstanceAccount
            this.stackInstanceRegion = x.stackInstanceRegion
            this.stackInstanceResourceDriftStatuses = x.stackInstanceResourceDriftStatuses
            this.stackSetName = x.stackSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsRequest = ListStackInstanceResourceDriftsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
