// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListHookResultsRequest private constructor(builder: Builder) {
    /**
     * A string that identifies the next page of events that you want to retrieve.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Filters results by the status of Hook invocations. Can only be used in combination with `TypeArn`. Valid values are:
     * + `HOOK_IN_PROGRESS`: The Hook is currently running.
     * + `HOOK_COMPLETE_SUCCEEDED`: The Hook completed successfully.
     * + `HOOK_COMPLETE_FAILED`: The Hook completed but failed validation.
     * + `HOOK_FAILED`: The Hook encountered an error during execution.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = builder.status
    /**
     * Filters results by the unique identifier of the target the Hook was invoked against.
     *
     * For change sets, this is the change set ARN. When the target is a Cloud Control API operation, this value must be the `HookRequestToken` returned by the Cloud Control API request. For more information on the `HookRequestToken`, see [ProgressEvent](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html).
     *
     * Required when `TargetType` is specified and cannot be used otherwise.
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * Filters results by target type. Currently, only `CHANGE_SET` and `CLOUD_CONTROL` are supported filter options.
     *
     * Required when `TargetId` is specified and cannot be used otherwise.
     */
    public val targetType: aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType? = builder.targetType
    /**
     * Filters results by the ARN of the Hook. Can be used alone or in combination with `Status`.
     */
    public val typeArn: kotlin.String? = builder.typeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ListHookResultsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHookResultsRequest(")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetType=$targetType,")
        append("typeArn=$typeArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (typeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHookResultsRequest

        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetType != other.targetType) return false
        if (typeArn != other.typeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ListHookResultsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string that identifies the next page of events that you want to retrieve.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Filters results by the status of Hook invocations. Can only be used in combination with `TypeArn`. Valid values are:
         * + `HOOK_IN_PROGRESS`: The Hook is currently running.
         * + `HOOK_COMPLETE_SUCCEEDED`: The Hook completed successfully.
         * + `HOOK_COMPLETE_FAILED`: The Hook completed but failed validation.
         * + `HOOK_FAILED`: The Hook encountered an error during execution.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = null
        /**
         * Filters results by the unique identifier of the target the Hook was invoked against.
         *
         * For change sets, this is the change set ARN. When the target is a Cloud Control API operation, this value must be the `HookRequestToken` returned by the Cloud Control API request. For more information on the `HookRequestToken`, see [ProgressEvent](https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html).
         *
         * Required when `TargetType` is specified and cannot be used otherwise.
         */
        public var targetId: kotlin.String? = null
        /**
         * Filters results by target type. Currently, only `CHANGE_SET` and `CLOUD_CONTROL` are supported filter options.
         *
         * Required when `TargetId` is specified and cannot be used otherwise.
         */
        public var targetType: aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType? = null
        /**
         * Filters results by the ARN of the Hook. Can be used alone or in combination with `Status`.
         */
        public var typeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ListHookResultsRequest) : this() {
            this.nextToken = x.nextToken
            this.status = x.status
            this.targetId = x.targetId
            this.targetType = x.targetType
            this.typeArn = x.typeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ListHookResultsRequest = ListHookResultsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
