// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Hook invocation, its status, and the reason for its status.
 */
public class HookResultSummary private constructor(builder: Builder) {
    /**
     * The failure mode of the invocation.
     */
    public val failureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = builder.failureMode
    /**
     * The ARN of the target stack or request token of the Cloud Control API operation.
     *
     * Only shown in responses when the request does not specify `TargetType` and `TargetId` filters.
     */
    public val hookExecutionTarget: kotlin.String? = builder.hookExecutionTarget
    /**
     * The unique identifier for this Hook invocation result.
     */
    public val hookResultId: kotlin.String? = builder.hookResultId
    /**
     * A description of the Hook results status. For example, if the Hook result is in a failed state, this may contain additional information for the failed state.
     */
    public val hookStatusReason: kotlin.String? = builder.hookStatusReason
    /**
     * The specific point in the provisioning process where the Hook is invoked.
     */
    public val invocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = builder.invocationPoint
    /**
     * The timestamp when the Hook was invoked.
     *
     * Only shown in responses when the request does not specify `TargetType` and `TargetId` filters.
     */
    public val invokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.invokedAt
    /**
     * The status of the Hook invocation. The following statuses are possible:
     * + `HOOK_IN_PROGRESS`: The Hook is currently running.
     * + `HOOK_COMPLETE_SUCCEEDED`: The Hook completed successfully.
     * + `HOOK_COMPLETE_FAILED`: The Hook completed but failed validation.
     * + `HOOK_FAILED`: The Hook encountered an error during execution.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = builder.status
    /**
     * The unique identifier of the Hook invocation target.
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * The target type that the Hook was invoked against.
     */
    public val targetType: aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType? = builder.targetType
    /**
     * The ARN of the Hook that was invoked.
     */
    public val typeArn: kotlin.String? = builder.typeArn
    /**
     * The version of the Hook configuration.
     */
    public val typeConfigurationVersionId: kotlin.String? = builder.typeConfigurationVersionId
    /**
     * The name of the Hook that was invoked.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * The version of the Hook that was invoked.
     */
    public val typeVersionId: kotlin.String? = builder.typeVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HookResultSummary(")
        append("failureMode=$failureMode,")
        append("hookExecutionTarget=$hookExecutionTarget,")
        append("hookResultId=$hookResultId,")
        append("hookStatusReason=$hookStatusReason,")
        append("invocationPoint=$invocationPoint,")
        append("invokedAt=$invokedAt,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetType=$targetType,")
        append("typeArn=$typeArn,")
        append("typeConfigurationVersionId=$typeConfigurationVersionId,")
        append("typeName=$typeName,")
        append("typeVersionId=$typeVersionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureMode?.hashCode() ?: 0
        result = 31 * result + (hookExecutionTarget?.hashCode() ?: 0)
        result = 31 * result + (hookResultId?.hashCode() ?: 0)
        result = 31 * result + (hookStatusReason?.hashCode() ?: 0)
        result = 31 * result + (invocationPoint?.hashCode() ?: 0)
        result = 31 * result + (invokedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (typeArn?.hashCode() ?: 0)
        result = 31 * result + (typeConfigurationVersionId?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (typeVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HookResultSummary

        if (failureMode != other.failureMode) return false
        if (hookExecutionTarget != other.hookExecutionTarget) return false
        if (hookResultId != other.hookResultId) return false
        if (hookStatusReason != other.hookStatusReason) return false
        if (invocationPoint != other.invocationPoint) return false
        if (invokedAt != other.invokedAt) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetType != other.targetType) return false
        if (typeArn != other.typeArn) return false
        if (typeConfigurationVersionId != other.typeConfigurationVersionId) return false
        if (typeName != other.typeName) return false
        if (typeVersionId != other.typeVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The failure mode of the invocation.
         */
        public var failureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = null
        /**
         * The ARN of the target stack or request token of the Cloud Control API operation.
         *
         * Only shown in responses when the request does not specify `TargetType` and `TargetId` filters.
         */
        public var hookExecutionTarget: kotlin.String? = null
        /**
         * The unique identifier for this Hook invocation result.
         */
        public var hookResultId: kotlin.String? = null
        /**
         * A description of the Hook results status. For example, if the Hook result is in a failed state, this may contain additional information for the failed state.
         */
        public var hookStatusReason: kotlin.String? = null
        /**
         * The specific point in the provisioning process where the Hook is invoked.
         */
        public var invocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = null
        /**
         * The timestamp when the Hook was invoked.
         *
         * Only shown in responses when the request does not specify `TargetType` and `TargetId` filters.
         */
        public var invokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the Hook invocation. The following statuses are possible:
         * + `HOOK_IN_PROGRESS`: The Hook is currently running.
         * + `HOOK_COMPLETE_SUCCEEDED`: The Hook completed successfully.
         * + `HOOK_COMPLETE_FAILED`: The Hook completed but failed validation.
         * + `HOOK_FAILED`: The Hook encountered an error during execution.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = null
        /**
         * The unique identifier of the Hook invocation target.
         */
        public var targetId: kotlin.String? = null
        /**
         * The target type that the Hook was invoked against.
         */
        public var targetType: aws.sdk.kotlin.services.cloudformation.model.ListHookResultsTargetType? = null
        /**
         * The ARN of the Hook that was invoked.
         */
        public var typeArn: kotlin.String? = null
        /**
         * The version of the Hook configuration.
         */
        public var typeConfigurationVersionId: kotlin.String? = null
        /**
         * The name of the Hook that was invoked.
         */
        public var typeName: kotlin.String? = null
        /**
         * The version of the Hook that was invoked.
         */
        public var typeVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.HookResultSummary) : this() {
            this.failureMode = x.failureMode
            this.hookExecutionTarget = x.hookExecutionTarget
            this.hookResultId = x.hookResultId
            this.hookStatusReason = x.hookStatusReason
            this.invocationPoint = x.invocationPoint
            this.invokedAt = x.invokedAt
            this.status = x.status
            this.targetId = x.targetId
            this.targetType = x.targetType
            this.typeArn = x.typeArn
            this.typeConfigurationVersionId = x.typeConfigurationVersionId
            this.typeName = x.typeName
            this.typeVersionId = x.typeVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = HookResultSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
