// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input for the GetTemplateSummary action.
 */
public class GetTemplateSummaryRequest private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * The name or the stack ID that's associated with the stack, which aren't always interchangeable. For running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify the unique stack ID.
     *
     * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * The name or unique ID of the StackSet from which the stack was created.
     *
     * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * Structure that contains the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     *
     * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * Specifies options for the `GetTemplateSummary` API action.
     */
    public val templateSummaryConfig: aws.sdk.kotlin.services.cloudformation.model.TemplateSummaryConfig? = builder.templateSummaryConfig
    /**
     * The URL of a file that contains the template body. The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`.
     *
     * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetTemplateSummaryRequest(")
        append("callAs=$callAs,")
        append("stackName=$stackName,")
        append("stackSetName=$stackSetName,")
        append("templateBody=$templateBody,")
        append("templateSummaryConfig=$templateSummaryConfig,")
        append("templateUrl=$templateUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAs?.hashCode() ?: 0
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateSummaryConfig?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetTemplateSummaryRequest

        if (callAs != other.callAs) return false
        if (stackName != other.stackName) return false
        if (stackSetName != other.stackSetName) return false
        if (templateBody != other.templateBody) return false
        if (templateSummaryConfig != other.templateSummaryConfig) return false
        if (templateUrl != other.templateUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for StackSets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * The name or the stack ID that's associated with the stack, which aren't always interchangeable. For running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify the unique stack ID.
         *
         * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
         */
        public var stackName: kotlin.String? = null
        /**
         * The name or unique ID of the StackSet from which the stack was created.
         *
         * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * Structure that contains the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         *
         * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
         */
        public var templateBody: kotlin.String? = null
        /**
         * Specifies options for the `GetTemplateSummary` API action.
         */
        public var templateSummaryConfig: aws.sdk.kotlin.services.cloudformation.model.TemplateSummaryConfig? = null
        /**
         * The URL of a file that contains the template body. The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`.
         *
         * Conditional: You must specify only one of the following parameters: `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
         */
        public var templateUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest) : this() {
            this.callAs = x.callAs
            this.stackName = x.stackName
            this.stackSetName = x.stackSetName
            this.templateBody = x.templateBody
            this.templateSummaryConfig = x.templateSummaryConfig
            this.templateUrl = x.templateUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest = GetTemplateSummaryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.TemplateSummaryConfig] inside the given [block]
         */
        public fun templateSummaryConfig(block: aws.sdk.kotlin.services.cloudformation.model.TemplateSummaryConfig.Builder.() -> kotlin.Unit) {
            this.templateSummaryConfig = aws.sdk.kotlin.services.cloudformation.model.TemplateSummaryConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
