// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeStackResourceDriftsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A string that identifies the next page of stack resource drift results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the stack for which you want drift information.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * The resource drift status values to use as filters for the resource drift results returned.
     * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
     * + `MODIFIED`: One or more resource properties differ from their expected template values.
     * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
     * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
     * + `UNKNOWN`: CloudFormation could not run drift detection for the resource.
     */
    public val stackResourceDriftStatusFilters: List<StackResourceDriftStatus>? = builder.stackResourceDriftStatusFilters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStackResourceDriftsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("stackName=$stackName,")
        append("stackResourceDriftStatusFilters=$stackResourceDriftStatusFilters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackResourceDriftStatusFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStackResourceDriftsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (stackName != other.stackName) return false
        if (stackResourceDriftStatusFilters != other.stackResourceDriftStatusFilters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A string that identifies the next page of stack resource drift results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the stack for which you want drift information.
         */
        public var stackName: kotlin.String? = null
        /**
         * The resource drift status values to use as filters for the resource drift results returned.
         * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
         * + `MODIFIED`: One or more resource properties differ from their expected template values.
         * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
         * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
         * + `UNKNOWN`: CloudFormation could not run drift detection for the resource.
         */
        public var stackResourceDriftStatusFilters: List<StackResourceDriftStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.stackName = x.stackName
            this.stackResourceDriftStatusFilters = x.stackResourceDriftStatusFilters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest = DescribeStackResourceDriftsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
