// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeStackDriftDetectionStatusResponse private constructor(builder: Builder) {
    /**
     * The status of the stack drift detection operation.
     * + `DETECTION_COMPLETE`: The stack drift detection operation has successfully completed for all resources in the stack that support drift detection. (Resources that don't currently support stack detection remain unchecked.)If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection operation, only the resources with those logical IDs are checked for drift.
     * + `DETECTION_FAILED`: The stack drift detection operation has failed for at least one resource in the stack. Results will be available for resources on which CloudFormation successfully completed drift detection.
     * + `DETECTION_IN_PROGRESS`: The stack drift detection operation is currently in progress.
     */
    public val detectionStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftDetectionStatus? = builder.detectionStatus
    /**
     * The reason the stack drift detection operation has its current status.
     */
    public val detectionStatusReason: kotlin.String? = builder.detectionStatusReason
    /**
     * Total number of stack resources that have drifted. This is NULL until the drift detection operation reaches a status of `DETECTION_COMPLETE`. This value will be 0 for stacks whose drift status is `IN_SYNC`.
     */
    public val driftedStackResourceCount: kotlin.Int? = builder.driftedStackResourceCount
    /**
     * The ID of the drift detection results of this operation.
     *
     * CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However, the number of reports CloudFormation retains for any given stack, and for how long, may vary.
     */
    public val stackDriftDetectionId: kotlin.String? = builder.stackDriftDetectionId
    /**
     * Status of the stack's actual configuration compared to its expected configuration.
     * + `DRIFTED`: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.
     * + `NOT_CHECKED`: CloudFormation hasn't checked if the stack differs from its expected template configuration.
     * + `IN_SYNC`: The stack's actual configuration matches its expected template configuration.
     * + `UNKNOWN`: CloudFormation could not run drift detection for a resource in the stack. See the `DetectionStatusReason` for details.
     */
    public val stackDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = builder.stackDriftStatus
    /**
     * The ID of the stack.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * Time at which the stack drift detection operation was initiated.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStackDriftDetectionStatusResponse(")
        append("detectionStatus=$detectionStatus,")
        append("detectionStatusReason=$detectionStatusReason,")
        append("driftedStackResourceCount=$driftedStackResourceCount,")
        append("stackDriftDetectionId=$stackDriftDetectionId,")
        append("stackDriftStatus=$stackDriftStatus,")
        append("stackId=$stackId,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detectionStatus?.hashCode() ?: 0
        result = 31 * result + (detectionStatusReason?.hashCode() ?: 0)
        result = 31 * result + (driftedStackResourceCount ?: 0)
        result = 31 * result + (stackDriftDetectionId?.hashCode() ?: 0)
        result = 31 * result + (stackDriftStatus?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStackDriftDetectionStatusResponse

        if (detectionStatus != other.detectionStatus) return false
        if (detectionStatusReason != other.detectionStatusReason) return false
        if (driftedStackResourceCount != other.driftedStackResourceCount) return false
        if (stackDriftDetectionId != other.stackDriftDetectionId) return false
        if (stackDriftStatus != other.stackDriftStatus) return false
        if (stackId != other.stackId) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of the stack drift detection operation.
         * + `DETECTION_COMPLETE`: The stack drift detection operation has successfully completed for all resources in the stack that support drift detection. (Resources that don't currently support stack detection remain unchecked.)If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection operation, only the resources with those logical IDs are checked for drift.
         * + `DETECTION_FAILED`: The stack drift detection operation has failed for at least one resource in the stack. Results will be available for resources on which CloudFormation successfully completed drift detection.
         * + `DETECTION_IN_PROGRESS`: The stack drift detection operation is currently in progress.
         */
        public var detectionStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftDetectionStatus? = null
        /**
         * The reason the stack drift detection operation has its current status.
         */
        public var detectionStatusReason: kotlin.String? = null
        /**
         * Total number of stack resources that have drifted. This is NULL until the drift detection operation reaches a status of `DETECTION_COMPLETE`. This value will be 0 for stacks whose drift status is `IN_SYNC`.
         */
        public var driftedStackResourceCount: kotlin.Int? = null
        /**
         * The ID of the drift detection results of this operation.
         *
         * CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However, the number of reports CloudFormation retains for any given stack, and for how long, may vary.
         */
        public var stackDriftDetectionId: kotlin.String? = null
        /**
         * Status of the stack's actual configuration compared to its expected configuration.
         * + `DRIFTED`: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.
         * + `NOT_CHECKED`: CloudFormation hasn't checked if the stack differs from its expected template configuration.
         * + `IN_SYNC`: The stack's actual configuration matches its expected template configuration.
         * + `UNKNOWN`: CloudFormation could not run drift detection for a resource in the stack. See the `DetectionStatusReason` for details.
         */
        public var stackDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = null
        /**
         * The ID of the stack.
         */
        public var stackId: kotlin.String? = null
        /**
         * Time at which the stack drift detection operation was initiated.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse) : this() {
            this.detectionStatus = x.detectionStatus
            this.detectionStatusReason = x.detectionStatusReason
            this.driftedStackResourceCount = x.driftedStackResourceCount
            this.stackDriftDetectionId = x.stackDriftDetectionId
            this.stackDriftStatus = x.stackDriftStatus
            this.stackId = x.stackId
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse = DescribeStackDriftDetectionStatusResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
