// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the Organizations accounts where you want to create, update, or delete stack instances. You can target either your entire organization or specific accounts using organizational units (OUs) and account filter options.
 *
 * CloudFormation doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization.
 *
 * When performing create operations, if you specify both `OrganizationalUnitIds` and `Accounts`, you must also specify the `AccountFilterType` property.
 */
public class DeploymentTargets private constructor(builder: Builder) {
    /**
     * Refines which accounts will have stack operations performed on them by specifying how to use the `Accounts` and `OrganizationalUnitIds` properties together.
     *
     * The following values determine how CloudFormation selects target accounts:
     * + `INTERSECTION`: Performs stack operations only on specific individual accounts within the selected OUs. Only accounts that are both specified in the `Accounts` property and belong to the specified OUs will be targeted.
     * + `DIFFERENCE`: Performs stack operations on all accounts in the selected OUs except for specific accounts listed in the `Accounts` property. This enables you to exclude certain accounts within an OU, such as suspended accounts.
     * + `UNION`: Performs stack operations on the specified OUs plus additional individual accounts listed in the `Accounts` property. This is the default value if `AccountFilterType` is not provided. This lets you target an entire OU and individual accounts from a different OU in one request. Note that `UNION` is not supported for `CreateStackInstances` operations.
     * + `NONE`: Performs stack operations on all accounts in the specified organizational units (OUs).
     */
    public val accountFilterType: aws.sdk.kotlin.services.cloudformation.model.AccountFilterType? = builder.accountFilterType
    /**
     * The Amazon Web Services account IDs where you want to perform stack operations. How these accounts are used depends on the `AccountFilterType` property.
     *
     * If you have many account numbers, you can provide those accounts using the `AccountsUrl` property instead.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * The Amazon S3 URL path to a file that contains a list of Amazon Web Services account IDs. The file format must be either `.csv` or `.txt`, and the data can be comma-separated or new-line-separated. There is currently a 10MB limit for the data (approximately 800,000 accounts).
     *
     * This property serves the same purpose as `Accounts` but allows you to specify a large number of accounts.
     */
    public val accountsUrl: kotlin.String? = builder.accountsUrl
    /**
     * The organization root ID or organizational unit (OU) IDs where you want to perform stack operations. CloudFormation will perform operations on accounts within these OUs and their child OUs.
     */
    public val organizationalUnitIds: List<String>? = builder.organizationalUnitIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentTargets(")
        append("accountFilterType=$accountFilterType,")
        append("accounts=$accounts,")
        append("accountsUrl=$accountsUrl,")
        append("organizationalUnitIds=$organizationalUnitIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountFilterType?.hashCode() ?: 0
        result = 31 * result + (accounts?.hashCode() ?: 0)
        result = 31 * result + (accountsUrl?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentTargets

        if (accountFilterType != other.accountFilterType) return false
        if (accounts != other.accounts) return false
        if (accountsUrl != other.accountsUrl) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Refines which accounts will have stack operations performed on them by specifying how to use the `Accounts` and `OrganizationalUnitIds` properties together.
         *
         * The following values determine how CloudFormation selects target accounts:
         * + `INTERSECTION`: Performs stack operations only on specific individual accounts within the selected OUs. Only accounts that are both specified in the `Accounts` property and belong to the specified OUs will be targeted.
         * + `DIFFERENCE`: Performs stack operations on all accounts in the selected OUs except for specific accounts listed in the `Accounts` property. This enables you to exclude certain accounts within an OU, such as suspended accounts.
         * + `UNION`: Performs stack operations on the specified OUs plus additional individual accounts listed in the `Accounts` property. This is the default value if `AccountFilterType` is not provided. This lets you target an entire OU and individual accounts from a different OU in one request. Note that `UNION` is not supported for `CreateStackInstances` operations.
         * + `NONE`: Performs stack operations on all accounts in the specified organizational units (OUs).
         */
        public var accountFilterType: aws.sdk.kotlin.services.cloudformation.model.AccountFilterType? = null
        /**
         * The Amazon Web Services account IDs where you want to perform stack operations. How these accounts are used depends on the `AccountFilterType` property.
         *
         * If you have many account numbers, you can provide those accounts using the `AccountsUrl` property instead.
         */
        public var accounts: List<String>? = null
        /**
         * The Amazon S3 URL path to a file that contains a list of Amazon Web Services account IDs. The file format must be either `.csv` or `.txt`, and the data can be comma-separated or new-line-separated. There is currently a 10MB limit for the data (approximately 800,000 accounts).
         *
         * This property serves the same purpose as `Accounts` but allows you to specify a large number of accounts.
         */
        public var accountsUrl: kotlin.String? = null
        /**
         * The organization root ID or organizational unit (OU) IDs where you want to perform stack operations. CloudFormation will perform operations on accounts within these OUs and their child OUs.
         */
        public var organizationalUnitIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets) : this() {
            this.accountFilterType = x.accountFilterType
            this.accounts = x.accounts
            this.accountsUrl = x.accountsUrl
            this.organizationalUnitIds = x.organizationalUnitIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = DeploymentTargets(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
