// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input for CreateStack action.
 */
public class CreateStackRequest private constructor(builder: Builder) {
    /**
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for CloudFormation to create the stack.
     * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
     *    + If you have IAM resources, you can specify either capability.
     *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
     *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
     * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
     *    + [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-accesskey.html)
     *    + [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-group.html)
     *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-instanceprofile.html)
     *    + [ AWS::IAM::ManagedPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-managedpolicy.html)
     *    + [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-policy.html)
     *    + [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-role.html)
     *    + [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-user.html)
     *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-usertogroupaddition.html)
     * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
     * + `CAPABILITY_AUTO_EXPAND`Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually creating the stack. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-include.html) and [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.If you want to create a stack from a stack template that contains macros *and* nested stacks, you must create the stack directly from the template using this capability.You should only create stacks directly from a stack template that contains macros if you know what processing the macro performs.Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the Lambda function owner can update the function operation without CloudFormation being notified.For more information, see [Perform custom processing on CloudFormation templates with template macros](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
     *
     * Only one of the `Capabilities` and `ResourceType` parameters can be specified.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * A unique identifier for this `CreateStack` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to create a stack with the same name. You might retry `CreateStack` requests to ensure that CloudFormation successfully received them.
     *
     * All events initiated by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a `CreateStack` operation with the token `token1`, then all the `StackEvents` generated by that operation will have `ClientRequestToken` set as `token1`.
     *
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format *Console-StackOperation-ID*, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Set to `true` to disable rollback of the stack if stack creation failed. You can specify either `DisableRollback` or `OnFailure`, but not both.
     *
     * Default: `false`
     */
    public val disableRollback: kotlin.Boolean? = builder.disableRollback
    /**
     * Whether to enable termination protection on the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protect CloudFormation stacks from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*. Termination protection is deactivated on stacks by default.
     *
     * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
     */
    public val enableTerminationProtection: kotlin.Boolean? = builder.enableTerminationProtection
    /**
     * The Amazon SNS topic ARNs to publish stack related events. You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
     */
    public val notificationArns: List<String>? = builder.notificationArns
    /**
     * Determines what action will be taken if stack creation fails. This must be one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. You can specify either `OnFailure` or `DisableRollback`, but not both.
     *
     * Although the default setting is `ROLLBACK`, there is one exception. This exception occurs when a StackSet attempts to deploy a stack instance and the stack instance fails to create successfully. In this case, the `CreateStack` call overrides the default setting and sets the value of `OnFailure` to `DELETE`.
     *
     * Default: `ROLLBACK`
     */
    public val onFailure: aws.sdk.kotlin.services.cloudformation.model.OnFailure? = builder.onFailure
    /**
     * A list of `Parameter` structures that specify input parameters for the stack. For more information, see the [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html) data type.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * The template resource types that you have permissions to work with for this create stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`, or `Custom::MyCustomInstance`. Use the following syntax to describe template resource types: `AWS::*` (for all Amazon Web Services resources), `Custom::*` (for all custom resources), `Custom::<i>logical_ID</i> ` (for a specific custom resource), `AWS::<i>service_name</i>::*` (for all resources of a particular Amazon Web Services service), and `AWS::<i>service_name</i>::<i>resource_logical_ID</i> ` (for a specific Amazon Web Services resource).
     *
     * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By default, CloudFormation grants permissions to all resource types. IAM uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see [Control access with Identity and Access Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html).
     *
     * Only one of the `Capabilities` and `ResourceType` parameters can be specified.
     */
    public val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * When set to `true`, newly created resources are deleted when the operation rolls back. This includes newly created resources marked with a deletion policy of `Retain`.
     *
     * Default: `false`
     */
    public val retainExceptOnCreate: kotlin.Boolean? = builder.retainExceptOnCreate
    /**
     * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to create the stack. CloudFormation uses the role's credentials to make calls on your behalf. CloudFormation always uses this role for all future operations on the stack. Provided that users have permission to operate on the stack, CloudFormation uses this role even if the users don't have permission to pass it. Ensure that the role grants least privilege.
     *
     * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no role is available, CloudFormation uses a temporary session that's generated from your user credentials.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
     */
    public val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * The name that's associated with the stack. The name must be unique in the Region in which you are creating the stack.
     *
     * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an alphabetical character and can't be longer than 128 characters.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * Structure that contains the stack policy body. For more information, see [Prevent updates to stack resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html) in the *CloudFormation User Guide*. You can specify either the `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
     */
    public val stackPolicyBody: kotlin.String? = builder.stackPolicyBody
    /**
     * Location of a file that contains the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start with `https://`. URLs from S3 static websites are not supported.
     *
     * You can specify either the `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
     */
    public val stackPolicyUrl: kotlin.String? = builder.stackPolicyUrl
    /**
     * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Structure that contains the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     *
     * Conditional: You must specify either `TemplateBody` or `TemplateURL`, but not both.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * The URL of a file that contains the template body. The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`. URLs from S3 static websites are not supported.
     *
     * Conditional: You must specify either the `TemplateBody` or the `TemplateURL` parameter, but not both.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl
    /**
     * The amount of time that can pass before the stack status becomes `CREATE_FAILED`; if `DisableRollback` is not set or is set to `false`, the stack will be rolled back.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStackRequest(")
        append("capabilities=$capabilities,")
        append("clientRequestToken=$clientRequestToken,")
        append("disableRollback=$disableRollback,")
        append("enableTerminationProtection=$enableTerminationProtection,")
        append("notificationArns=$notificationArns,")
        append("onFailure=$onFailure,")
        append("parameters=$parameters,")
        append("resourceTypes=$resourceTypes,")
        append("retainExceptOnCreate=$retainExceptOnCreate,")
        append("roleArn=$roleArn,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("stackName=$stackName,")
        append("stackPolicyBody=$stackPolicyBody,")
        append("stackPolicyUrl=$stackPolicyUrl,")
        append("tags=$tags,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl,")
        append("timeoutInMinutes=$timeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (disableRollback?.hashCode() ?: 0)
        result = 31 * result + (enableTerminationProtection?.hashCode() ?: 0)
        result = 31 * result + (notificationArns?.hashCode() ?: 0)
        result = 31 * result + (onFailure?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (retainExceptOnCreate?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyBody?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyUrl?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStackRequest

        if (capabilities != other.capabilities) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (disableRollback != other.disableRollback) return false
        if (enableTerminationProtection != other.enableTerminationProtection) return false
        if (notificationArns != other.notificationArns) return false
        if (onFailure != other.onFailure) return false
        if (parameters != other.parameters) return false
        if (resourceTypes != other.resourceTypes) return false
        if (retainExceptOnCreate != other.retainExceptOnCreate) return false
        if (roleArn != other.roleArn) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (stackName != other.stackName) return false
        if (stackPolicyBody != other.stackPolicyBody) return false
        if (stackPolicyUrl != other.stackPolicyUrl) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for CloudFormation to create the stack.
         * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
         *    + If you have IAM resources, you can specify either capability.
         *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
         *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
         * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
         *    + [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-accesskey.html)
         *    + [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-group.html)
         *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-instanceprofile.html)
         *    + [ AWS::IAM::ManagedPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-managedpolicy.html)
         *    + [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-policy.html)
         *    + [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-role.html)
         *    + [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-user.html)
         *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-resource-iam-usertogroupaddition.html)
         * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
         * + `CAPABILITY_AUTO_EXPAND`Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually creating the stack. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-include.html) and [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.If you want to create a stack from a stack template that contains macros *and* nested stacks, you must create the stack directly from the template using this capability.You should only create stacks directly from a stack template that contains macros if you know what processing the macro performs.Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the Lambda function owner can update the function operation without CloudFormation being notified.For more information, see [Perform custom processing on CloudFormation templates with template macros](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
         *
         * Only one of the `Capabilities` and `ResourceType` parameters can be specified.
         */
        public var capabilities: List<Capability>? = null
        /**
         * A unique identifier for this `CreateStack` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to create a stack with the same name. You might retry `CreateStack` requests to ensure that CloudFormation successfully received them.
         *
         * All events initiated by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a `CreateStack` operation with the token `token1`, then all the `StackEvents` generated by that operation will have `ClientRequestToken` set as `token1`.
         *
         * In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format *Console-StackOperation-ID*, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Set to `true` to disable rollback of the stack if stack creation failed. You can specify either `DisableRollback` or `OnFailure`, but not both.
         *
         * Default: `false`
         */
        public var disableRollback: kotlin.Boolean? = null
        /**
         * Whether to enable termination protection on the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protect CloudFormation stacks from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*. Termination protection is deactivated on stacks by default.
         *
         * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
         */
        public var enableTerminationProtection: kotlin.Boolean? = null
        /**
         * The Amazon SNS topic ARNs to publish stack related events. You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
         */
        public var notificationArns: List<String>? = null
        /**
         * Determines what action will be taken if stack creation fails. This must be one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. You can specify either `OnFailure` or `DisableRollback`, but not both.
         *
         * Although the default setting is `ROLLBACK`, there is one exception. This exception occurs when a StackSet attempts to deploy a stack instance and the stack instance fails to create successfully. In this case, the `CreateStack` call overrides the default setting and sets the value of `OnFailure` to `DELETE`.
         *
         * Default: `ROLLBACK`
         */
        public var onFailure: aws.sdk.kotlin.services.cloudformation.model.OnFailure? = null
        /**
         * A list of `Parameter` structures that specify input parameters for the stack. For more information, see the [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html) data type.
         */
        public var parameters: List<Parameter>? = null
        /**
         * The template resource types that you have permissions to work with for this create stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`, or `Custom::MyCustomInstance`. Use the following syntax to describe template resource types: `AWS::*` (for all Amazon Web Services resources), `Custom::*` (for all custom resources), `Custom::<i>logical_ID</i> ` (for a specific custom resource), `AWS::<i>service_name</i>::*` (for all resources of a particular Amazon Web Services service), and `AWS::<i>service_name</i>::<i>resource_logical_ID</i> ` (for a specific Amazon Web Services resource).
         *
         * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By default, CloudFormation grants permissions to all resource types. IAM uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see [Control access with Identity and Access Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html).
         *
         * Only one of the `Capabilities` and `ResourceType` parameters can be specified.
         */
        public var resourceTypes: List<String>? = null
        /**
         * When set to `true`, newly created resources are deleted when the operation rolls back. This includes newly created resources marked with a deletion policy of `Retain`.
         *
         * Default: `false`
         */
        public var retainExceptOnCreate: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to create the stack. CloudFormation uses the role's credentials to make calls on your behalf. CloudFormation always uses this role for all future operations on the stack. Provided that users have permission to operate on the stack, CloudFormation uses this role even if the users don't have permission to pass it. Ensure that the role grants least privilege.
         *
         * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no role is available, CloudFormation uses a temporary session that's generated from your user credentials.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
         */
        public var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * The name that's associated with the stack. The name must be unique in the Region in which you are creating the stack.
         *
         * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an alphabetical character and can't be longer than 128 characters.
         */
        public var stackName: kotlin.String? = null
        /**
         * Structure that contains the stack policy body. For more information, see [Prevent updates to stack resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html) in the *CloudFormation User Guide*. You can specify either the `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
         */
        public var stackPolicyBody: kotlin.String? = null
        /**
         * Location of a file that contains the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start with `https://`. URLs from S3 static websites are not supported.
         *
         * You can specify either the `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
         */
        public var stackPolicyUrl: kotlin.String? = null
        /**
         * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
         */
        public var tags: List<Tag>? = null
        /**
         * Structure that contains the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         *
         * Conditional: You must specify either `TemplateBody` or `TemplateURL`, but not both.
         */
        public var templateBody: kotlin.String? = null
        /**
         * The URL of a file that contains the template body. The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with `https://`. URLs from S3 static websites are not supported.
         *
         * Conditional: You must specify either the `TemplateBody` or the `TemplateURL` parameter, but not both.
         */
        public var templateUrl: kotlin.String? = null
        /**
         * The amount of time that can pass before the stack status becomes `CREATE_FAILED`; if `DisableRollback` is not set or is set to `false`, the stack will be rolled back.
         */
        public var timeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest) : this() {
            this.capabilities = x.capabilities
            this.clientRequestToken = x.clientRequestToken
            this.disableRollback = x.disableRollback
            this.enableTerminationProtection = x.enableTerminationProtection
            this.notificationArns = x.notificationArns
            this.onFailure = x.onFailure
            this.parameters = x.parameters
            this.resourceTypes = x.resourceTypes
            this.retainExceptOnCreate = x.retainExceptOnCreate
            this.roleArn = x.roleArn
            this.rollbackConfiguration = x.rollbackConfiguration
            this.stackName = x.stackName
            this.stackPolicyBody = x.stackPolicyBody
            this.stackPolicyUrl = x.stackPolicyUrl
            this.tags = x.tags
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest = CreateStackRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        public fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
