// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudformation.auth.CloudFormationAuthSchemeProvider
import aws.sdk.kotlin.services.cloudformation.auth.DefaultCloudFormationAuthSchemeProvider
import aws.sdk.kotlin.services.cloudformation.endpoints.CloudFormationEndpointParameters
import aws.sdk.kotlin.services.cloudformation.endpoints.CloudFormationEndpointProvider
import aws.sdk.kotlin.services.cloudformation.endpoints.DefaultCloudFormationEndpointProvider
import aws.sdk.kotlin.services.cloudformation.model.ActivateOrganizationsAccessRequest
import aws.sdk.kotlin.services.cloudformation.model.ActivateOrganizationsAccessResponse
import aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.ActivateTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
import aws.sdk.kotlin.services.cloudformation.model.CancelUpdateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.CancelUpdateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.ContinueUpdateRollbackRequest
import aws.sdk.kotlin.services.cloudformation.model.ContinueUpdateRollbackResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateGeneratedTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackRefactorRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackRefactorResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeactivateOrganizationsAccessRequest
import aws.sdk.kotlin.services.cloudformation.model.DeactivateOrganizationsAccessResponse
import aws.sdk.kotlin.services.cloudformation.model.DeactivateTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DeactivateTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteGeneratedTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeregisterTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DeregisterTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeOrganizationsAccessRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeOrganizationsAccessResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackInstanceRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackInstanceResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackRefactorRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackRefactorResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetOperationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetOperationResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackResourceDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackResourceDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.EstimateTemplateCostRequest
import aws.sdk.kotlin.services.cloudformation.model.EstimateTemplateCostResponse
import aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.ExecuteStackRefactorRequest
import aws.sdk.kotlin.services.cloudformation.model.ExecuteStackRefactorResponse
import aws.sdk.kotlin.services.cloudformation.model.GetGeneratedTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.GetGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.GetStackPolicyRequest
import aws.sdk.kotlin.services.cloudformation.model.GetStackPolicyResponse
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse
import aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListExportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListExportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListGeneratedTemplatesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListGeneratedTemplatesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListHookResultsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListHookResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanRelatedResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanRelatedResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScansRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScansResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstanceResourceDriftsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorActionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorActionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetAutoDeploymentTargetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetAutoDeploymentTargetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypesResponse
import aws.sdk.kotlin.services.cloudformation.model.PublishTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.PublishTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.RecordHandlerProgressRequest
import aws.sdk.kotlin.services.cloudformation.model.RecordHandlerProgressResponse
import aws.sdk.kotlin.services.cloudformation.model.RegisterPublisherRequest
import aws.sdk.kotlin.services.cloudformation.model.RegisterPublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.RegisterTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.RollbackStackRequest
import aws.sdk.kotlin.services.cloudformation.model.RollbackStackResponse
import aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest
import aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyResponse
import aws.sdk.kotlin.services.cloudformation.model.SetTypeConfigurationRequest
import aws.sdk.kotlin.services.cloudformation.model.SetTypeConfigurationResponse
import aws.sdk.kotlin.services.cloudformation.model.SetTypeDefaultVersionRequest
import aws.sdk.kotlin.services.cloudformation.model.SetTypeDefaultVersionResponse
import aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest
import aws.sdk.kotlin.services.cloudformation.model.SignalResourceResponse
import aws.sdk.kotlin.services.cloudformation.model.StartResourceScanRequest
import aws.sdk.kotlin.services.cloudformation.model.StartResourceScanResponse
import aws.sdk.kotlin.services.cloudformation.model.StopStackSetOperationRequest
import aws.sdk.kotlin.services.cloudformation.model.StopStackSetOperationResponse
import aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.TestTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateGeneratedTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateGeneratedTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateTerminationProtectionRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateTerminationProtectionResponse
import aws.sdk.kotlin.services.cloudformation.model.ValidateTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.ValidateTemplateResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "CloudFormation"
public const val SdkVersion: String = "1.5.34"
public const val ServiceApiVersion: String = "2010-05-15"

/**
 * # CloudFormation
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure deployments predictably and repeatedly. You can use CloudFormation to leverage Amazon Web Services products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Amazon EC2 Auto Scaling to build highly reliable, highly scalable, cost-effective applications without creating or configuring the underlying Amazon Web Services infrastructure.
 *
 * With CloudFormation, you declare all your resources and dependencies in a template file. The template defines a collection of resources as a single unit called a stack. CloudFormation creates and deletes all member resources of the stack together and manages all dependencies between the resources for you.
 *
 * For more information about CloudFormation, see the [CloudFormation product page](http://aws.amazon.com/cloudformation/).
 *
 * CloudFormation makes use of other Amazon Web Services products. If you need additional technical information about a specific Amazon Web Services product, you can find the product's technical documentation at [docs.aws.amazon.com](https://docs.aws.amazon.com/).
 */
public interface CloudFormationClient : SdkClient {
    /**
     * CloudFormationClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CloudFormationClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CloudFormation",
                "CLOUDFORMATION",
                "cloudformation",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CloudFormationClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CloudFormationClient = DefaultCloudFormationClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CloudFormationEndpointProvider = builder.endpointProvider ?: DefaultCloudFormationEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CloudFormationAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloudFormationAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CloudFormation"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CloudFormationEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CloudFormationAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated, the management account has permissions to create and manage StackSets for your organization.
     */
    public suspend fun activateOrganizationsAccess(input: ActivateOrganizationsAccessRequest = ActivateOrganizationsAccessRequest { }): ActivateOrganizationsAccessResponse

    /**
     * Activates a public third-party extension, such as a resource or module, to make it available for use in stack templates in your current account and Region. It can also create CloudFormation Hooks, which allow you to evaluate resource configurations before CloudFormation provisions them. Hooks integrate with both CloudFormation and Cloud Control API operations.
     *
     * After you activate an extension, you can use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to set specific properties for the extension.
     *
     * To see which extensions have been activated, use [ListTypes](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html). To see configuration details for an extension, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
     *
     * For more information, see [Activate a third-party public extension in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public-activate-extension.html) in the *CloudFormation User Guide*. For information about creating Hooks, see the [CloudFormation Hooks User Guide](https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html).
     */
    public suspend fun activateType(input: ActivateTypeRequest = ActivateTypeRequest { }): ActivateTypeResponse

    /**
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry in your current account and Region.
     *
     * For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
     */
    public suspend fun batchDescribeTypeConfigurations(input: BatchDescribeTypeConfigurationsRequest): BatchDescribeTypeConfigurationsResponse

    /**
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
     *
     * You can cancel only stacks that are in the `UPDATE_IN_PROGRESS` state.
     */
    public suspend fun cancelUpdateStack(input: CancelUpdateStackRequest): CancelUpdateStackResponse

    /**
     * Continues rolling back a stack from `UPDATE_ROLLBACK_FAILED` to `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually fix the error and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state) and then try to update the stack again.
     *
     * A stack enters the `UPDATE_ROLLBACK_FAILED` state when CloudFormation can't roll back all changes after a failed stack update. For example, this might occur when a stack attempts to roll back to an old database that was deleted outside of CloudFormation. Because CloudFormation doesn't know the instance was deleted, it assumes the instance still exists and attempts to roll back to it, causing the update rollback to fail.
     *
     * For more information, see [Continue rolling back an update](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html) in the *CloudFormation User Guide*. For information for troubleshooting a failed update rollback, see [Update rollback failed](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed).
     */
    public suspend fun continueUpdateRollback(input: ContinueUpdateRollbackRequest): ContinueUpdateRollbackResponse

    /**
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
     *
     * To create a change set for a stack that doesn't exist, for the `ChangeSetType` parameter, specify `CREATE`. To create a change set for an existing stack, specify `UPDATE` for the `ChangeSetType` parameter. To create a change set for an import operation, specify `IMPORT` for the `ChangeSetType` parameter. After the `CreateChangeSet` call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action.
     *
     * When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set.
     *
     * To create a change set for the entire stack hierarchy, set `IncludeNestedStacks` to `True`.
     */
    public suspend fun createChangeSet(input: CreateChangeSetRequest): CreateChangeSetResponse

    /**
     * Creates a template from existing resources that are not already managed with CloudFormation. You can check the status of the template generation using the `DescribeGeneratedTemplate` API action.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.CreateGeneratedTemplate.sample
     */
    public suspend fun createGeneratedTemplate(input: CreateGeneratedTemplateRequest): CreateGeneratedTemplateResponse

    /**
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the DescribeStacks operation.
     *
     * For more information about creating a stack and monitoring stack progress, see [Managing Amazon Web Services resources as a single unit with CloudFormation stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *CloudFormation User Guide*.
     */
    public suspend fun createStack(input: CreateStackRequest): CreateStackResponse

    /**
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
     *
     * The maximum number of organizational unit (OUs) supported by a `CreateStackInstances` operation is 50.
     *
     * If you need more than 50, consider the following options:
     * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
     * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
     */
    public suspend fun createStackInstances(input: CreateStackInstancesRequest): CreateStackInstancesResponse

    /**
     * Creates a refactor across multiple stacks, with the list of stacks and resources that are affected.
     */
    public suspend fun createStackRefactor(input: CreateStackRefactorRequest): CreateStackRefactorResponse

    /**
     * Creates a StackSet.
     */
    public suspend fun createStackSet(input: CreateStackSetRequest): CreateStackSetResponse

    /**
     * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not have permissions to create and manage service-managed StackSets for your organization.
     */
    public suspend fun deactivateOrganizationsAccess(input: DeactivateOrganizationsAccessRequest = DeactivateOrganizationsAccessRequest { }): DeactivateOrganizationsAccessResponse

    /**
     * Deactivates a public third-party extension, such as a resource or module, or a CloudFormation Hook when you no longer use it.
     *
     * Deactivating an extension deletes the configuration details that are associated with it. To temporary disable a CloudFormation Hook instead, you can use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html).
     *
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     *
     * To see which extensions are currently activated, use [ListTypes](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html).
     */
    public suspend fun deactivateType(input: DeactivateTypeRequest = DeactivateTypeRequest { }): DeactivateTypeResponse

    /**
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     *
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     *
     * If `IncludeNestedStacks` specifies `True` during the creation of the nested change set, then `DeleteChangeSet` will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of `REVIEW_IN_PROGRESS`.
     */
    public suspend fun deleteChangeSet(input: DeleteChangeSetRequest): DeleteChangeSetResponse

    /**
     * Deleted a generated template.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.DeleteGeneratedTemplate.sample
     */
    public suspend fun deleteGeneratedTemplate(input: DeleteGeneratedTemplateRequest): DeleteGeneratedTemplateResponse

    /**
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the DescribeStacks operation if the deletion has been completed successfully.
     *
     * For more information about deleting a stack, see [Delete a stack from the CloudFormation console](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-console-delete-stack.html) in the *CloudFormation User Guide*.
     */
    public suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse

    /**
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     *
     * The maximum number of organizational unit (OUs) supported by a `DeleteStackInstances` operation is 50.
     *
     * If you need more than 50, consider the following options:
     * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
     * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
     */
    public suspend fun deleteStackInstances(input: DeleteStackInstancesRequest): DeleteStackInstancesResponse

    /**
     * Deletes a StackSet. Before you can delete a StackSet, all its member stack instances must be deleted. For more information about how to complete this, see DeleteStackInstances.
     */
    public suspend fun deleteStackSet(input: DeleteStackSetRequest): DeleteStackSetResponse

    /**
     * Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     *
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.
     *
     * You can't deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the extension type itself is deregistered as well and marked as deprecated.
     *
     * To view the deprecation status of an extension or extension version, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
     *
     * For more information, see [Remove third-party private extensions from your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private-deregister-extension.html) in the *CloudFormation User Guide*.
     */
    public suspend fun deregisterType(input: DeregisterTypeRequest = DeregisterTypeRequest { }): DeregisterTypeResponse

    /**
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [Understand CloudFormation quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest { }): DescribeAccountLimitsResponse

    /**
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Update CloudFormation stacks using change sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the *CloudFormation User Guide*.
     */
    public suspend fun describeChangeSet(input: DescribeChangeSetRequest): DescribeChangeSetResponse

    /**
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
     */
    public suspend fun describeChangeSetHooks(input: DescribeChangeSetHooksRequest): DescribeChangeSetHooksResponse

    /**
     * Describes a generated template. The output includes details about the progress of the creation of a generated template started by a `CreateGeneratedTemplate` API action or the update of a generated template started with an `UpdateGeneratedTemplate` API action.
     */
    public suspend fun describeGeneratedTemplate(input: DescribeGeneratedTemplateRequest): DescribeGeneratedTemplateResponse

    /**
     * Retrieves information about the account's `OrganizationAccess` status. This API can be called either by the management account or the delegated administrator by using the `CallAs` parameter. This API can also be called without the `CallAs` parameter by the management account.
     */
    public suspend fun describeOrganizationsAccess(input: DescribeOrganizationsAccessRequest = DescribeOrganizationsAccessRequest { }): DescribeOrganizationsAccessResponse

    /**
     * Returns information about a CloudFormation extension publisher.
     *
     * If you don't supply a `PublisherId`, and you have registered as an extension publisher, `DescribePublisher` returns information about your own publisher account.
     *
     * For more information about registering as a publisher, see:
     * + [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
     * + [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*
     */
    public suspend fun describePublisher(input: DescribePublisherRequest = DescribePublisherRequest { }): DescribePublisherResponse

    /**
     * Describes details of a resource scan.
     */
    public suspend fun describeResourceScan(input: DescribeResourceScanRequest): DescribeResourceScanResponse

    /**
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use DetectStackDrift to initiate a stack drift detection operation. `DetectStackDrift` returns a `StackDriftDetectionId` you can use to monitor the progress of the operation using `DescribeStackDriftDetectionStatus`. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     */
    public suspend fun describeStackDriftDetectionStatus(input: DescribeStackDriftDetectionStatusRequest): DescribeStackDriftDetectionStatusResponse

    /**
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
     *
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).
     */
    public suspend fun describeStackEvents(input: DescribeStackEventsRequest = DescribeStackEventsRequest { }): DescribeStackEventsResponse

    /**
     * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon Web Services Region.
     *
     * For a list of stack instances that are associated with a specific StackSet, use ListStackInstances.
     */
    public suspend fun describeStackInstance(input: DescribeStackInstanceRequest): DescribeStackInstanceResponse

    /**
     * Describes the stack refactor status.
     */
    public suspend fun describeStackRefactor(input: DescribeStackRefactorRequest): DescribeStackRefactorResponse

    /**
     * Returns a description of the specified resource in the specified stack.
     *
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.
     */
    public suspend fun describeStackResource(input: DescribeStackResourceRequest): DescribeStackResourceResponse

    /**
     * Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     *
     * For a given stack, there will be one `StackResourceDrift` for each stack resource that has been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't currently support drift detection aren't checked, and so not included. For a list of resources that support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
     *
     * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all supported resources for a given stack.
     */
    public suspend fun describeStackResourceDrifts(input: DescribeStackResourceDriftsRequest): DescribeStackResourceDriftsResponse

    /**
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
     *
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use `ListStackResources` instead.
     *
     * For deleted stacks, `DescribeStackResources` returns resource information for up to 90 days after the stack has been deleted.
     *
     * You must specify either `StackName` or `PhysicalResourceId`, but not both. In addition, you can specify `LogicalResourceId` to filter the returned result. For more information about resources, the `LogicalResourceId` and `PhysicalResourceId`, see the [CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
     *
     * A `ValidationError` is returned if you specify both `StackName` and `PhysicalResourceId` in the same request.
     */
    public suspend fun describeStackResources(input: DescribeStackResourcesRequest = DescribeStackResourcesRequest { }): DescribeStackResourcesResponse

    /**
     * Returns the description of the specified StackSet.
     *
     * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
     */
    public suspend fun describeStackSet(input: DescribeStackSetRequest): DescribeStackSetResponse

    /**
     * Returns the description of the specified StackSet operation.
     *
     * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
     */
    public suspend fun describeStackSetOperation(input: DescribeStackSetOperationRequest): DescribeStackSetOperationResponse

    /**
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created. For more information about a stack's event history, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
     *
     * If the stack doesn't exist, a `ValidationError` is returned.
     */
    public suspend fun describeStacks(input: DescribeStacksRequest = DescribeStacksRequest { }): DescribeStacksResponse

    /**
     * Returns detailed information about an extension from the CloudFormation registry in your current account and Region.
     *
     * If you specify a `VersionId`, `DescribeType` returns information about that specific extension version. Otherwise, it returns information about the default extension version.
     */
    public suspend fun describeType(input: DescribeTypeRequest = DescribeTypeRequest { }): DescribeTypeResponse

    /**
     * Returns information about an extension's registration, including its current status and type and version identifiers.
     *
     * When you initiate a registration request using RegisterType, you can then use DescribeTypeRegistration to monitor the progress of that registration request.
     *
     * Once the registration request has completed, use DescribeType to return detailed information about an extension.
     */
    public suspend fun describeTypeRegistration(input: DescribeTypeRegistrationRequest): DescribeTypeRegistrationResponse

    /**
     * Detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackDrift` to detect drift on all supported resources for a given stack, or DetectStackResourceDrift to detect drift on individual resources.
     *
     * For a list of stack resources that currently support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
     *
     * `DetectStackDrift` can take up to several minutes, depending on the number of resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     *
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that stack. Perform `DetectStackDrift` directly on the nested stack itself.
     */
    public suspend fun detectStackDrift(input: DetectStackDriftRequest): DetectStackDriftResponse

    /**
     * Returns information about whether a resource's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackResourceDrift` to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
     *
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
     */
    public suspend fun detectStackResourceDrift(input: DetectStackResourceDriftRequest): DetectStackResourceDriftResponse

    /**
     * Detect drift on a StackSet. When CloudFormation performs drift detection on a StackSet, it performs drift detection on the stack associated with each stack instance in the StackSet. For more information, see [Performing drift detection on CloudFormation StackSets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
     *
     * `DetectStackSetDrift` returns the `OperationId` of the StackSet drift detection operation. Use this operation id with DescribeStackSetOperation to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the StackSet, in addition to the number of resources included in each stack.
     *
     * Once the operation has completed, use the following actions to return drift information:
     * + Use DescribeStackSet to return detailed information about the stack set, including detailed information about the last *completed* drift operation performed on the StackSet. (Information about drift operations that are in progress isn't included.)
     * + Use ListStackInstances to return a list of stack instances belonging to the StackSet, including the drift status and last drift time checked of each instance.
     * + Use DescribeStackInstance to return detailed information about a specific stack instance, including its drift status and last drift time checked.
     *
     * You can only run a single drift detection operation on a given StackSet at one time.
     *
     * To stop a drift detection StackSet operation, use StopStackSetOperation.
     */
    public suspend fun detectStackSetDrift(input: DetectStackSetDriftRequest): DetectStackSetDriftResponse

    /**
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
     */
    public suspend fun estimateTemplateCost(input: EstimateTemplateCostRequest = EstimateTemplateCostRequest { }): EstimateTemplateCostResponse

    /**
     * Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update.
     *
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack.
     *
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy.
     *
     * To create a change set for the entire stack hierarchy, `IncludeNestedStacks` must have been set to `True`.
     */
    public suspend fun executeChangeSet(input: ExecuteChangeSetRequest): ExecuteChangeSetResponse

    /**
     * Executes the stack refactor operation.
     */
    public suspend fun executeStackRefactor(input: ExecuteStackRefactorRequest): ExecuteStackRefactorResponse

    /**
     * Retrieves a generated template. If the template is in an `InProgress` or `Pending` status then the template returned will be the template when the template was last in a `Complete` status. If the template has not yet been in a `Complete` status then an empty template will be returned.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.GetGeneratedTemplate.sample
     * @sample aws.sdk.kotlin.services.cloudformation.samples.GetGeneratedTemplate.sample2
     */
    public suspend fun getGeneratedTemplate(input: GetGeneratedTemplateRequest): GetGeneratedTemplateResponse

    /**
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     */
    public suspend fun getStackPolicy(input: GetStackPolicyRequest): GetStackPolicyResponse

    /**
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     *
     * For deleted stacks, `GetTemplate` returns the template for up to 90 days after the stack has been deleted.
     *
     * If the template doesn't exist, a `ValidationError` is returned.
     */
    public suspend fun getTemplate(input: GetTemplateRequest = GetTemplateRequest { }): GetTemplateResponse

    /**
     * Returns information about a new or existing template. The `GetTemplateSummary` action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or StackSet.
     *
     * You can use the `GetTemplateSummary` action when you submit a template, or you can get template information for a StackSet, or a running or deleted stack.
     *
     * For deleted stacks, `GetTemplateSummary` returns the template information for up to 90 days after the stack has been deleted. If the template doesn't exist, a `ValidationError` is returned.
     */
    public suspend fun getTemplateSummary(input: GetTemplateSummaryRequest = GetTemplateSummaryRequest { }): GetTemplateSummaryResponse

    /**
     * Import existing stacks into a new StackSets. Use the stack import operation to import up to 10 stacks into a new StackSet in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
     */
    public suspend fun importStacksToStackSet(input: ImportStacksToStackSetRequest): ImportStacksToStackSetResponse

    /**
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
     */
    public suspend fun listChangeSets(input: ListChangeSetsRequest): ListChangeSetsResponse

    /**
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the [ Fn::ImportValue](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html) function.
     *
     * For more information, see [Get exported outputs from a deployed CloudFormation stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
     */
    public suspend fun listExports(input: ListExportsRequest = ListExportsRequest { }): ListExportsResponse

    /**
     * Lists your generated templates in this Region.
     */
    public suspend fun listGeneratedTemplates(input: ListGeneratedTemplatesRequest = ListGeneratedTemplatesRequest { }): ListGeneratedTemplatesResponse

    /**
     * Returns summaries of invoked Hooks. For more information, see [View CloudFormation Hooks invocations](https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-view-invocations.html) in the *CloudFormation Hooks User Guide*.
     *
     * This operation supports the following parameter combinations:
     * + No parameters: Returns all Hook invocation summaries.
     * + `TypeArn` only: Returns summaries for a specific Hook.
     * + `TypeArn` and `Status`: Returns summaries for a specific Hook filtered by status.
     * + `TargetId` and `TargetType`: Returns summaries for a specific Hook invocation target.
     */
    public suspend fun listHookResults(input: ListHookResultsRequest = ListHookResultsRequest { }): ListHookResultsResponse

    /**
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.
     *
     * For more information about importing an exported output value, see the [Fn::ImportValue](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html) function.
     */
    public suspend fun listImports(input: ListImportsRequest): ListImportsResponse

    /**
     * Lists the related resources for a list of resources from a resource scan. The response indicates whether each returned resource is already managed by CloudFormation.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanRelatedResources.sample
     */
    public suspend fun listResourceScanRelatedResources(input: ListResourceScanRelatedResourcesRequest): ListResourceScanRelatedResourcesResponse

    /**
     * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response indicates whether each returned resource is already managed by CloudFormation.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanResources.sample
     * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanResources.sample2
     */
    public suspend fun listResourceScanResources(input: ListResourceScanResourcesRequest): ListResourceScanResourcesResponse

    /**
     * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
     */
    public suspend fun listResourceScans(input: ListResourceScansRequest = ListResourceScansRequest { }): ListResourceScansResponse

    /**
     * Returns drift information for resources in a stack instance.
     *
     * `ListStackInstanceResourceDrifts` returns drift information for the most recent drift detection operation. If an operation is in progress, it may only return partial results.
     */
    public suspend fun listStackInstanceResourceDrifts(input: ListStackInstanceResourceDriftsRequest): ListStackInstanceResourceDriftsResponse

    /**
     * Returns summary information about stack instances that are associated with the specified StackSet. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
     */
    public suspend fun listStackInstances(input: ListStackInstancesRequest): ListStackInstancesResponse

    /**
     * Lists the stack refactor actions that will be taken after calling the ExecuteStackRefactor action.
     */
    public suspend fun listStackRefactorActions(input: ListStackRefactorActionsRequest): ListStackRefactorActionsResponse

    /**
     * Lists all account stack refactor operations and their statuses.
     */
    public suspend fun listStackRefactors(input: ListStackRefactorsRequest = ListStackRefactorsRequest { }): ListStackRefactorsResponse

    /**
     * Returns descriptions of all resources of the specified stack.
     *
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.
     */
    public suspend fun listStackResources(input: ListStackResourcesRequest): ListStackResourcesResponse

    /**
     * Returns summary information about deployment targets for a StackSet.
     */
    public suspend fun listStackSetAutoDeploymentTargets(input: ListStackSetAutoDeploymentTargetsRequest): ListStackSetAutoDeploymentTargetsResponse

    /**
     * Returns summary information about the results of a StackSet operation.
     *
     * This API provides *eventually consistent* reads meaning it may take some time but will eventually return the most up-to-date data.
     */
    public suspend fun listStackSetOperationResults(input: ListStackSetOperationResultsRequest): ListStackSetOperationResultsResponse

    /**
     * Returns summary information about operations performed on a StackSet.
     *
     * This API provides *eventually consistent* reads meaning it may take some time but will eventually return the most up-to-date data.
     */
    public suspend fun listStackSetOperations(input: ListStackSetOperationsRequest): ListStackSetOperationsResponse

    /**
     * Returns summary information about StackSets that are associated with the user.
     *
     * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
     *
     * + &#91;Self-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to your Amazon Web Services account, `ListStackSets` returns all self-managed StackSets in your Amazon Web Services account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to the organization's management account, `ListStackSets` returns all StackSets in the management account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `DELEGATED_ADMIN` while signed in to your member account, `ListStackSets` returns all StackSets with service-managed permissions in the management account.
     */
    public suspend fun listStackSets(input: ListStackSetsRequest = ListStackSetsRequest { }): ListStackSetsResponse

    /**
     * Returns the summary information for stacks whose status matches the specified `StackStatusFilter`. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no `StackStatusFilter` is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
     */
    public suspend fun listStacks(input: ListStacksRequest = ListStacksRequest { }): ListStacksResponse

    /**
     * Returns a list of registration tokens for the specified extension(s).
     */
    public suspend fun listTypeRegistrations(input: ListTypeRegistrationsRequest = ListTypeRegistrationsRequest { }): ListTypeRegistrationsResponse

    /**
     * Returns summary information about the versions of an extension.
     */
    public suspend fun listTypeVersions(input: ListTypeVersionsRequest = ListTypeVersionsRequest { }): ListTypeVersionsResponse

    /**
     * Returns summary information about all extensions, including your private resource types, modules, and Hooks as well as all public extensions from Amazon Web Services and third-party publishers.
     */
    public suspend fun listTypes(input: ListTypesRequest = ListTypesRequest { }): ListTypesResponse

    /**
     * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     *
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
     */
    public suspend fun publishType(input: PublishTypeRequest = PublishTypeRequest { }): PublishTypeResponse

    /**
     * Reports progress of a resource handler to CloudFormation.
     *
     * Reserved for use by the [CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html). Don't use this API in your code.
     */
    public suspend fun recordHandlerProgress(input: RecordHandlerProgressRequest): RecordHandlerProgressResponse

    /**
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
     *
     * For information about requirements for registering as a public extension publisher, see [Prerequisite: Registering your account to publish CloudFormation extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     */
    public suspend fun registerPublisher(input: RegisterPublisherRequest = RegisterPublisherRequest { }): RegisterPublisherResponse

    /**
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
     * + Validating the extension schema.
     * + Determining which handlers, if any, have been specified for the extension.
     * + Making the extension available for use in your account.
     *
     * For more information about how to develop extensions and ready them for registration, see [Creating resource types using the CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     *
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per Region. Use [DeregisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html) to deregister specific extension versions if necessary.
     *
     * Once you have initiated a registration request using RegisterType, you can use DescribeTypeRegistration to monitor the progress of the registration request.
     *
     * Once you have registered a private extension in your account and Region, use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
     */
    public suspend fun registerType(input: RegisterTypeRequest): RegisterTypeResponse

    /**
     * When specifying `RollbackStack`, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the DescribeStacks operation.
     *
     * Rolls back the specified stack to the last known stable state from `CREATE_FAILED` or `UPDATE_FAILED` stack statuses.
     *
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a `*_COMPLETE`. This includes the following stack statuses.
     * + `CREATE_COMPLETE`
     * + `UPDATE_COMPLETE`
     * + `UPDATE_ROLLBACK_COMPLETE`
     * + `IMPORT_COMPLETE`
     * + `IMPORT_ROLLBACK_COMPLETE`
     */
    public suspend fun rollbackStack(input: RollbackStackRequest): RollbackStackResponse

    /**
     * Sets a stack policy for a specified stack.
     */
    public suspend fun setStackPolicy(input: SetStackPolicyRequest): SetStackPolicyResponse

    /**
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.
     *
     * To view the current configuration data for an extension, refer to the `ConfigurationSchema` element of [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html). For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
     *
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see [Specify values stored in other services using dynamic references](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) in the *CloudFormation User Guide*.
     */
    public suspend fun setTypeConfiguration(input: SetTypeConfigurationRequest): SetTypeConfigurationResponse

    /**
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
     */
    public suspend fun setTypeDefaultVersion(input: SetTypeDefaultVersionRequest = SetTypeDefaultVersionRequest { }): SetTypeDefaultVersionResponse

    /**
     * Sends a signal to the specified resource with a success or failure status. You can use the `SignalResource` operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The `SignalResource` operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
     */
    public suspend fun signalResource(input: SignalResourceRequest): SignalResourceResponse

    /**
     * Starts a scan of the resources in this account in this Region. You can the status of a scan using the `ListResourceScans` API action.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.StartResourceScan.sample
     */
    public suspend fun startResourceScan(input: StartResourceScanRequest = StartResourceScanRequest { }): StartResourceScanResponse

    /**
     * Stops an in-progress operation on a StackSet and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
     */
    public suspend fun stopStackSetOperation(input: StopStackSetOperationRequest): StopStackSetOperationResponse

    /**
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
     * + For resource types, this includes passing all contracts tests defined for the type.
     * + For modules, this includes determining if the module's model meets all necessary requirements.
     *
     * For more information, see [Testing your public extension before publishing](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     *
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and Region for testing.
     *
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
     *
     * Once you've initiated testing on an extension using `TestType`, you can pass the returned `TypeVersionArn` into [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html) to monitor the current test status and test status description for the extension.
     *
     * An extension must have a test status of `PASSED` before it can be published. For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     */
    public suspend fun testType(input: TestTypeRequest = TestTypeRequest { }): TestTypeResponse

    /**
     * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources, and change the `DeletionPolicy` and `UpdateReplacePolicy` settings. You can check the status of the update to the generated template using the `DescribeGeneratedTemplate` API action.
     *
     * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample
     * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample2
     * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample3
     */
    public suspend fun updateGeneratedTemplate(input: UpdateGeneratedTemplateRequest): UpdateGeneratedTemplateResponse

    /**
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the DescribeStacks action.
     *
     * To get a copy of the template for an existing stack, you can use the GetTemplate action.
     *
     * For more information about updating a stack and monitoring the progress of the update, see [Managing Amazon Web Services resources as a single unit with CloudFormation stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *CloudFormation User Guide*.
     */
    public suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse

    /**
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
     *
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to create additional stack instances, use [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
     *
     * During StackSet updates, any parameters overridden for a stack instance aren't updated, but retain their overridden value.
     *
     * You can only update the parameter *values* that are specified in the StackSet. To add or delete a parameter itself, use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update the StackSet template. If you add a parameter to a template, before you can override the parameter value specified in the StackSet you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
     *
     * The maximum number of organizational unit (OUs) supported by a `UpdateStackInstances` operation is 50.
     *
     * If you need more than 50, consider the following options:
     * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
     * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
     */
    public suspend fun updateStackInstances(input: UpdateStackInstancesRequest): UpdateStackInstancesResponse

    /**
     * Updates the StackSet and associated stack instances in the specified accounts and Amazon Web Services Regions.
     *
     * Even if the StackSet operation created by updating the StackSet fails (completely or partially, below or above a specified failure tolerance), the StackSet is updated with your changes. Subsequent CreateStackInstances calls on the specified StackSet use the updated StackSet.
     *
     * The maximum number of organizational unit (OUs) supported by a `UpdateStackSet` operation is 50.
     *
     * If you need more than 50, consider the following options:
     * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
     * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
     */
    public suspend fun updateStackSet(input: UpdateStackSetRequest): UpdateStackSetResponse

    /**
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protect a CloudFormation stack from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
     *
     * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
     */
    public suspend fun updateTerminationProtection(input: UpdateTerminationProtectionRequest): UpdateTerminationProtectionResponse

    /**
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
     */
    public suspend fun validateTemplate(input: ValidateTemplateRequest = ValidateTemplateRequest { }): ValidateTemplateResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CloudFormationClient.withConfig(block: CloudFormationClient.Config.Builder.() -> Unit): CloudFormationClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloudFormationClient(newConfig)
}

/**
 * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated, the management account has permissions to create and manage StackSets for your organization.
 */
public suspend inline fun CloudFormationClient.activateOrganizationsAccess(crossinline block: ActivateOrganizationsAccessRequest.Builder.() -> Unit): ActivateOrganizationsAccessResponse = activateOrganizationsAccess(ActivateOrganizationsAccessRequest.Builder().apply(block).build())

/**
 * Activates a public third-party extension, such as a resource or module, to make it available for use in stack templates in your current account and Region. It can also create CloudFormation Hooks, which allow you to evaluate resource configurations before CloudFormation provisions them. Hooks integrate with both CloudFormation and Cloud Control API operations.
 *
 * After you activate an extension, you can use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to set specific properties for the extension.
 *
 * To see which extensions have been activated, use [ListTypes](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html). To see configuration details for an extension, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
 *
 * For more information, see [Activate a third-party public extension in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public-activate-extension.html) in the *CloudFormation User Guide*. For information about creating Hooks, see the [CloudFormation Hooks User Guide](https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/what-is-cloudformation-hooks.html).
 */
public suspend inline fun CloudFormationClient.activateType(crossinline block: ActivateTypeRequest.Builder.() -> Unit): ActivateTypeResponse = activateType(ActivateTypeRequest.Builder().apply(block).build())

/**
 * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry in your current account and Region.
 *
 * For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.batchDescribeTypeConfigurations(crossinline block: BatchDescribeTypeConfigurationsRequest.Builder.() -> Unit): BatchDescribeTypeConfigurationsResponse = batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest.Builder().apply(block).build())

/**
 * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
 *
 * You can cancel only stacks that are in the `UPDATE_IN_PROGRESS` state.
 */
public suspend inline fun CloudFormationClient.cancelUpdateStack(crossinline block: CancelUpdateStackRequest.Builder.() -> Unit): CancelUpdateStackResponse = cancelUpdateStack(CancelUpdateStackRequest.Builder().apply(block).build())

/**
 * Continues rolling back a stack from `UPDATE_ROLLBACK_FAILED` to `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually fix the error and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state) and then try to update the stack again.
 *
 * A stack enters the `UPDATE_ROLLBACK_FAILED` state when CloudFormation can't roll back all changes after a failed stack update. For example, this might occur when a stack attempts to roll back to an old database that was deleted outside of CloudFormation. Because CloudFormation doesn't know the instance was deleted, it assumes the instance still exists and attempts to roll back to it, causing the update rollback to fail.
 *
 * For more information, see [Continue rolling back an update](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html) in the *CloudFormation User Guide*. For information for troubleshooting a failed update rollback, see [Update rollback failed](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed).
 */
public suspend inline fun CloudFormationClient.continueUpdateRollback(crossinline block: ContinueUpdateRollbackRequest.Builder.() -> Unit): ContinueUpdateRollbackResponse = continueUpdateRollback(ContinueUpdateRollbackRequest.Builder().apply(block).build())

/**
 * Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
 *
 * To create a change set for a stack that doesn't exist, for the `ChangeSetType` parameter, specify `CREATE`. To create a change set for an existing stack, specify `UPDATE` for the `ChangeSetType` parameter. To create a change set for an import operation, specify `IMPORT` for the `ChangeSetType` parameter. After the `CreateChangeSet` call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action.
 *
 * When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set.
 *
 * To create a change set for the entire stack hierarchy, set `IncludeNestedStacks` to `True`.
 */
public suspend inline fun CloudFormationClient.createChangeSet(crossinline block: CreateChangeSetRequest.Builder.() -> Unit): CreateChangeSetResponse = createChangeSet(CreateChangeSetRequest.Builder().apply(block).build())

/**
 * Creates a template from existing resources that are not already managed with CloudFormation. You can check the status of the template generation using the `DescribeGeneratedTemplate` API action.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.CreateGeneratedTemplate.sample
 */
public suspend inline fun CloudFormationClient.createGeneratedTemplate(crossinline block: CreateGeneratedTemplateRequest.Builder.() -> Unit): CreateGeneratedTemplateResponse = createGeneratedTemplate(CreateGeneratedTemplateRequest.Builder().apply(block).build())

/**
 * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the DescribeStacks operation.
 *
 * For more information about creating a stack and monitoring stack progress, see [Managing Amazon Web Services resources as a single unit with CloudFormation stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.createStack(crossinline block: CreateStackRequest.Builder.() -> Unit): CreateStackResponse = createStack(CreateStackRequest.Builder().apply(block).build())

/**
 * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
 *
 * The maximum number of organizational unit (OUs) supported by a `CreateStackInstances` operation is 50.
 *
 * If you need more than 50, consider the following options:
 * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
 * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
 */
public suspend inline fun CloudFormationClient.createStackInstances(crossinline block: CreateStackInstancesRequest.Builder.() -> Unit): CreateStackInstancesResponse = createStackInstances(CreateStackInstancesRequest.Builder().apply(block).build())

/**
 * Creates a refactor across multiple stacks, with the list of stacks and resources that are affected.
 */
public suspend inline fun CloudFormationClient.createStackRefactor(crossinline block: CreateStackRefactorRequest.Builder.() -> Unit): CreateStackRefactorResponse = createStackRefactor(CreateStackRefactorRequest.Builder().apply(block).build())

/**
 * Creates a StackSet.
 */
public suspend inline fun CloudFormationClient.createStackSet(crossinline block: CreateStackSetRequest.Builder.() -> Unit): CreateStackSetResponse = createStackSet(CreateStackSetRequest.Builder().apply(block).build())

/**
 * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not have permissions to create and manage service-managed StackSets for your organization.
 */
public suspend inline fun CloudFormationClient.deactivateOrganizationsAccess(crossinline block: DeactivateOrganizationsAccessRequest.Builder.() -> Unit): DeactivateOrganizationsAccessResponse = deactivateOrganizationsAccess(DeactivateOrganizationsAccessRequest.Builder().apply(block).build())

/**
 * Deactivates a public third-party extension, such as a resource or module, or a CloudFormation Hook when you no longer use it.
 *
 * Deactivating an extension deletes the configuration details that are associated with it. To temporary disable a CloudFormation Hook instead, you can use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html).
 *
 * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
 *
 * To see which extensions are currently activated, use [ListTypes](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html).
 */
public suspend inline fun CloudFormationClient.deactivateType(crossinline block: DeactivateTypeRequest.Builder.() -> Unit): DeactivateTypeResponse = deactivateType(DeactivateTypeRequest.Builder().apply(block).build())

/**
 * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
 *
 * If the call successfully completes, CloudFormation successfully deleted the change set.
 *
 * If `IncludeNestedStacks` specifies `True` during the creation of the nested change set, then `DeleteChangeSet` will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of `REVIEW_IN_PROGRESS`.
 */
public suspend inline fun CloudFormationClient.deleteChangeSet(crossinline block: DeleteChangeSetRequest.Builder.() -> Unit): DeleteChangeSetResponse = deleteChangeSet(DeleteChangeSetRequest.Builder().apply(block).build())

/**
 * Deleted a generated template.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.DeleteGeneratedTemplate.sample
 */
public suspend inline fun CloudFormationClient.deleteGeneratedTemplate(crossinline block: DeleteGeneratedTemplateRequest.Builder.() -> Unit): DeleteGeneratedTemplateResponse = deleteGeneratedTemplate(DeleteGeneratedTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the DescribeStacks operation if the deletion has been completed successfully.
 *
 * For more information about deleting a stack, see [Delete a stack from the CloudFormation console](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-console-delete-stack.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.deleteStack(crossinline block: DeleteStackRequest.Builder.() -> Unit): DeleteStackResponse = deleteStack(DeleteStackRequest.Builder().apply(block).build())

/**
 * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
 *
 * The maximum number of organizational unit (OUs) supported by a `DeleteStackInstances` operation is 50.
 *
 * If you need more than 50, consider the following options:
 * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
 * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
 */
public suspend inline fun CloudFormationClient.deleteStackInstances(crossinline block: DeleteStackInstancesRequest.Builder.() -> Unit): DeleteStackInstancesResponse = deleteStackInstances(DeleteStackInstancesRequest.Builder().apply(block).build())

/**
 * Deletes a StackSet. Before you can delete a StackSet, all its member stack instances must be deleted. For more information about how to complete this, see DeleteStackInstances.
 */
public suspend inline fun CloudFormationClient.deleteStackSet(crossinline block: DeleteStackSetRequest.Builder.() -> Unit): DeleteStackSetResponse = deleteStackSet(DeleteStackSetRequest.Builder().apply(block).build())

/**
 * Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
 *
 * To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.
 *
 * You can't deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the extension type itself is deregistered as well and marked as deprecated.
 *
 * To view the deprecation status of an extension or extension version, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
 *
 * For more information, see [Remove third-party private extensions from your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private-deregister-extension.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.deregisterType(crossinline block: DeregisterTypeRequest.Builder.() -> Unit): DeregisterTypeResponse = deregisterType(DeregisterTypeRequest.Builder().apply(block).build())

/**
 * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [Understand CloudFormation quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Update CloudFormation stacks using change sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.describeChangeSet(crossinline block: DescribeChangeSetRequest.Builder.() -> Unit): DescribeChangeSetResponse = describeChangeSet(DescribeChangeSetRequest.Builder().apply(block).build())

/**
 * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
 */
public suspend inline fun CloudFormationClient.describeChangeSetHooks(crossinline block: DescribeChangeSetHooksRequest.Builder.() -> Unit): DescribeChangeSetHooksResponse = describeChangeSetHooks(DescribeChangeSetHooksRequest.Builder().apply(block).build())

/**
 * Describes a generated template. The output includes details about the progress of the creation of a generated template started by a `CreateGeneratedTemplate` API action or the update of a generated template started with an `UpdateGeneratedTemplate` API action.
 */
public suspend inline fun CloudFormationClient.describeGeneratedTemplate(crossinline block: DescribeGeneratedTemplateRequest.Builder.() -> Unit): DescribeGeneratedTemplateResponse = describeGeneratedTemplate(DescribeGeneratedTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves information about the account's `OrganizationAccess` status. This API can be called either by the management account or the delegated administrator by using the `CallAs` parameter. This API can also be called without the `CallAs` parameter by the management account.
 */
public suspend inline fun CloudFormationClient.describeOrganizationsAccess(crossinline block: DescribeOrganizationsAccessRequest.Builder.() -> Unit): DescribeOrganizationsAccessResponse = describeOrganizationsAccess(DescribeOrganizationsAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a CloudFormation extension publisher.
 *
 * If you don't supply a `PublisherId`, and you have registered as an extension publisher, `DescribePublisher` returns information about your own publisher account.
 *
 * For more information about registering as a publisher, see:
 * + [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
 * + [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*
 */
public suspend inline fun CloudFormationClient.describePublisher(crossinline block: DescribePublisherRequest.Builder.() -> Unit): DescribePublisherResponse = describePublisher(DescribePublisherRequest.Builder().apply(block).build())

/**
 * Describes details of a resource scan.
 */
public suspend inline fun CloudFormationClient.describeResourceScan(crossinline block: DescribeResourceScanRequest.Builder.() -> Unit): DescribeResourceScanResponse = describeResourceScan(DescribeResourceScanRequest.Builder().apply(block).build())

/**
 * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use DetectStackDrift to initiate a stack drift detection operation. `DetectStackDrift` returns a `StackDriftDetectionId` you can use to monitor the progress of the operation using `DescribeStackDriftDetectionStatus`. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
 */
public suspend inline fun CloudFormationClient.describeStackDriftDetectionStatus(crossinline block: DescribeStackDriftDetectionStatusRequest.Builder.() -> Unit): DescribeStackDriftDetectionStatusResponse = describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.Builder().apply(block).build())

/**
 * Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
 *
 * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).
 */
public suspend inline fun CloudFormationClient.describeStackEvents(crossinline block: DescribeStackEventsRequest.Builder.() -> Unit): DescribeStackEventsResponse = describeStackEvents(DescribeStackEventsRequest.Builder().apply(block).build())

/**
 * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon Web Services Region.
 *
 * For a list of stack instances that are associated with a specific StackSet, use ListStackInstances.
 */
public suspend inline fun CloudFormationClient.describeStackInstance(crossinline block: DescribeStackInstanceRequest.Builder.() -> Unit): DescribeStackInstanceResponse = describeStackInstance(DescribeStackInstanceRequest.Builder().apply(block).build())

/**
 * Describes the stack refactor status.
 */
public suspend inline fun CloudFormationClient.describeStackRefactor(crossinline block: DescribeStackRefactorRequest.Builder.() -> Unit): DescribeStackRefactorResponse = describeStackRefactor(DescribeStackRefactorRequest.Builder().apply(block).build())

/**
 * Returns a description of the specified resource in the specified stack.
 *
 * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.
 */
public suspend inline fun CloudFormationClient.describeStackResource(crossinline block: DescribeStackResourceRequest.Builder.() -> Unit): DescribeStackResourceResponse = describeStackResource(DescribeStackResourceRequest.Builder().apply(block).build())

/**
 * Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
 *
 * For a given stack, there will be one `StackResourceDrift` for each stack resource that has been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't currently support drift detection aren't checked, and so not included. For a list of resources that support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
 *
 * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all supported resources for a given stack.
 */
public suspend inline fun CloudFormationClient.describeStackResourceDrifts(crossinline block: DescribeStackResourceDriftsRequest.Builder.() -> Unit): DescribeStackResourceDriftsResponse = describeStackResourceDrifts(DescribeStackResourceDriftsRequest.Builder().apply(block).build())

/**
 * Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
 *
 * Only the first 100 resources will be returned. If your stack has more resources than this, you should use `ListStackResources` instead.
 *
 * For deleted stacks, `DescribeStackResources` returns resource information for up to 90 days after the stack has been deleted.
 *
 * You must specify either `StackName` or `PhysicalResourceId`, but not both. In addition, you can specify `LogicalResourceId` to filter the returned result. For more information about resources, the `LogicalResourceId` and `PhysicalResourceId`, see the [CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
 *
 * A `ValidationError` is returned if you specify both `StackName` and `PhysicalResourceId` in the same request.
 */
public suspend inline fun CloudFormationClient.describeStackResources(crossinline block: DescribeStackResourcesRequest.Builder.() -> Unit): DescribeStackResourcesResponse = describeStackResources(DescribeStackResourcesRequest.Builder().apply(block).build())

/**
 * Returns the description of the specified StackSet.
 *
 * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
 */
public suspend inline fun CloudFormationClient.describeStackSet(crossinline block: DescribeStackSetRequest.Builder.() -> Unit): DescribeStackSetResponse = describeStackSet(DescribeStackSetRequest.Builder().apply(block).build())

/**
 * Returns the description of the specified StackSet operation.
 *
 * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
 */
public suspend inline fun CloudFormationClient.describeStackSetOperation(crossinline block: DescribeStackSetOperationRequest.Builder.() -> Unit): DescribeStackSetOperationResponse = describeStackSetOperation(DescribeStackSetOperationRequest.Builder().apply(block).build())

/**
 * Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created. For more information about a stack's event history, see [Understand CloudFormation stack creation events](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html) in the *CloudFormation User Guide*.
 *
 * If the stack doesn't exist, a `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.describeStacks(crossinline block: DescribeStacksRequest.Builder.() -> Unit): DescribeStacksResponse = describeStacks(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Returns detailed information about an extension from the CloudFormation registry in your current account and Region.
 *
 * If you specify a `VersionId`, `DescribeType` returns information about that specific extension version. Otherwise, it returns information about the default extension version.
 */
public suspend inline fun CloudFormationClient.describeType(crossinline block: DescribeTypeRequest.Builder.() -> Unit): DescribeTypeResponse = describeType(DescribeTypeRequest.Builder().apply(block).build())

/**
 * Returns information about an extension's registration, including its current status and type and version identifiers.
 *
 * When you initiate a registration request using RegisterType, you can then use DescribeTypeRegistration to monitor the progress of that registration request.
 *
 * Once the registration request has completed, use DescribeType to return detailed information about an extension.
 */
public suspend inline fun CloudFormationClient.describeTypeRegistration(crossinline block: DescribeTypeRegistrationRequest.Builder.() -> Unit): DescribeTypeRegistrationResponse = describeTypeRegistration(DescribeTypeRegistrationRequest.Builder().apply(block).build())

/**
 * Detects whether a stack's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use `DetectStackDrift` to detect drift on all supported resources for a given stack, or DetectStackResourceDrift to detect drift on individual resources.
 *
 * For a list of stack resources that currently support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
 *
 * `DetectStackDrift` can take up to several minutes, depending on the number of resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
 *
 * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that stack. Perform `DetectStackDrift` directly on the nested stack itself.
 */
public suspend inline fun CloudFormationClient.detectStackDrift(crossinline block: DetectStackDriftRequest.Builder.() -> Unit): DetectStackDriftResponse = detectStackDrift(DetectStackDriftRequest.Builder().apply(block).build())

/**
 * Returns information about whether a resource's actual configuration differs, or has *drifted*, from its expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detect unmanaged configuration changes to stacks and resources with drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use `DetectStackResourceDrift` to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
 *
 * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
 */
public suspend inline fun CloudFormationClient.detectStackResourceDrift(crossinline block: DetectStackResourceDriftRequest.Builder.() -> Unit): DetectStackResourceDriftResponse = detectStackResourceDrift(DetectStackResourceDriftRequest.Builder().apply(block).build())

/**
 * Detect drift on a StackSet. When CloudFormation performs drift detection on a StackSet, it performs drift detection on the stack associated with each stack instance in the StackSet. For more information, see [Performing drift detection on CloudFormation StackSets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
 *
 * `DetectStackSetDrift` returns the `OperationId` of the StackSet drift detection operation. Use this operation id with DescribeStackSetOperation to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the StackSet, in addition to the number of resources included in each stack.
 *
 * Once the operation has completed, use the following actions to return drift information:
 * + Use DescribeStackSet to return detailed information about the stack set, including detailed information about the last *completed* drift operation performed on the StackSet. (Information about drift operations that are in progress isn't included.)
 * + Use ListStackInstances to return a list of stack instances belonging to the StackSet, including the drift status and last drift time checked of each instance.
 * + Use DescribeStackInstance to return detailed information about a specific stack instance, including its drift status and last drift time checked.
 *
 * You can only run a single drift detection operation on a given StackSet at one time.
 *
 * To stop a drift detection StackSet operation, use StopStackSetOperation.
 */
public suspend inline fun CloudFormationClient.detectStackSetDrift(crossinline block: DetectStackSetDriftRequest.Builder.() -> Unit): DetectStackSetDriftResponse = detectStackSetDrift(DetectStackSetDriftRequest.Builder().apply(block).build())

/**
 * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
 */
public suspend inline fun CloudFormationClient.estimateTemplateCost(crossinline block: EstimateTemplateCostRequest.Builder.() -> Unit): EstimateTemplateCostResponse = estimateTemplateCost(EstimateTemplateCostRequest.Builder().apply(block).build())

/**
 * Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update.
 *
 * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack.
 *
 * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy.
 *
 * To create a change set for the entire stack hierarchy, `IncludeNestedStacks` must have been set to `True`.
 */
public suspend inline fun CloudFormationClient.executeChangeSet(crossinline block: ExecuteChangeSetRequest.Builder.() -> Unit): ExecuteChangeSetResponse = executeChangeSet(ExecuteChangeSetRequest.Builder().apply(block).build())

/**
 * Executes the stack refactor operation.
 */
public suspend inline fun CloudFormationClient.executeStackRefactor(crossinline block: ExecuteStackRefactorRequest.Builder.() -> Unit): ExecuteStackRefactorResponse = executeStackRefactor(ExecuteStackRefactorRequest.Builder().apply(block).build())

/**
 * Retrieves a generated template. If the template is in an `InProgress` or `Pending` status then the template returned will be the template when the template was last in a `Complete` status. If the template has not yet been in a `Complete` status then an empty template will be returned.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.GetGeneratedTemplate.sample
 * @sample aws.sdk.kotlin.services.cloudformation.samples.GetGeneratedTemplate.sample2
 */
public suspend inline fun CloudFormationClient.getGeneratedTemplate(crossinline block: GetGeneratedTemplateRequest.Builder.() -> Unit): GetGeneratedTemplateResponse = getGeneratedTemplate(GetGeneratedTemplateRequest.Builder().apply(block).build())

/**
 * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
 */
public suspend inline fun CloudFormationClient.getStackPolicy(crossinline block: GetStackPolicyRequest.Builder.() -> Unit): GetStackPolicyResponse = getStackPolicy(GetStackPolicyRequest.Builder().apply(block).build())

/**
 * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
 *
 * For deleted stacks, `GetTemplate` returns the template for up to 90 days after the stack has been deleted.
 *
 * If the template doesn't exist, a `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.getTemplate(crossinline block: GetTemplateRequest.Builder.() -> Unit): GetTemplateResponse = getTemplate(GetTemplateRequest.Builder().apply(block).build())

/**
 * Returns information about a new or existing template. The `GetTemplateSummary` action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or StackSet.
 *
 * You can use the `GetTemplateSummary` action when you submit a template, or you can get template information for a StackSet, or a running or deleted stack.
 *
 * For deleted stacks, `GetTemplateSummary` returns the template information for up to 90 days after the stack has been deleted. If the template doesn't exist, a `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.getTemplateSummary(crossinline block: GetTemplateSummaryRequest.Builder.() -> Unit): GetTemplateSummaryResponse = getTemplateSummary(GetTemplateSummaryRequest.Builder().apply(block).build())

/**
 * Import existing stacks into a new StackSets. Use the stack import operation to import up to 10 stacks into a new StackSet in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
 */
public suspend inline fun CloudFormationClient.importStacksToStackSet(crossinline block: ImportStacksToStackSetRequest.Builder.() -> Unit): ImportStacksToStackSetResponse = importStacksToStackSet(ImportStacksToStackSetRequest.Builder().apply(block).build())

/**
 * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
 */
public suspend inline fun CloudFormationClient.listChangeSets(crossinline block: ListChangeSetsRequest.Builder.() -> Unit): ListChangeSetsResponse = listChangeSets(ListChangeSetsRequest.Builder().apply(block).build())

/**
 * Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the [ Fn::ImportValue](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html) function.
 *
 * For more information, see [Get exported outputs from a deployed CloudFormation stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
 */
public suspend inline fun CloudFormationClient.listExports(crossinline block: ListExportsRequest.Builder.() -> Unit): ListExportsResponse = listExports(ListExportsRequest.Builder().apply(block).build())

/**
 * Lists your generated templates in this Region.
 */
public suspend inline fun CloudFormationClient.listGeneratedTemplates(crossinline block: ListGeneratedTemplatesRequest.Builder.() -> Unit): ListGeneratedTemplatesResponse = listGeneratedTemplates(ListGeneratedTemplatesRequest.Builder().apply(block).build())

/**
 * Returns summaries of invoked Hooks. For more information, see [View CloudFormation Hooks invocations](https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-view-invocations.html) in the *CloudFormation Hooks User Guide*.
 *
 * This operation supports the following parameter combinations:
 * + No parameters: Returns all Hook invocation summaries.
 * + `TypeArn` only: Returns summaries for a specific Hook.
 * + `TypeArn` and `Status`: Returns summaries for a specific Hook filtered by status.
 * + `TargetId` and `TargetType`: Returns summaries for a specific Hook invocation target.
 */
public suspend inline fun CloudFormationClient.listHookResults(crossinline block: ListHookResultsRequest.Builder.() -> Unit): ListHookResultsResponse = listHookResults(ListHookResultsRequest.Builder().apply(block).build())

/**
 * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.
 *
 * For more information about importing an exported output value, see the [Fn::ImportValue](https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/intrinsic-function-reference-importvalue.html) function.
 */
public suspend inline fun CloudFormationClient.listImports(crossinline block: ListImportsRequest.Builder.() -> Unit): ListImportsResponse = listImports(ListImportsRequest.Builder().apply(block).build())

/**
 * Lists the related resources for a list of resources from a resource scan. The response indicates whether each returned resource is already managed by CloudFormation.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanRelatedResources.sample
 */
public suspend inline fun CloudFormationClient.listResourceScanRelatedResources(crossinline block: ListResourceScanRelatedResourcesRequest.Builder.() -> Unit): ListResourceScanRelatedResourcesResponse = listResourceScanRelatedResources(ListResourceScanRelatedResourcesRequest.Builder().apply(block).build())

/**
 * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response indicates whether each returned resource is already managed by CloudFormation.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanResources.sample
 * @sample aws.sdk.kotlin.services.cloudformation.samples.ListResourceScanResources.sample2
 */
public suspend inline fun CloudFormationClient.listResourceScanResources(crossinline block: ListResourceScanResourcesRequest.Builder.() -> Unit): ListResourceScanResourcesResponse = listResourceScanResources(ListResourceScanResourcesRequest.Builder().apply(block).build())

/**
 * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
 */
public suspend inline fun CloudFormationClient.listResourceScans(crossinline block: ListResourceScansRequest.Builder.() -> Unit): ListResourceScansResponse = listResourceScans(ListResourceScansRequest.Builder().apply(block).build())

/**
 * Returns drift information for resources in a stack instance.
 *
 * `ListStackInstanceResourceDrifts` returns drift information for the most recent drift detection operation. If an operation is in progress, it may only return partial results.
 */
public suspend inline fun CloudFormationClient.listStackInstanceResourceDrifts(crossinline block: ListStackInstanceResourceDriftsRequest.Builder.() -> Unit): ListStackInstanceResourceDriftsResponse = listStackInstanceResourceDrifts(ListStackInstanceResourceDriftsRequest.Builder().apply(block).build())

/**
 * Returns summary information about stack instances that are associated with the specified StackSet. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
 */
public suspend inline fun CloudFormationClient.listStackInstances(crossinline block: ListStackInstancesRequest.Builder.() -> Unit): ListStackInstancesResponse = listStackInstances(ListStackInstancesRequest.Builder().apply(block).build())

/**
 * Lists the stack refactor actions that will be taken after calling the ExecuteStackRefactor action.
 */
public suspend inline fun CloudFormationClient.listStackRefactorActions(crossinline block: ListStackRefactorActionsRequest.Builder.() -> Unit): ListStackRefactorActionsResponse = listStackRefactorActions(ListStackRefactorActionsRequest.Builder().apply(block).build())

/**
 * Lists all account stack refactor operations and their statuses.
 */
public suspend inline fun CloudFormationClient.listStackRefactors(crossinline block: ListStackRefactorsRequest.Builder.() -> Unit): ListStackRefactorsResponse = listStackRefactors(ListStackRefactorsRequest.Builder().apply(block).build())

/**
 * Returns descriptions of all resources of the specified stack.
 *
 * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.
 */
public suspend inline fun CloudFormationClient.listStackResources(crossinline block: ListStackResourcesRequest.Builder.() -> Unit): ListStackResourcesResponse = listStackResources(ListStackResourcesRequest.Builder().apply(block).build())

/**
 * Returns summary information about deployment targets for a StackSet.
 */
public suspend inline fun CloudFormationClient.listStackSetAutoDeploymentTargets(crossinline block: ListStackSetAutoDeploymentTargetsRequest.Builder.() -> Unit): ListStackSetAutoDeploymentTargetsResponse = listStackSetAutoDeploymentTargets(ListStackSetAutoDeploymentTargetsRequest.Builder().apply(block).build())

/**
 * Returns summary information about the results of a StackSet operation.
 *
 * This API provides *eventually consistent* reads meaning it may take some time but will eventually return the most up-to-date data.
 */
public suspend inline fun CloudFormationClient.listStackSetOperationResults(crossinline block: ListStackSetOperationResultsRequest.Builder.() -> Unit): ListStackSetOperationResultsResponse = listStackSetOperationResults(ListStackSetOperationResultsRequest.Builder().apply(block).build())

/**
 * Returns summary information about operations performed on a StackSet.
 *
 * This API provides *eventually consistent* reads meaning it may take some time but will eventually return the most up-to-date data.
 */
public suspend inline fun CloudFormationClient.listStackSetOperations(crossinline block: ListStackSetOperationsRequest.Builder.() -> Unit): ListStackSetOperationsResponse = listStackSetOperations(ListStackSetOperationsRequest.Builder().apply(block).build())

/**
 * Returns summary information about StackSets that are associated with the user.
 *
 * This API provides *strongly consistent* reads meaning it will always return the most up-to-date data.
 *
 * + &#91;Self-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to your Amazon Web Services account, `ListStackSets` returns all self-managed StackSets in your Amazon Web Services account.
 * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to the organization's management account, `ListStackSets` returns all StackSets in the management account.
 * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `DELEGATED_ADMIN` while signed in to your member account, `ListStackSets` returns all StackSets with service-managed permissions in the management account.
 */
public suspend inline fun CloudFormationClient.listStackSets(crossinline block: ListStackSetsRequest.Builder.() -> Unit): ListStackSetsResponse = listStackSets(ListStackSetsRequest.Builder().apply(block).build())

/**
 * Returns the summary information for stacks whose status matches the specified `StackStatusFilter`. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no `StackStatusFilter` is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
 */
public suspend inline fun CloudFormationClient.listStacks(crossinline block: ListStacksRequest.Builder.() -> Unit): ListStacksResponse = listStacks(ListStacksRequest.Builder().apply(block).build())

/**
 * Returns a list of registration tokens for the specified extension(s).
 */
public suspend inline fun CloudFormationClient.listTypeRegistrations(crossinline block: ListTypeRegistrationsRequest.Builder.() -> Unit): ListTypeRegistrationsResponse = listTypeRegistrations(ListTypeRegistrationsRequest.Builder().apply(block).build())

/**
 * Returns summary information about the versions of an extension.
 */
public suspend inline fun CloudFormationClient.listTypeVersions(crossinline block: ListTypeVersionsRequest.Builder.() -> Unit): ListTypeVersionsResponse = listTypeVersions(ListTypeVersionsRequest.Builder().apply(block).build())

/**
 * Returns summary information about all extensions, including your private resource types, modules, and Hooks as well as all public extensions from Amazon Web Services and third-party publishers.
 */
public suspend inline fun CloudFormationClient.listTypes(crossinline block: ListTypesRequest.Builder.() -> Unit): ListTypesResponse = listTypes(ListTypesRequest.Builder().apply(block).build())

/**
 * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
 *
 * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
 */
public suspend inline fun CloudFormationClient.publishType(crossinline block: PublishTypeRequest.Builder.() -> Unit): PublishTypeResponse = publishType(PublishTypeRequest.Builder().apply(block).build())

/**
 * Reports progress of a resource handler to CloudFormation.
 *
 * Reserved for use by the [CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html). Don't use this API in your code.
 */
public suspend inline fun CloudFormationClient.recordHandlerProgress(crossinline block: RecordHandlerProgressRequest.Builder.() -> Unit): RecordHandlerProgressResponse = recordHandlerProgress(RecordHandlerProgressRequest.Builder().apply(block).build())

/**
 * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
 *
 * For information about requirements for registering as a public extension publisher, see [Prerequisite: Registering your account to publish CloudFormation extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs) in the *CloudFormation Command Line Interface (CLI) User Guide*.
 */
public suspend inline fun CloudFormationClient.registerPublisher(crossinline block: RegisterPublisherRequest.Builder.() -> Unit): RegisterPublisherResponse = registerPublisher(RegisterPublisherRequest.Builder().apply(block).build())

/**
 * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
 * + Validating the extension schema.
 * + Determining which handlers, if any, have been specified for the extension.
 * + Making the extension available for use in your account.
 *
 * For more information about how to develop extensions and ready them for registration, see [Creating resource types using the CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
 *
 * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per Region. Use [DeregisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html) to deregister specific extension versions if necessary.
 *
 * Once you have initiated a registration request using RegisterType, you can use DescribeTypeRegistration to monitor the progress of the registration request.
 *
 * Once you have registered a private extension in your account and Region, use [SetTypeConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.registerType(crossinline block: RegisterTypeRequest.Builder.() -> Unit): RegisterTypeResponse = registerType(RegisterTypeRequest.Builder().apply(block).build())

/**
 * When specifying `RollbackStack`, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the DescribeStacks operation.
 *
 * Rolls back the specified stack to the last known stable state from `CREATE_FAILED` or `UPDATE_FAILED` stack statuses.
 *
 * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a `*_COMPLETE`. This includes the following stack statuses.
 * + `CREATE_COMPLETE`
 * + `UPDATE_COMPLETE`
 * + `UPDATE_ROLLBACK_COMPLETE`
 * + `IMPORT_COMPLETE`
 * + `IMPORT_ROLLBACK_COMPLETE`
 */
public suspend inline fun CloudFormationClient.rollbackStack(crossinline block: RollbackStackRequest.Builder.() -> Unit): RollbackStackResponse = rollbackStack(RollbackStackRequest.Builder().apply(block).build())

/**
 * Sets a stack policy for a specified stack.
 */
public suspend inline fun CloudFormationClient.setStackPolicy(crossinline block: SetStackPolicyRequest.Builder.() -> Unit): SetStackPolicyResponse = setStackPolicy(SetStackPolicyRequest.Builder().apply(block).build())

/**
 * Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.
 *
 * To view the current configuration data for an extension, refer to the `ConfigurationSchema` element of [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html). For more information, see [Edit configuration data for extensions in your account](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html) in the *CloudFormation User Guide*.
 *
 * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see [Specify values stored in other services using dynamic references](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.setTypeConfiguration(crossinline block: SetTypeConfigurationRequest.Builder.() -> Unit): SetTypeConfigurationResponse = setTypeConfiguration(SetTypeConfigurationRequest.Builder().apply(block).build())

/**
 * Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
 */
public suspend inline fun CloudFormationClient.setTypeDefaultVersion(crossinline block: SetTypeDefaultVersionRequest.Builder.() -> Unit): SetTypeDefaultVersionResponse = setTypeDefaultVersion(SetTypeDefaultVersionRequest.Builder().apply(block).build())

/**
 * Sends a signal to the specified resource with a success or failure status. You can use the `SignalResource` operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The `SignalResource` operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
 */
public suspend inline fun CloudFormationClient.signalResource(crossinline block: SignalResourceRequest.Builder.() -> Unit): SignalResourceResponse = signalResource(SignalResourceRequest.Builder().apply(block).build())

/**
 * Starts a scan of the resources in this account in this Region. You can the status of a scan using the `ListResourceScans` API action.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.StartResourceScan.sample
 */
public suspend inline fun CloudFormationClient.startResourceScan(crossinline block: StartResourceScanRequest.Builder.() -> Unit): StartResourceScanResponse = startResourceScan(StartResourceScanRequest.Builder().apply(block).build())

/**
 * Stops an in-progress operation on a StackSet and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
 */
public suspend inline fun CloudFormationClient.stopStackSetOperation(crossinline block: StopStackSetOperationRequest.Builder.() -> Unit): StopStackSetOperationResponse = stopStackSetOperation(StopStackSetOperationRequest.Builder().apply(block).build())

/**
 * Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
 * + For resource types, this includes passing all contracts tests defined for the type.
 * + For modules, this includes determining if the module's model meets all necessary requirements.
 *
 * For more information, see [Testing your public extension before publishing](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing) in the *CloudFormation Command Line Interface (CLI) User Guide*.
 *
 * If you don't specify a version, CloudFormation uses the default version of the extension in your account and Region for testing.
 *
 * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
 *
 * Once you've initiated testing on an extension using `TestType`, you can pass the returned `TypeVersionArn` into [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html) to monitor the current test status and test status description for the extension.
 *
 * An extension must have a test status of `PASSED` before it can be published. For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
 */
public suspend inline fun CloudFormationClient.testType(crossinline block: TestTypeRequest.Builder.() -> Unit): TestTypeResponse = testType(TestTypeRequest.Builder().apply(block).build())

/**
 * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources, and change the `DeletionPolicy` and `UpdateReplacePolicy` settings. You can check the status of the update to the generated template using the `DescribeGeneratedTemplate` API action.
 *
 * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample
 * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample2
 * @sample aws.sdk.kotlin.services.cloudformation.samples.UpdateGeneratedTemplate.sample3
 */
public suspend inline fun CloudFormationClient.updateGeneratedTemplate(crossinline block: UpdateGeneratedTemplateRequest.Builder.() -> Unit): UpdateGeneratedTemplateResponse = updateGeneratedTemplate(UpdateGeneratedTemplateRequest.Builder().apply(block).build())

/**
 * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the DescribeStacks action.
 *
 * To get a copy of the template for an existing stack, you can use the GetTemplate action.
 *
 * For more information about updating a stack and monitoring the progress of the update, see [Managing Amazon Web Services resources as a single unit with CloudFormation stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.updateStack(crossinline block: UpdateStackRequest.Builder.() -> Unit): UpdateStackResponse = updateStack(UpdateStackRequest.Builder().apply(block).build())

/**
 * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
 *
 * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to create additional stack instances, use [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
 *
 * During StackSet updates, any parameters overridden for a stack instance aren't updated, but retain their overridden value.
 *
 * You can only update the parameter *values* that are specified in the StackSet. To add or delete a parameter itself, use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update the StackSet template. If you add a parameter to a template, before you can override the parameter value specified in the StackSet you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the StackSet. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
 *
 * The maximum number of organizational unit (OUs) supported by a `UpdateStackInstances` operation is 50.
 *
 * If you need more than 50, consider the following options:
 * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
 * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
 */
public suspend inline fun CloudFormationClient.updateStackInstances(crossinline block: UpdateStackInstancesRequest.Builder.() -> Unit): UpdateStackInstancesResponse = updateStackInstances(UpdateStackInstancesRequest.Builder().apply(block).build())

/**
 * Updates the StackSet and associated stack instances in the specified accounts and Amazon Web Services Regions.
 *
 * Even if the StackSet operation created by updating the StackSet fails (completely or partially, below or above a specified failure tolerance), the StackSet is updated with your changes. Subsequent CreateStackInstances calls on the specified StackSet use the updated StackSet.
 *
 * The maximum number of organizational unit (OUs) supported by a `UpdateStackSet` operation is 50.
 *
 * If you need more than 50, consider the following options:
 * + *Batch processing:* If you don't want to expose your OU hierarchy, split up the operations into multiple calls with less than 50 OUs each.
 * + *Parent OU strategy:* If you don't mind exposing the OU hierarchy, target a parent OU that contains all desired child OUs.
 */
public suspend inline fun CloudFormationClient.updateStackSet(crossinline block: UpdateStackSetRequest.Builder.() -> Unit): UpdateStackSetResponse = updateStackSet(UpdateStackSetRequest.Builder().apply(block).build())

/**
 * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protect a CloudFormation stack from being deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
 *
 * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
 */
public suspend inline fun CloudFormationClient.updateTerminationProtection(crossinline block: UpdateTerminationProtectionRequest.Builder.() -> Unit): UpdateTerminationProtectionResponse = updateTerminationProtection(UpdateTerminationProtectionRequest.Builder().apply(block).build())

/**
 * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
 */
public suspend inline fun CloudFormationClient.validateTemplate(crossinline block: ValidateTemplateRequest.Builder.() -> Unit): ValidateTemplateResponse = validateTemplate(ValidateTemplateRequest.Builder().apply(block).build())
