// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.AutoDeployment
import aws.sdk.kotlin.services.cloudformation.model.CallAs
import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets
import aws.sdk.kotlin.services.cloudformation.model.ManagedExecution
import aws.sdk.kotlin.services.cloudformation.model.Parameter
import aws.sdk.kotlin.services.cloudformation.model.PermissionModels
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences
import aws.sdk.kotlin.services.cloudformation.model.Tag
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateStackSetOperationSerializer: HttpSerializer.NonStreaming<UpdateStackSetRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateStackSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateStackSetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeUpdateStackSetOperationBody(context: ExecutionContext, input: UpdateStackSetRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Accounts"))
    val ADMINISTRATIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AdministrationRoleARN"))
    val AUTODEPLOYMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("AutoDeployment"))
    val CALLAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("CallAs"))
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Capabilities"))
    val DEPLOYMENTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("DeploymentTargets"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val EXECUTIONROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ExecutionRoleName"))
    val MANAGEDEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ManagedExecution"))
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OperationId"))
    val OPERATIONPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("OperationPreferences"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Parameters"))
    val PERMISSIONMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("PermissionModel"))
    val REGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Regions"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackSetName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateBody"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateURL"))
    val USEPREVIOUSTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UsePreviousTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("UpdateStackSetInput"))
        trait(QueryLiteral("Action", "UpdateStackSet"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(ACCOUNTS_DESCRIPTOR)
        field(ADMINISTRATIONROLEARN_DESCRIPTOR)
        field(AUTODEPLOYMENT_DESCRIPTOR)
        field(CALLAS_DESCRIPTOR)
        field(CAPABILITIES_DESCRIPTOR)
        field(DEPLOYMENTTARGETS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXECUTIONROLENAME_DESCRIPTOR)
        field(MANAGEDEXECUTION_DESCRIPTOR)
        field(OPERATIONID_DESCRIPTOR)
        field(OPERATIONPREFERENCES_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PERMISSIONMODEL_DESCRIPTOR)
        field(REGIONS_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
        field(USEPREVIOUSTEMPLATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.accounts != null) {
            listField(ACCOUNTS_DESCRIPTOR) {
                for (el0 in input.accounts) {
                    serializeString(el0)
                }
            }
        }
        input.administrationRoleArn?.let { field(ADMINISTRATIONROLEARN_DESCRIPTOR, it) }
        input.autoDeployment?.let { field(AUTODEPLOYMENT_DESCRIPTOR, it, ::serializeAutoDeploymentDocument) }
        input.callAs?.let { field(CALLAS_DESCRIPTOR, it.value) }
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0.value)
                }
            }
        }
        input.deploymentTargets?.let { field(DEPLOYMENTTARGETS_DESCRIPTOR, it, ::serializeDeploymentTargetsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.executionRoleName?.let { field(EXECUTIONROLENAME_DESCRIPTOR, it) }
        input.managedExecution?.let { field(MANAGEDEXECUTION_DESCRIPTOR, it, ::serializeManagedExecutionDocument) }
        input.operationId?.let { field(OPERATIONID_DESCRIPTOR, it) } ?: field(OPERATIONID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.operationPreferences?.let { field(OPERATIONPREFERENCES_DESCRIPTOR, it, ::serializeStackSetOperationPreferencesDocument) }
        if (input.parameters != null) {
            listField(PARAMETERS_DESCRIPTOR) {
                for (el0 in input.parameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeParameterDocument))
                }
            }
        }
        input.permissionModel?.let { field(PERMISSIONMODEL_DESCRIPTOR, it.value) }
        if (input.regions != null) {
            listField(REGIONS_DESCRIPTOR) {
                for (el0 in input.regions) {
                    serializeString(el0)
                }
            }
        }
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.templateBody?.let { field(TEMPLATEBODY_DESCRIPTOR, it) }
        input.templateUrl?.let { field(TEMPLATEURL_DESCRIPTOR, it) }
        input.usePreviousTemplate?.let { field(USEPREVIOUSTEMPLATE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
